/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.sequence.business.internal.elements;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import java.text.MessageFormat;
import java.util.List;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmf.runtime.notation.Bounds;
import org.eclipse.gmf.runtime.notation.Node;
import org.eclipse.gmf.runtime.notation.NotationPackage;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.sirius.diagram.DDiagramElement;
import org.eclipse.sirius.diagram.sequence.Messages;
import org.eclipse.sirius.diagram.sequence.business.internal.elements.AbstractFrame;
import org.eclipse.sirius.diagram.sequence.business.internal.elements.AbstractSequenceElement;
import org.eclipse.sirius.diagram.sequence.business.internal.elements.AbstractSequenceNode;
import org.eclipse.sirius.diagram.sequence.business.internal.elements.ISequenceElementAccessor;
import org.eclipse.sirius.diagram.sequence.business.internal.elements.ISequenceEvent;
import org.eclipse.sirius.diagram.sequence.business.internal.elements.InstanceRole;
import org.eclipse.sirius.diagram.sequence.business.internal.elements.Lifeline;
import org.eclipse.sirius.diagram.sequence.business.internal.elements.Message;
import org.eclipse.sirius.diagram.sequence.business.internal.elements.NotationPredicate;
import org.eclipse.sirius.diagram.sequence.business.internal.elements.Operand;
import org.eclipse.sirius.diagram.sequence.business.internal.elements.State;
import org.eclipse.sirius.diagram.sequence.business.internal.query.SequenceNodeQuery;
import org.eclipse.sirius.diagram.sequence.business.internal.util.CacheHelper;
import org.eclipse.sirius.diagram.sequence.business.internal.util.ParentOperandFinder;
import org.eclipse.sirius.diagram.sequence.business.internal.util.RangeSetter;
import org.eclipse.sirius.diagram.sequence.description.DescriptionPackage;
import org.eclipse.sirius.diagram.sequence.util.Range;
import org.eclipse.sirius.ext.base.Option;

public abstract class AbstractNodeEvent
extends AbstractSequenceNode
implements ISequenceEvent {
    public static final Predicate<ISequenceEvent> NO_REPARENTABLE_EVENTS = new Predicate<ISequenceEvent>(){

        public boolean apply(ISequenceEvent input) {
            return input instanceof AbstractFrame || input instanceof State || input instanceof Operand || input instanceof Message;
        }
    };
    public static final int VISUAL_ID = 3001;

    AbstractNodeEvent(Node node) {
        super(node);
        Preconditions.checkArgument((boolean)AbstractNodeEvent.notationPredicate().apply((Object)node), (Object)Messages.AbstractNodeEvent_nonAbstractNodeEventNode);
    }

    public static Predicate<View> notationPredicate() {
        return new NotationPredicate(NotationPackage.eINSTANCE.getNode(), 3001, AbstractNodeEvent.viewpointElementPredicate());
    }

    public static Predicate<DDiagramElement> viewpointElementPredicate() {
        return SiriusElementPredicate.INSTANCE;
    }

    @Override
    public ISequenceEvent getParentEvent() {
        ISequenceEvent parentEvent;
        if (CacheHelper.isStructuralCacheEnabled() && (parentEvent = CacheHelper.getEventToParentEventCache().get(this)) != null) {
            return parentEvent;
        }
        ISequenceEvent parent = this.getHierarchicalParentEvent();
        List<ISequenceEvent> potentialSiblings = parent.getSubEvents();
        if (!potentialSiblings.contains(this)) {
            parent = (ISequenceEvent)this.getParentOperand().get();
        }
        if (CacheHelper.isStructuralCacheEnabled()) {
            CacheHelper.getEventToParentEventCache().put(this, parent);
        }
        return parent;
    }

    public Option<Operand> getParentOperand(int verticalPosition) {
        return new ParentOperandFinder(this).getParentOperand(new Range(verticalPosition, verticalPosition));
    }

    public Option<Operand> getParentOperand(Range range) {
        return new ParentOperandFinder(this).getParentOperand(range);
    }

    @Override
    public Option<Operand> getParentOperand() {
        Option<Operand> parentOperand;
        if (CacheHelper.isStructuralCacheEnabled() && (parentOperand = CacheHelper.getEventToParentOperandCache().get(this)) != null) {
            return parentOperand;
        }
        parentOperand = new ParentOperandFinder(this).getParentOperand();
        if (CacheHelper.isStructuralCacheEnabled()) {
            CacheHelper.getEventToParentOperandCache().put(this, parentOperand);
        }
        return parentOperand;
    }

    @Override
    public Range getVerticalRange() {
        return new SequenceNodeQuery(this.getNotationNode()).getVerticalRange();
    }

    @Override
    public void setVerticalRange(Range range) throws IllegalStateException {
        RangeSetter.setVerticalRange(this, range);
    }

    @Override
    public Rectangle getProperLogicalBounds() {
        if (this.getNotationNode().getLayoutConstraint() instanceof Bounds) {
            Bounds bounds = (Bounds)this.getNotationNode().getLayoutConstraint();
            ISequenceEvent parent = this.getHierarchicalParentEvent();
            Rectangle parentLogicalBounds = parent.getProperLogicalBounds();
            Point location = this.getProperLogicalLocation(parent, bounds, parentLogicalBounds);
            Dimension size = new Dimension(bounds.getWidth(), bounds.getHeight());
            return new Rectangle(location, size);
        }
        throw new RuntimeException();
    }

    private Point getProperLogicalLocation(ISequenceEvent parent, Bounds bounds, Rectangle parentLogicalBounds) {
        int x = parentLogicalBounds.x;
        int y = parentLogicalBounds.y + bounds.getY();
        if (Lifeline.notationPredicate().apply((Object)parent.getNotationView()) || this instanceof State) {
            Point top = parentLogicalBounds.getTop();
            int width = bounds.getWidth();
            x = top.x - width / 2;
        } else {
            Point topRight = parentLogicalBounds.getTopRight();
            x = topRight.x - 5;
        }
        return new Point(x, y);
    }

    public abstract List<Message> getLinkedMessages();

    protected ISequenceEvent getHierarchicalParentEvent(String noFoundParentExceptionMessage) {
        View parentView;
        Option<ISequenceEvent> parentElement;
        ISequenceEvent hierarchicalParent;
        if (CacheHelper.isStructuralCacheEnabled() && (hierarchicalParent = CacheHelper.getAbstractNodeEventToHierarchicalParentCache().get(this)) != null) {
            return hierarchicalParent;
        }
        EObject viewContainer = this.view.eContainer();
        if (viewContainer instanceof View && (parentElement = ISequenceElementAccessor.getISequenceEvent(parentView = (View)viewContainer)).some()) {
            if (CacheHelper.isStructuralCacheEnabled()) {
                CacheHelper.getAbstractNodeEventToHierarchicalParentCache().put(this, (ISequenceEvent)parentElement.get());
            }
            return (ISequenceEvent)parentElement.get();
        }
        throw new RuntimeException(MessageFormat.format(noFoundParentExceptionMessage, this));
    }

    private static enum SiriusElementPredicate implements Predicate<DDiagramElement>
    {
        INSTANCE;


        public boolean apply(DDiagramElement input) {
            return (AbstractSequenceElement.isSequenceDiagramElement(input, DescriptionPackage.eINSTANCE.getExecutionMapping()) || AbstractSequenceElement.isSequenceDiagramElement(input, DescriptionPackage.eINSTANCE.getStateMapping())) && !InstanceRole.viewpointElementPredicate().apply((Object)((DDiagramElement)input.eContainer()));
        }
    }
}

