/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.ui.tools.internal.routers;

import org.eclipse.draw2d.Connection;
import org.eclipse.draw2d.ConnectionAnchor;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PointList;
import org.eclipse.draw2d.geometry.PrecisionRectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.gef.handles.HandleBounds;
import org.eclipse.gmf.runtime.draw2d.ui.internal.routers.RectilinearRouter;
import org.eclipse.sirius.diagram.ui.edit.api.part.AbstractDiagramEdgeEditPart;
import org.eclipse.sirius.diagram.ui.tools.internal.routers.RectilinearEdgeUtil;

public class SiriusRectilinearRouter
extends RectilinearRouter {
    public void routeLine(Connection conn, int nestedRoutingDepth, PointList newLine) {
        if (newLine.size() > 1) {
            super.routeLine(conn, nestedRoutingDepth, newLine);
            if (!this.isReorienting(conn)) {
                this.handleEdgeCentering(conn, newLine);
            }
        }
    }

    private void handleEdgeCentering(Connection conn, PointList newLine) {
        if (conn instanceof AbstractDiagramEdgeEditPart.ViewEdgeFigure && (((AbstractDiagramEdgeEditPart.ViewEdgeFigure)conn).isSourceCentered() || ((AbstractDiagramEdgeEditPart.ViewEdgeFigure)conn).isTargetCentered())) {
            Point srcRefPoint = null;
            Point tgtRefPoint = null;
            if (((AbstractDiagramEdgeEditPart.ViewEdgeFigure)conn).isSourceCentered()) {
                srcRefPoint = this.getAnchorOwnerCenter(conn.getSourceAnchor());
            }
            if (((AbstractDiagramEdgeEditPart.ViewEdgeFigure)conn).isTargetCentered()) {
                tgtRefPoint = this.getAnchorOwnerCenter(conn.getTargetAnchor());
            }
            if (srcRefPoint == null) {
                ConnectionAnchor srcAnchor = conn.getSourceAnchor();
                srcRefPoint = srcAnchor.getReferencePoint();
            }
            if (tgtRefPoint == null) {
                ConnectionAnchor tgtAnchor = conn.getTargetAnchor();
                tgtRefPoint = tgtAnchor.getReferencePoint();
            }
            conn.translateToRelative((Translatable)srcRefPoint);
            conn.translateToRelative((Translatable)tgtRefPoint);
            RectilinearEdgeUtil.centerEdgeEnds(newLine, srcRefPoint, tgtRefPoint, ((AbstractDiagramEdgeEditPart.ViewEdgeFigure)conn).getCenteringStyle());
        }
    }

    private Point getAnchorOwnerCenter(ConnectionAnchor anchor) {
        PrecisionRectangle rBox = anchor.getOwner() instanceof HandleBounds ? new PrecisionRectangle(((HandleBounds)anchor.getOwner()).getHandleBounds()) : new PrecisionRectangle(anchor.getOwner().getBounds());
        anchor.getOwner().translateToAbsolute((Translatable)rBox);
        return rBox.getCenter();
    }
}

