/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ui.editor.contentassist;

import com.google.inject.Inject;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.swt.graphics.Image;
import org.eclipse.xtext.AbstractElement;
import org.eclipse.xtext.Assignment;
import org.eclipse.xtext.Keyword;
import org.eclipse.xtext.RuleCall;
import org.eclipse.xtext.conversion.IValueConverterService;
import org.eclipse.xtext.naming.IQualifiedNameConverter;
import org.eclipse.xtext.naming.QualifiedName;
import org.eclipse.xtext.resource.IEObjectDescription;
import org.eclipse.xtext.ui.editor.contentassist.AbstractCompletionProposalFactory;
import org.eclipse.xtext.ui.editor.contentassist.ContentAssistContext;
import org.eclipse.xtext.ui.editor.contentassist.ContentProposalLabelProvider;
import org.eclipse.xtext.ui.editor.contentassist.ICompletionProposalAcceptor;
import org.eclipse.xtext.ui.editor.contentassist.IContentProposalProvider;
import org.eclipse.xtext.ui.editor.contentassist.IFollowElementAcceptor;
import org.eclipse.xtext.util.XtextSwitch;

public abstract class AbstractContentProposalProvider
extends AbstractCompletionProposalFactory
implements IContentProposalProvider {
    @Inject
    @ContentProposalLabelProvider
    private ILabelProvider labelProvider;
    @Inject
    private IQualifiedNameConverter qualifiedNameConverter;
    @Inject
    private IValueConverterService valueConverter;

    @Override
    public void createProposals(ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        NullSafeCompletionProposalAcceptor nullSafe = new NullSafeCompletionProposalAcceptor(acceptor);
        IFollowElementAcceptor selector = this.createSelector(context, nullSafe);
        for (AbstractElement element : context.getFirstSetGrammarElements()) {
            selector.accept(element);
        }
    }

    public abstract void completeKeyword(Keyword var1, ContentAssistContext var2, ICompletionProposalAcceptor var3);

    public abstract void completeRuleCall(RuleCall var1, ContentAssistContext var2, ICompletionProposalAcceptor var3);

    public abstract void completeAssignment(Assignment var1, ContentAssistContext var2, ICompletionProposalAcceptor var3);

    public IFollowElementAcceptor createSelector(ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        return new DefaultContentAssistProcessorSwitch(context, acceptor);
    }

    protected StyledString getKeywordDisplayString(Keyword keyword) {
        return new StyledString(keyword.getValue());
    }

    protected StyledString getStyledDisplayString(IEObjectDescription description) {
        return this.getStyledDisplayString(description.getEObjectOrProxy(), this.qualifiedNameConverter.toString(description.getQualifiedName()), this.qualifiedNameConverter.toString(description.getName()));
    }

    protected StyledString getStyledDisplayString(EObject element, String qualifiedName, String shortName) {
        return new StyledString(this.getDisplayString(element, qualifiedName, shortName));
    }

    protected String getDisplayString(EObject element, String qualifiedNameAsString, String shortName) {
        QualifiedName qualifiedName;
        if (qualifiedNameAsString == null) {
            qualifiedNameAsString = shortName;
        }
        if (qualifiedNameAsString == null) {
            if (element != null) {
                qualifiedNameAsString = this.labelProvider.getText((Object)element);
            } else {
                return null;
            }
        }
        if ((qualifiedName = this.qualifiedNameConverter.toQualifiedName(qualifiedNameAsString)).getSegmentCount() > 1) {
            return String.valueOf(qualifiedName.getLastSegment()) + " - " + qualifiedNameAsString;
        }
        return qualifiedNameAsString;
    }

    public void setValueConverter(IValueConverterService valueConverter) {
        this.valueConverter = valueConverter;
    }

    public IValueConverterService getValueConverter() {
        return this.valueConverter;
    }

    protected Image getImage(IEObjectDescription description) {
        return this.getImage(description.getEObjectOrProxy());
    }

    protected Image getImage(EObject eObject) {
        return this.labelProvider.getImage((Object)eObject);
    }

    public IQualifiedNameConverter getQualifiedNameConverter() {
        return this.qualifiedNameConverter;
    }

    public void setLabelProvider(ILabelProvider labelProvider) {
        this.labelProvider = labelProvider;
    }

    public ILabelProvider getLabelProvider() {
        return this.labelProvider;
    }

    public class DefaultContentAssistProcessorSwitch
    extends XtextSwitch<Boolean>
    implements IFollowElementAcceptor {
        private final ContentAssistContext context;
        private final ICompletionProposalAcceptor acceptor;

        public DefaultContentAssistProcessorSwitch(ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
            this.context = context;
            this.acceptor = acceptor;
        }

        public Boolean defaultCase(EObject object) {
            return Boolean.TRUE;
        }

        public Boolean caseKeyword(Keyword object) {
            AbstractContentProposalProvider.this.completeKeyword(object, this.context, this.acceptor);
            return Boolean.TRUE;
        }

        public Boolean caseRuleCall(RuleCall object) {
            AbstractContentProposalProvider.this.completeRuleCall(object, this.context, this.acceptor);
            return Boolean.TRUE;
        }

        public Boolean caseAssignment(Assignment object) {
            AbstractContentProposalProvider.this.completeAssignment(object, this.context, this.acceptor);
            return Boolean.TRUE;
        }

        @Override
        public void accept(AbstractElement element) {
            this.doSwitch((EObject)element);
        }
    }

    public static class NullSafeCompletionProposalAcceptor
    extends ICompletionProposalAcceptor.Delegate {
        public NullSafeCompletionProposalAcceptor(ICompletionProposalAcceptor delegate) {
            super(delegate);
        }

        @Override
        public void accept(ICompletionProposal proposal) {
            if (proposal != null) {
                super.accept(proposal);
            }
        }
    }
}

