/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.mvc.fx.gestures;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javafx.animation.PauseTransition;
import javafx.beans.property.ReadOnlyObjectProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.event.EventHandler;
import javafx.event.EventTarget;
import javafx.scene.Node;
import javafx.scene.Scene;
import javafx.scene.input.ScrollEvent;
import javafx.util.Duration;
import org.eclipse.gef.mvc.fx.gestures.AbstractGesture;
import org.eclipse.gef.mvc.fx.handlers.IOnScrollHandler;
import org.eclipse.gef.mvc.fx.parts.PartUtils;
import org.eclipse.gef.mvc.fx.viewer.IViewer;

public class ScrollGesture
extends AbstractGesture {
    public static final Class<IOnScrollHandler> ON_SCROLL_POLICY_KEY = IOnScrollHandler.class;
    public static final int DEFAULT_FINISH_DELAY_MILLIS = 180;
    private final Map<IViewer, ChangeListener<Boolean>> viewerFocusChangeListeners = new IdentityHashMap<IViewer, ChangeListener<Boolean>>();
    private final Set<IViewer> inScroll = new HashSet<IViewer>();
    private final Map<IViewer, PauseTransition> finishDelayTransitions = new HashMap<IViewer, PauseTransition>();
    private final Map<IViewer, EventHandler<ScrollEvent>> scrollFilters = new HashMap<IViewer, EventHandler<ScrollEvent>>();
    private final Map<EventHandler<ScrollEvent>, Scene> scrollFilterScenes = new HashMap<EventHandler<ScrollEvent>, Scene>();

    @Override
    protected void abortPolicies(IViewer viewer) {
        this.inScroll.remove(viewer);
        super.abortPolicies(viewer);
    }

    protected PauseTransition createFinishDelayTransition(IViewer viewer) {
        PauseTransition pauseTransition = new PauseTransition(Duration.millis((double)this.getFinishDelayMillis()));
        pauseTransition.setOnFinished(ae -> {
            this.scrollFinished(viewer);
            this.inScroll.remove(viewer);
        });
        return pauseTransition;
    }

    protected EventHandler<ScrollEvent> createScrollFilter(final IViewer viewer) {
        return new EventHandler<ScrollEvent>(){

            public void handle(ScrollEvent event) {
                if (!(event.getTarget() instanceof Node) || PartUtils.retrieveViewer(ScrollGesture.this.getDomain(), (Node)event.getTarget()) != viewer) {
                    return;
                }
                ScrollGesture.this.playFinishDelayTransition(viewer);
                if (!ScrollGesture.this.inScroll.contains(viewer)) {
                    ScrollGesture.this.inScroll.add(viewer);
                    ScrollGesture.this.scrollStarted(viewer, event);
                } else {
                    ScrollGesture.this.scroll(viewer, event);
                }
            }
        };
    }

    @Override
    protected void doAbortPolicies(IViewer viewer) {
        for (IOnScrollHandler iOnScrollHandler : this.getActiveHandlers(viewer)) {
            iOnScrollHandler.abortScroll();
        }
    }

    @Override
    protected void doActivate() {
        for (IViewer viewer : this.getDomain().getViewers().values()) {
            ChangeListener<Boolean> viewerFocusChangeListener = this.createFocusChangeListener(viewer);
            viewer.viewerFocusedProperty().addListener(viewerFocusChangeListener);
            this.viewerFocusChangeListeners.put(viewer, viewerFocusChangeListener);
            ChangeListener sceneListener = (exp, oldScene, newScene) -> {
                if (oldScene != null) {
                    this.unhookScene(viewer);
                }
                if (newScene != null) {
                    this.hookScene((Scene)newScene, viewer);
                }
            };
            ReadOnlyObjectProperty sceneProperty = viewer.getCanvas().sceneProperty();
            sceneProperty.addListener(sceneListener);
            if (sceneProperty.get() == null) continue;
            sceneListener.changed((ObservableValue)sceneProperty, null, sceneProperty.get());
        }
    }

    @Override
    protected void doDeactivate() {
        for (IViewer viewer : new ArrayList<IViewer>(this.viewerFocusChangeListeners.keySet())) {
            this.abortPolicies(viewer);
            if (this.finishDelayTransitions.containsKey(viewer)) {
                this.finishDelayTransitions.remove(viewer).stop();
            }
            this.unhookScene(viewer);
            viewer.viewerFocusedProperty().removeListener(this.viewerFocusChangeListeners.remove(viewer));
        }
    }

    public List<? extends IOnScrollHandler> getActiveHandlers(IViewer viewer) {
        return super.getActiveHandlers(viewer);
    }

    protected long getFinishDelayMillis() {
        return 180L;
    }

    private void hookScene(Scene scene, IViewer viewer) {
        EventHandler<ScrollEvent> scrollFilter = this.createScrollFilter(viewer);
        this.scrollFilters.put(viewer, scrollFilter);
        this.scrollFilterScenes.put(scrollFilter, scene);
        scene.addEventFilter(ScrollEvent.SCROLL, scrollFilter);
    }

    protected void playFinishDelayTransition(IViewer viewer) {
        if (!this.finishDelayTransitions.containsKey(viewer)) {
            this.finishDelayTransitions.put(viewer, this.createFinishDelayTransition(viewer));
        }
        PauseTransition pauseTransition = this.finishDelayTransitions.get(viewer);
        pauseTransition.stop();
        pauseTransition.setDuration(Duration.millis((double)this.getFinishDelayMillis()));
        pauseTransition.playFromStart();
    }

    protected void scroll(IViewer viewer, ScrollEvent event) {
        for (IOnScrollHandler iOnScrollHandler : this.getActiveHandlers(viewer)) {
            iOnScrollHandler.scroll(event);
        }
    }

    protected void scrollFinished(IViewer viewer) {
        for (IOnScrollHandler iOnScrollHandler : this.getActiveHandlers(viewer)) {
            iOnScrollHandler.endScroll();
        }
        this.clearActiveHandlers(viewer);
        this.getDomain().closeExecutionTransaction(this);
    }

    protected void scrollStarted(IViewer viewer, ScrollEvent event) {
        EventTarget eventTarget = event.getTarget();
        this.getDomain().openExecutionTransaction(this);
        this.setActiveHandlers(viewer, this.getHandlerResolver().resolve(this, eventTarget instanceof Node ? (Node)eventTarget : null, viewer, ON_SCROLL_POLICY_KEY));
        for (IOnScrollHandler iOnScrollHandler : this.getActiveHandlers(viewer)) {
            iOnScrollHandler.startScroll(event);
        }
    }

    private void unhookScene(IViewer viewer) {
        EventHandler<ScrollEvent> filter = this.scrollFilters.remove(viewer);
        this.scrollFilterScenes.remove(filter).removeEventFilter(ScrollEvent.SCROLL, filter);
    }
}

