/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsp.core.internal.taglib;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResourceProxy;
import org.eclipse.core.resources.IResourceProxyVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jdt.core.ElementChangedEvent;
import org.eclipse.jdt.core.IElementChangedListener;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaElementDelta;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jst.jsp.core.internal.JSPCoreMessages;
import org.eclipse.jst.jsp.core.internal.contenttype.DeploymentDescriptorPropertyCache;
import org.eclipse.jst.jsp.core.internal.java.JSPTranslatorPersister;
import org.eclipse.jst.jsp.core.internal.provisional.contenttype.ContentTypeIdForJSP;
import org.eclipse.jst.jsp.core.internal.taglib.TaglibHelper;
import org.eclipse.jst.jsp.core.internal.taglib.TaglibHelperCache;

public class TaglibHelperManager
implements IElementChangedListener {
    private static TaglibHelperManager instance = null;
    private TaglibHelperCache fCache = new TaglibHelperCache(3);

    private TaglibHelperManager() {
    }

    public static synchronized TaglibHelperManager getInstance() {
        if (instance == null) {
            instance = new TaglibHelperManager();
        }
        return instance;
    }

    public TaglibHelper getTaglibHelper(IFile f) {
        IProject p = f.getProject();
        return this.getHelperFromCache(p);
    }

    private TaglibHelper getHelperFromCache(IProject project) {
        return this.fCache.getHelper(project);
    }

    public void elementChanged(ElementChangedEvent event) {
        block5: {
            IJavaElementDelta delta;
            block4: {
                delta = event.getDelta();
                if (delta.getElement().getElementType() != 1) break block4;
                IJavaElementDelta[] changed = delta.getChangedChildren();
                int i = 0;
                while (i < changed.length) {
                    if ((changed[i].getFlags() & 0x20000) != 0 || (changed[i].getFlags() & 0x100) != 0 || (changed[i].getFlags() & 0x200000) != 0 || (changed[i].getFlags() & 0x40000) != 0) {
                        IJavaElement project = changed[i].getElement();
                        this.handleClasspathChange(changed, i, project);
                        DeploymentDescriptorPropertyCache.getInstance().invalidate(project.getJavaProject().getElementName());
                    }
                    ++i;
                }
                break block5;
            }
            if (delta.getElement().getElementType() != 5) break block5;
            IJavaElementDelta[] changed = delta.getChangedChildren();
            int i = 0;
            while (i < changed.length) {
                if ((changed[i].getFlags() & 0x800) != 0) {
                    IJavaElement element = changed[i].getElement();
                    this.handleSuperTypeChange(element);
                }
                ++i;
            }
        }
    }

    private void handleSuperTypeChange(IJavaElement element) {
        IJavaProject project = element.getJavaProject();
        if (element instanceof IType) {
            this.fCache.invalidate(project.getProject().getName(), ((IType)element).getFullyQualifiedName());
        }
    }

    private void handleClasspathChange(IJavaElementDelta[] changed, int i, IJavaElement proj) {
        if (proj.getElementType() == 2) {
            final IProject project = ((IJavaProject)proj).getProject();
            String projectName = project.getName();
            this.fCache.removeHelper(projectName);
            Job toucher = new Job(JSPCoreMessages.Processing_BuildPath_Changes){

                protected IStatus run(IProgressMonitor monitor) {
                    try {
                        project.accept(new IResourceProxyVisitor(){

                            public boolean visit(IResourceProxy proxy) throws CoreException {
                                if (!proxy.isDerived() && ContentTypeIdForJSP.indexOfJSPExtension(proxy.getName()) >= 0) {
                                    JSPTranslatorPersister.removePersistedTranslation(proxy.requestResource());
                                }
                                return !proxy.isDerived();
                            }
                        }, 2);
                    }
                    catch (CoreException coreException) {}
                    return Status.OK_STATUS;
                }
            };
            toucher.setRule((ISchedulingRule)project.getProject());
            toucher.setPriority(40);
            toucher.setUser(false);
            toucher.setSystem(false);
            toucher.schedule();
        }
    }
}

