/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.server.tomcat.core.internal;

import java.io.File;
import java.util.ArrayList;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.IAccessRule;
import org.eclipse.jdt.core.IClasspathAttribute;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jst.server.core.RuntimeClasspathProviderDelegate;
import org.eclipse.wst.common.project.facet.core.IFacetedProject;
import org.eclipse.wst.common.project.facet.core.IProjectFacet;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;
import org.eclipse.wst.server.core.IRuntime;

public class TomcatRuntimeClasspathProvider
extends RuntimeClasspathProviderDelegate {
    private static final String JST_WEB_FACET_ID = "jst.web";

    private final String getEEJavadocLocation(IProject project) {
        int eeVersion = 9;
        try {
            IProjectFacet webModuleFacet;
            IFacetedProject faceted = ProjectFacetsManager.create((IProject)project);
            if (faceted != null && ProjectFacetsManager.isProjectFacetDefined((String)JST_WEB_FACET_ID) && faceted.hasProjectFacet(webModuleFacet = ProjectFacetsManager.getProjectFacet((String)JST_WEB_FACET_ID))) {
                String servletVersionStr = faceted.getInstalledVersion(webModuleFacet).getVersionString();
                if (servletVersionStr.equals("5.0")) {
                    eeVersion = 9;
                } else if (servletVersionStr.equals("4.0")) {
                    eeVersion = 8;
                } else if (servletVersionStr.equals("3.1")) {
                    eeVersion = 7;
                } else if (servletVersionStr.equals("3.0")) {
                    eeVersion = 6;
                } else if (servletVersionStr.equals("2.5")) {
                    eeVersion = 5;
                } else if (servletVersionStr.equals("2.4")) {
                    eeVersion = 4;
                } else if (servletVersionStr.equals("2.3")) {
                    eeVersion = 3;
                }
            }
        }
        catch (NumberFormatException numberFormatException) {
        }
        catch (CoreException coreException) {}
        String url = "https://jakarta.ee/specifications/servlet/5.0/apidocs/";
        switch (eeVersion) {
            case 3: {
                url = "https://docs.oracle.com/javaee/3/api/";
                break;
            }
            case 4: {
                url = "https://docs.oracle.com/javaee/4/api/";
                break;
            }
            case 5: {
                url = "https://docs.oracle.com/javaee/5/api/";
                break;
            }
            case 6: {
                url = "https://docs.oracle.com/javaee/6/api/";
                break;
            }
            case 7: {
                url = "https://docs.oracle.com/javaee/7/api/";
                break;
            }
            case 8: {
                url = "https://javaee.github.io/javaee-spec/javadocs/";
                break;
            }
            default: {
                url = "https://jakarta.ee/specifications/servlet/5.0/apidocs/";
            }
        }
        return url;
    }

    private String getTomcatJavadocLocation(IRuntime runtime) {
        String tomcatDocURL = "http://tomcat.apache.org/tomcat-10.0-doc/api/";
        String runtimeTypeId = runtime.getRuntimeType().getId();
        if (runtimeTypeId.indexOf("90") > 0) {
            tomcatDocURL = "https://tomcat.apache.org/tomcat-9.0-doc/api/";
        }
        if (runtimeTypeId.indexOf("85") > 0) {
            tomcatDocURL = "https://tomcat.apache.org/tomcat-8.5-doc/api/";
        } else if (runtimeTypeId.indexOf("80") > 0) {
            tomcatDocURL = "https://tomcat.apache.org/tomcat-8.0-doc/api/";
        } else if (runtimeTypeId.indexOf("70") > 0) {
            tomcatDocURL = "https://tomcat.apache.org/tomcat-7.0-doc/api/";
        }
        return tomcatDocURL;
    }

    public IClasspathEntry[] resolveClasspathContainer(IProject project, IRuntime runtime) {
        IPath path;
        IPath installPath = runtime.getLocation();
        if (installPath == null) {
            return new IClasspathEntry[0];
        }
        ArrayList list = new ArrayList();
        String runtimeId = runtime.getRuntimeType().getId();
        if (runtimeId.indexOf("32") > 0) {
            path = installPath.append("lib");
            TomcatRuntimeClasspathProvider.addLibraryEntries(list, (File)path.toFile(), (boolean)true);
        } else if (runtimeId.indexOf("60") > 0 || runtimeId.indexOf("70") > 0 || runtimeId.indexOf("80") > 0 || runtimeId.indexOf("85") > 0 || runtimeId.indexOf("90") > 0 || runtimeId.indexOf("100") > 0) {
            path = installPath.append("lib");
            TomcatRuntimeClasspathProvider.addLibraryEntries(list, (File)path.toFile(), (boolean)true);
        } else {
            path = installPath.append("common");
            TomcatRuntimeClasspathProvider.addLibraryEntries(list, (File)path.append("lib").toFile(), (boolean)true);
            TomcatRuntimeClasspathProvider.addLibraryEntries(list, (File)path.append("endorsed").toFile(), (boolean)true);
        }
        IClasspathEntry[] entries = list.toArray(new IClasspathEntry[list.size()]);
        String apiJavadocLocation = this.getEEJavadocLocation(project);
        String tomcatDocLocation = this.getTomcatJavadocLocation(runtime);
        int i = 0;
        while (i < entries.length) {
            IClasspathEntry tomcatLibraryEntry;
            IClasspathEntry apiLibraryEntry;
            IClasspathEntry entry = entries[i];
            String jarName = entry.getPath().lastSegment();
            entries[i] = jarName.endsWith("-api.jar") && !jarName.startsWith("tomcat") ? (apiLibraryEntry = JavaCore.newLibraryEntry((IPath)entry.getPath(), (IPath)entry.getSourceAttachmentPath(), (IPath)entry.getSourceAttachmentRootPath(), (IAccessRule[])entry.getAccessRules(), (IClasspathAttribute[])new IClasspathAttribute[]{JavaCore.newClasspathAttribute((String)"javadoc_location", (String)apiJavadocLocation)}, (boolean)entry.isExported())) : (tomcatLibraryEntry = JavaCore.newLibraryEntry((IPath)entry.getPath(), (IPath)entry.getSourceAttachmentPath(), (IPath)entry.getSourceAttachmentRootPath(), (IAccessRule[])entry.getAccessRules(), (IClasspathAttribute[])new IClasspathAttribute[]{JavaCore.newClasspathAttribute((String)"javadoc_location", (String)tomcatDocLocation)}, (boolean)entry.isExported()));
            ++i;
        }
        return entries;
    }
}

