/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.profiles.ui.internal.actions;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.m2e.core.MavenPlugin;
import org.eclipse.m2e.core.project.IMavenProjectFacade;
import org.eclipse.m2e.core.ui.internal.actions.SelectionUtil;
import org.eclipse.m2e.profiles.core.internal.IProfileManager;
import org.eclipse.m2e.profiles.core.internal.MavenProfilesCoreActivator;
import org.eclipse.m2e.profiles.core.internal.ProfileData;
import org.eclipse.m2e.profiles.core.internal.ProfileState;
import org.eclipse.m2e.profiles.ui.internal.Messages;
import org.eclipse.m2e.profiles.ui.internal.dialog.ProfileSelection;
import org.eclipse.m2e.profiles.ui.internal.dialog.SelectProfilesDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.handlers.HandlerUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProfileSelectionHandler
extends AbstractHandler {
    private static final Logger log = LoggerFactory.getLogger(ProfileSelectionHandler.class);

    public Object execute(ExecutionEvent event) throws ExecutionException {
        IWorkbenchWindow window = HandlerUtil.getActiveWorkbenchWindowChecked((ExecutionEvent)event);
        IProject[] projects = this.getSelectedProjects(event);
        return this.execute(window.getShell(), projects);
    }

    private IProject[] getSelectedProjects(ExecutionEvent event) {
        IEditorInput input;
        ISelection selection = HandlerUtil.getCurrentSelection((ExecutionEvent)event);
        IProject[] projects = SelectionUtil.getProjects((ISelection)selection, (boolean)false);
        if (projects.length == 0 && (input = HandlerUtil.getActiveEditorInput((ExecutionEvent)event)) instanceof IFileEditorInput) {
            IFileEditorInput fileInput = (IFileEditorInput)input;
            projects = new IProject[]{fileInput.getFile().getProject()};
        }
        return projects;
    }

    public IStatus execute(Shell shell, IProject ... projects) throws ExecutionException {
        Set<IMavenProjectFacade> facades = this.getMavenProjects(projects);
        if (facades.isEmpty()) {
            this.display(shell, Messages.ProfileSelectionHandler_Select_some_maven_projects);
            return null;
        }
        IProfileManager profileManager = MavenProfilesCoreActivator.getDefault().getProfileManager();
        GetProfilesJob getProfilesJob = new GetProfilesJob(facades, profileManager);
        getProfilesJob.addJobChangeListener(this.onProfilesFetched(getProfilesJob, facades, profileManager, shell));
        getProfilesJob.setUser(true);
        getProfilesJob.schedule();
        return Status.OK_STATUS;
    }

    private IJobChangeListener onProfilesFetched(final GetProfilesJob getProfilesJob, final Set<IMavenProjectFacade> facades, final IProfileManager profileManager, final Shell shell) {
        return new JobChangeAdapter(){

            public void done(IJobChangeEvent event) {
                if (getProfilesJob.getResult().isOK()) {
                    shell.getDisplay().syncExec(() -> {
                        List<ProfileSelection> sharedProfiles = getProfilesJob.getSharedProfiles();
                        Map<IMavenProjectFacade, List<ProfileData>> allProfiles = getProfilesJob.getAllProfiles();
                        SelectProfilesDialog dialog = new SelectProfilesDialog(shell, facades, sharedProfiles);
                        if (dialog.open() == 0) {
                            UpdateProfilesJob job = new UpdateProfilesJob(allProfiles, sharedProfiles, profileManager, dialog);
                            job.setRule(MavenPlugin.getProjectConfigurationManager().getRule());
                            job.schedule();
                        }
                    });
                }
            }
        };
    }

    private void display(Shell shell, String message) {
        MessageDialog.openInformation((Shell)shell, (String)Messages.SelectProfilesDialog_Select_Maven_profiles, (String)message);
    }

    private Set<IMavenProjectFacade> getMavenProjects(IProject[] projects) {
        if (projects == null || projects.length == 0) {
            return Collections.emptySet();
        }
        HashSet<IMavenProjectFacade> facades = new HashSet<IMavenProjectFacade>(projects.length);
        try {
            NullProgressMonitor monitor = new NullProgressMonitor();
            IProject[] iProjectArray = projects;
            int n = projects.length;
            int n2 = 0;
            while (n2 < n) {
                IProject p = iProjectArray[n2];
                if (p != null && p.isAccessible() && p.hasNature("org.eclipse.m2e.core.maven2Nature")) {
                    IFile pom = p.getFile("pom.xml");
                    IMavenProjectFacade facade = MavenPlugin.getMavenProjectRegistry().create(pom, true, (IProgressMonitor)monitor);
                    facades.add(facade);
                }
                ++n2;
            }
        }
        catch (CoreException e) {
            log.error("Unable to select Maven projects", (Throwable)e);
        }
        return facades;
    }

    class GetProfilesJob
    extends Job {
        private final IProfileManager profileManager;
        private final Set<IMavenProjectFacade> facades;
        private Map<IMavenProjectFacade, List<ProfileData>> allProfiles;
        private List<ProfileSelection> sharedProfiles;

        private GetProfilesJob(Set<IMavenProjectFacade> facades, IProfileManager profileManager) {
            super(Messages.ProfileSelectionHandler_Loading_maven_profiles);
            this.facades = facades;
            this.profileManager = profileManager;
        }

        protected IStatus run(IProgressMonitor monitor) {
            try {
                this.allProfiles = this.getAllProfiles(this.facades, this.profileManager);
                this.sharedProfiles = this.getSharedProfiles(this.allProfiles);
            }
            catch (CoreException e) {
                return new Status(4, "org.eclipse.m2e.profiles.ui", Messages.ProfileSelectionHandler_Unable_to_open_profile_dialog, (Throwable)e);
            }
            return Status.OK_STATUS;
        }

        private List<ProfileSelection> getSharedProfiles(Map<IMavenProjectFacade, List<ProfileData>> projectProfilesMap) {
            List currentSelection = null;
            ArrayList<List<ProfileData>> projectProfiles = new ArrayList<List<ProfileData>>(projectProfilesMap.values());
            int smallestSize = Integer.MAX_VALUE;
            for (List list : projectProfiles) {
                int size = list.size();
                if (size >= smallestSize) continue;
                smallestSize = size;
                currentSelection = list;
            }
            projectProfiles.remove(currentSelection);
            ArrayList<ProfileSelection> arrayList = new ArrayList<ProfileSelection>();
            if (currentSelection != null) {
                for (ProfileData p : currentSelection) {
                    ProfileSelection profileSelection = new ProfileSelection();
                    profileSelection.setId(p.getId());
                    profileSelection.setActivationState(p.getActivationState());
                    profileSelection.setAutoActive(p.isAutoActive());
                    profileSelection.setSource(p.getSource());
                    profileSelection.setSelected(p.isUserSelected());
                    arrayList.add(profileSelection);
                }
            }
            if (!projectProfiles.isEmpty()) {
                Iterator ite = arrayList.iterator();
                block2: while (ite.hasNext()) {
                    ProfileSelection p = (ProfileSelection)ite.next();
                    for (List list : projectProfiles) {
                        ProfileData s = this.hasProfile(p.getId(), list);
                        if (s == null) {
                            ite.remove();
                            continue block2;
                        }
                        if (p.getAutoActive() != null && !p.getAutoActive().equals(s.isAutoActive())) {
                            p.setAutoActive(null);
                        }
                        if (p.getSource() != null && !p.getSource().equals(s.getSource())) {
                            p.setSource(Messages.ProfileSelectionHandler_multiple_definitions);
                        }
                        if (p.getSelected() != null && !p.getSelected().equals(s.isUserSelected())) {
                            p.setSelected(null);
                        }
                        if (p.getActivationState() == null || p.getActivationState().equals((Object)s.getActivationState())) continue;
                        p.setActivationState(null);
                        p.setAutoActive(null);
                    }
                }
            }
            return arrayList;
        }

        private ProfileData hasProfile(String id, List<ProfileData> statuses) {
            for (ProfileData p : statuses) {
                if (!id.equals(p.getId())) continue;
                return p;
            }
            return null;
        }

        private Map<IMavenProjectFacade, List<ProfileData>> getAllProfiles(Set<IMavenProjectFacade> facades, IProfileManager profileManager) throws CoreException {
            HashMap<IMavenProjectFacade, List<ProfileData>> allProfiles = new HashMap<IMavenProjectFacade, List<ProfileData>>(facades.size());
            NullProgressMonitor monitor = new NullProgressMonitor();
            for (IMavenProjectFacade facade : facades) {
                allProfiles.put(facade, profileManager.getProfileDatas(facade, (IProgressMonitor)monitor));
            }
            return allProfiles;
        }

        public List<ProfileSelection> getSharedProfiles() {
            return this.sharedProfiles;
        }

        public Map<IMavenProjectFacade, List<ProfileData>> getAllProfiles() {
            return this.allProfiles;
        }
    }

    class UpdateProfilesJob
    extends WorkspaceJob {
        private final Map<IMavenProjectFacade, List<ProfileData>> allProfiles;
        private final List<ProfileSelection> sharedProfiles;
        private final IProfileManager profileManager;
        private final SelectProfilesDialog dialog;

        private UpdateProfilesJob(Map<IMavenProjectFacade, List<ProfileData>> allProfiles, List<ProfileSelection> sharedProfiles, IProfileManager profileManager, SelectProfilesDialog dialog) {
            super(Messages.ProfileManager_Updating_maven_profiles);
            this.allProfiles = allProfiles;
            this.sharedProfiles = sharedProfiles;
            this.profileManager = profileManager;
            this.dialog = dialog;
        }

        public IStatus runInWorkspace(IProgressMonitor monitor) {
            try {
                SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (String)Messages.ProfileManager_Updating_maven_profiles, (int)100);
                SubMonitor subProgress = SubMonitor.convert((IProgressMonitor)progress.newChild(5), (int)(this.allProfiles.size() * 100));
                for (Map.Entry<IMavenProjectFacade, List<ProfileData>> entry : this.allProfiles.entrySet()) {
                    if (progress.isCanceled()) {
                        throw new OperationCanceledException();
                    }
                    IMavenProjectFacade facade = entry.getKey();
                    List<String> activeProfiles = this.getActiveProfiles(this.sharedProfiles, entry.getValue());
                    this.profileManager.updateActiveProfiles(facade, activeProfiles, this.dialog.isOffline(), this.dialog.isForceUpdate(), (IProgressMonitor)subProgress.newChild(100));
                }
            }
            catch (CoreException ex) {
                log.error("Unable to update Maven profiles", (Throwable)ex);
                return ex.getStatus();
            }
            return Status.OK_STATUS;
        }

        private List<String> getActiveProfiles(List<ProfileSelection> sharedProfiles, List<ProfileData> availableProfiles) {
            ArrayList<String> ids = new ArrayList<String>();
            for (ProfileData st : availableProfiles) {
                ProfileSelection selection = this.findSelectedProfile(st.getId(), sharedProfiles);
                String id = null;
                boolean isDisabled = false;
                if (selection == null) {
                    if (st.isUserSelected()) {
                        id = st.getId();
                        isDisabled = ProfileState.Disabled.equals((Object)st.getActivationState());
                    }
                } else if (selection.getSelected() == null) {
                    if (st.isUserSelected()) {
                        id = st.getId();
                        isDisabled = ProfileState.Disabled.equals((Object)st.getActivationState());
                    }
                } else if (Boolean.TRUE.equals(selection.getSelected())) {
                    id = selection.getId();
                    isDisabled = ProfileState.Disabled.equals((Object)selection.getActivationState());
                }
                if (id == null) continue;
                if (isDisabled) {
                    id = "!" + id;
                }
                ids.add(id);
            }
            return ids;
        }

        private ProfileSelection findSelectedProfile(String id, List<ProfileSelection> sharedProfiles) {
            for (ProfileSelection sel : sharedProfiles) {
                if (!id.equals(sel.getId())) continue;
                return sel;
            }
            return null;
        }
    }
}

