/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.qvt.oml.debug.core;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.m2m.internal.qvt.oml.ast.binding.ASTBindingHelper;
import org.eclipse.m2m.internal.qvt.oml.ast.env.QvtOperationalModuleEnv;
import org.eclipse.m2m.internal.qvt.oml.ast.parser.QvtOperationalParserUtil;
import org.eclipse.m2m.internal.qvt.oml.compiler.CompiledUnit;
import org.eclipse.m2m.internal.qvt.oml.expressions.Module;
import org.eclipse.m2m.qvt.oml.debug.core.QVTODebugCore;
import org.eclipse.ocl.ecore.EcoreEnvironment;

public class QVTODebugUtil {
    private QVTODebugUtil() {
    }

    public static URI getResourceURI(IResource resource) {
        return URI.createPlatformResourceURI((String)resource.getFullPath().toString(), (boolean)true);
    }

    public static IFile toFile(URI uri) {
        List<IFile> files = QVTODebugUtil.toFiles(uri);
        return files.isEmpty() ? null : files.get(0);
    }

    public static List<IFile> toFiles(URI uri) {
        if (uri.isPlatformResource()) {
            String platformString = uri.toPlatformString(true);
            IFile file = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(platformString));
            return Collections.singletonList(file);
        }
        if (uri.isFile()) {
            java.net.URI javaURI;
            try {
                javaURI = java.net.URI.create(uri.toString());
            }
            catch (IllegalArgumentException e) {
                QVTODebugCore.log(e);
                return Collections.emptyList();
            }
            IFile[] files = ResourcesPlugin.getWorkspace().getRoot().findFilesForLocationURI(javaURI);
            ArrayList<IFile> result = new ArrayList<IFile>(files.length);
            IFile[] iFileArray = files;
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                IFile nextFile = iFileArray[n2];
                result.add(nextFile);
                ++n2;
            }
            return result;
        }
        return Collections.emptyList();
    }

    public static void refreshInWorkspace(List<URI> uris) {
        HashSet<IContainer> containers = new HashSet<IContainer>();
        for (URI nextURI : uris) {
            List<IFile> files = QVTODebugUtil.toFiles(nextURI);
            for (IFile iFile : files) {
                containers.add(iFile.getParent());
            }
        }
        for (IContainer iContainer : containers) {
            try {
                iContainer.refreshLocal(1, null);
            }
            catch (CoreException e) {
                QVTODebugCore.log(e.getStatus());
            }
        }
    }

    public static URI toFileURI(String uriStr) {
        URI uri = URI.createURI((String)uriStr);
        if (uri.isPlatformResource()) {
            URI baseURI = URI.createURI((String)ResourcesPlugin.getWorkspace().getRoot().getLocationURI().toString());
            uri = URI.createURI((String)(String.valueOf(baseURI.toString()) + uri.toPlatformString(true)), (boolean)true);
        }
        return uri;
    }

    public static IStatus createDebugError(String message, Throwable throwable) {
        return QVTODebugCore.createStatus(4, message, throwable);
    }

    public static IStatus createDebugError(String message) {
        return QVTODebugCore.createStatus(4, message, null);
    }

    public static QvtOperationalModuleEnv getEnvironment(Module module) {
        return (QvtOperationalModuleEnv)ASTBindingHelper.getEnvironment((EObject)module, QvtOperationalModuleEnv.class);
    }

    public static void attachEnvironment(CompiledUnit unit) {
        HashSet<CompiledUnit> allUnits = new HashSet<CompiledUnit>();
        QvtOperationalParserUtil.collectAllImports((CompiledUnit)unit, allUnits);
        allUnits.add(unit);
        for (CompiledUnit nextUnit : allUnits) {
            for (QvtOperationalModuleEnv moduleEnv : nextUnit.getModuleEnvironments()) {
                Module module = moduleEnv.getModuleContextType();
                if (module == null) continue;
                ASTBindingHelper.setEnvironment((EObject)module, (EcoreEnvironment)moduleEnv);
            }
        }
    }
}

