/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.debug.ui.console;

import org.eclipse.debug.core.ILaunch;
import org.eclipse.php.internal.debug.core.IPHPConsoleEventListener;
import org.eclipse.php.internal.debug.core.launching.DebugConsoleMonitor;
import org.eclipse.php.internal.debug.core.launching.PHPHyperLink;
import org.eclipse.php.internal.debug.core.zend.debugger.DebugError;
import org.eclipse.php.internal.debug.ui.console.PHPFileLink;
import org.eclipse.ui.console.IHyperlink;

public class PHPConsoleListener
implements IPHPConsoleEventListener {
    protected ILaunch fLaunch;
    protected DebugConsoleMonitor fConsoleMonitor;
    protected PHPHyperLink fPHPHyperLink;

    public void init(ILaunch launch, DebugConsoleMonitor consoleMonitor, PHPHyperLink link) {
        this.fLaunch = launch;
        this.fConsoleMonitor = consoleMonitor;
        this.fPHPHyperLink = link;
    }

    public void handleEvent(DebugError debugError) {
        IHyperlink link = this.createLink(debugError);
        String message = debugError.toString().trim();
        this.fPHPHyperLink.addLink(link, message, message.length() - debugError.getErrorTextLength());
        this.fConsoleMonitor.append(String.valueOf(debugError.toString()) + '\n');
    }

    protected IHyperlink createLink(DebugError debugError) {
        String fileName = debugError.getFullPathName();
        int lineNumber = debugError.getLineNumber();
        String url = this.fLaunch.getAttribute("uriginalURL");
        return new PHPFileLink(fileName, lineNumber, url);
    }
}

