/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.query.tooling.ui.migrator;

import java.util.ArrayList;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.viatra.query.tooling.ui.migrator.JavaProjectMigrator;

public class MigrateProjectHandler
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        IStructuredSelection selection = (IStructuredSelection)HandlerUtil.getCurrentSelectionChecked((ExecutionEvent)event);
        final ArrayList<JavaProjectMigrator> projects = new ArrayList<JavaProjectMigrator>(selection.size());
        Object[] objectArray = selection.toArray();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object o = objectArray[n2];
            if (o instanceof IProject) {
                try {
                    if (((IProject)o).hasNature("org.eclipse.jdt.core.javanature")) {
                        projects.add(new JavaProjectMigrator((IProject)o));
                    }
                }
                catch (CoreException e) {
                    throw new ExecutionException("Unexpected error during migration: " + e.getMessage(), (Throwable)e);
                }
            }
            if (o instanceof IJavaProject) {
                projects.add(new JavaProjectMigrator((IJavaProject)o));
            }
            ++n2;
        }
        Job job = new Job("Migrate projects"){

            protected IStatus run(IProgressMonitor monitor) {
                SubMonitor m = SubMonitor.convert((IProgressMonitor)monitor);
                m.beginTask(this.getName(), projects.size());
                for (JavaProjectMigrator migrator : projects) {
                    migrator.migrate((IProgressMonitor)m.newChild(1));
                }
                return Status.OK_STATUS;
            }
        };
        job.setUser(true);
        job.schedule();
        return null;
    }
}

