/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpel.validator.model;

import java.util.ArrayList;
import java.util.List;
import java.util.Stack;
import org.eclipse.bpel.validator.model.IFilter;
import org.eclipse.bpel.validator.model.Rules;
import org.eclipse.bpel.validator.model.Validator;

public class RuleRunner {
    Rules fRules;
    Stack<Rules.Rule> fRuleStack = new Stack();
    Rules.Rule fCurrentRule = null;
    List<IFilter<Rules.Rule>> fRuleFilter = new ArrayList<IFilter<Rules.Rule>>(4);
    Validator fValidator = null;

    public RuleRunner(Validator validator) {
        this.fValidator = validator;
        this.fRules = Rules.getRules(validator.getClass());
    }

    public void runRules(String tag, Object ... args) {
        for (Rules.Rule rule : this.fRules.mRules) {
            if (!tag.equals(rule.getTag()) || this.isDisabled(rule)) continue;
            try {
                try {
                    this.fCurrentRule = this.fRuleStack.push(rule);
                    rule.invoke(this.fValidator, args);
                }
                catch (Throwable t) {
                    this.log(this.fValidator, rule, t);
                    this.fCurrentRule = this.fRuleStack.empty() ? null : this.fRuleStack.pop();
                    continue;
                }
            }
            catch (Throwable throwable) {
                this.fCurrentRule = this.fRuleStack.empty() ? null : this.fRuleStack.pop();
                throw throwable;
            }
            Rules.Rule rule2 = this.fCurrentRule = this.fRuleStack.empty() ? null : this.fRuleStack.pop();
        }
    }

    void log(Validator context, Rules.Rule rule, Throwable t) {
        context.internalProblem(rule, t);
        Rules.p("Problem executing rule {0}, stack trace shown below", rule.getFullName());
        t.printStackTrace(System.out);
    }

    public void addFilter(Rules.IndexFilter indexFilter) {
        this.fRuleFilter.add(indexFilter);
    }

    public void start() {
        this.fRuleFilter.clear();
    }

    boolean isDisabled(Rules.Rule nextRule) {
        if (this.fRuleFilter.size() > 0) {
            for (IFilter<Rules.Rule> f : this.fRuleFilter) {
                if (!f.select(nextRule)) continue;
                return true;
            }
        }
        return false;
    }

    public Rules.Rule getExecutingRule() {
        return this.fCurrentRule;
    }
}

