/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.core.model.description.rules;

import org.apache.commons.digester.Rule;
import org.eclipse.wb.internal.core.model.description.ComponentDescription;
import org.eclipse.wb.internal.core.model.description.MorphingTargetDescription;
import org.eclipse.wb.internal.core.utils.check.Assert;
import org.eclipse.wb.internal.core.utils.state.EditorState;
import org.xml.sax.Attributes;

public final class MorphingTargetRule
extends Rule {
    private final EditorState m_state;
    private final ClassLoader m_classLoader;

    public MorphingTargetRule(EditorState state) {
        this.m_state = state;
        this.m_classLoader = this.m_state.getEditorLoader();
    }

    public void begin(String namespace, String name, Attributes attributes) throws Exception {
        try {
            this.addTarget(attributes);
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
    }

    private void addTarget(Attributes attributes) throws ClassNotFoundException {
        String creationId = attributes.getValue("creationId");
        String className = attributes.getValue("class");
        Assert.isNotNull((Object)className);
        Class<?> clazz = this.m_classLoader.loadClass(className);
        ComponentDescription componentDescription = (ComponentDescription)this.digester.peek();
        componentDescription.addMorphingTarget(new MorphingTargetDescription(clazz, creationId));
    }
}

