/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.preferences;

import java.util.ArrayList;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.internal.ui.dialogs.OptionalMessageDialog;
import org.eclipse.cdt.internal.ui.preferences.PreferencesMessages;
import org.eclipse.cdt.internal.ui.util.SWTUtil;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.layout.PixelConverter;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.PlatformUI;

public class CPluginPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    public static final String C_BASE_PREF_PAGE_ID = "org.eclipse.cdt.ui.preferences.CPluginPreferencePage";
    private static final int GROUP_VINDENT = 5;
    private ArrayList<Button> fCheckBoxes;

    public CPluginPreferencePage() {
        this.setPreferenceStore(CUIPlugin.getDefault().getPreferenceStore());
        this.setDescription(PreferencesMessages.CPluginPreferencePage_description);
        this.fCheckBoxes = new ArrayList();
    }

    public void createControl(Composite parent) {
        super.createControl(parent);
        PlatformUI.getWorkbench().getHelpSystem().setHelp(this.getControl(), "org.eclipse.cdt.ui.c_pref");
    }

    protected Control createContents(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        Composite container = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = this.convertVerticalDLUsToPixels(7);
        layout.marginWidth = 0;
        layout.verticalSpacing = this.convertVerticalDLUsToPixels(10);
        layout.horizontalSpacing = this.convertHorizontalDLUsToPixels(4);
        container.setLayout((Layout)layout);
        Group outlineViewGroup = this.addGroup(container, PreferencesMessages.CPluginPreferencePage_outline_view);
        this.addCheckBox((Composite)outlineViewGroup, PreferencesMessages.CPluginPreferencePage_structuralParseMode_label, "org.eclipse.cdt.ui.editor.UseStructuralMode");
        this.addNote(outlineViewGroup, PreferencesMessages.CPluginPreferencePage_performanceHint);
        Group refactoringGroup = this.addGroup(container, PreferencesMessages.CPluginPreferencePage_refactoring_title);
        this.addCheckBox((Composite)refactoringGroup, PreferencesMessages.CPluginPreferencePage_refactoring_auto_save, "Refactoring.savealleditors");
        this.addCheckBox((Composite)refactoringGroup, PreferencesMessages.CPluginPreferencePage_refactoring_lightweight, "Refactor.lightweight");
        Group dontAskGroup = this.addGroup(container, PreferencesMessages.CPluginPreferencePage_cdtDialogs_group, 2);
        Label label = new Label((Composite)dontAskGroup, 64);
        label.setText(PreferencesMessages.CPluginPreferencePage_clearDoNotShowAgainSettings_label);
        GridData data = new GridData(4, 2, true, false);
        data.widthHint = this.convertVerticalDLUsToPixels(50);
        label.setLayoutData((Object)data);
        Button clearButton = new Button((Composite)dontAskGroup, 8);
        clearButton.setText(PreferencesMessages.CPluginPreferencePage_clear_button);
        clearButton.setLayoutData((Object)new GridData(4, 1, false, false));
        clearButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                OptionalMessageDialog.clearAllRememberedStates();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                OptionalMessageDialog.clearAllRememberedStates();
            }
        });
        SWTUtil.setButtonDimensionHint(clearButton);
        Dialog.applyDialogFont((Control)container);
        return container;
    }

    private void addNote(Group parent, String noteMessage) {
        Composite noteControl = this.createNoteComposite(JFaceResources.getDialogFont(), (Composite)parent, PreferencesMessages.CPluginPreferencePage_note, noteMessage);
        GridData gd = new GridData(256);
        gd.verticalIndent = 5;
        noteControl.setLayoutData((Object)gd);
    }

    protected Composite createNoteComposite(Font font, Composite composite, String title, String message) {
        Composite messageComposite = super.createNoteComposite(font, composite, title, message);
        Control[] children = messageComposite.getChildren();
        if (children.length == 2 && children[1] instanceof Label) {
            Label messageLabel = (Label)children[1];
            GridData gd = new GridData(768);
            gd.widthHint = 500;
            messageLabel.setLayoutData((Object)gd);
        }
        return messageComposite;
    }

    private Group addGroup(Composite parent, String label) {
        return this.addGroup(parent, label, 1);
    }

    private Group addGroup(Composite parent, String label, int numColumns) {
        Group group = new Group(parent, 0);
        group.setText(label);
        group.setLayoutData((Object)new GridData(768));
        group.setLayout((Layout)new GridLayout(numColumns, false));
        return group;
    }

    private Button addCheckBox(Composite parent, String label, String key) {
        Button button = new Button(parent, 32);
        button.setText(label);
        button.setData((Object)key);
        button.setLayoutData((Object)new GridData(256));
        button.setSelection(this.getPreferenceStore().getBoolean(key));
        this.fCheckBoxes.add(button);
        return button;
    }

    protected void addFiller(Composite composite) {
        PixelConverter pixelConverter = new PixelConverter((Control)composite);
        Label filler = new Label(composite, 16384);
        GridData gd = new GridData(256);
        gd.horizontalSpan = 1;
        gd.heightHint = pixelConverter.convertHeightInCharsToPixels(1) / 2;
        filler.setLayoutData((Object)gd);
    }

    public static boolean isLinkToEditor() {
        return CUIPlugin.getDefault().getPreferenceStore().getBoolean("org.eclipse.cdt.ui.editor.linkToEditor");
    }

    public static void setLinkingEnabled(boolean enable) {
        CUIPlugin.getDefault().getPreferenceStore().setValue("org.eclipse.cdt.ui.editor.linkToEditor", enable);
    }

    public static boolean useStructuralParseMode() {
        return CUIPlugin.getDefault().getPreferenceStore().getBoolean("org.eclipse.cdt.ui.editor.UseStructuralMode");
    }

    public void init(IWorkbench workbench) {
    }

    public static void initDefaults(IPreferenceStore prefs) {
        prefs.setDefault("org.eclipse.cdt.ui.editor.linkToEditor", false);
        prefs.setDefault("org.eclipse.cdt.ui.editor.UseStructuralMode", false);
    }

    public boolean performOk() {
        if (!super.performOk()) {
            return false;
        }
        IPreferenceStore store = this.getPreferenceStore();
        int i = 0;
        while (i < this.fCheckBoxes.size()) {
            Button button = this.fCheckBoxes.get(i);
            String key = (String)button.getData();
            store.setValue(key, button.getSelection());
            ++i;
        }
        CCorePlugin.getDefault().setStructuralParseMode(CPluginPreferencePage.useStructuralParseMode());
        return true;
    }

    protected void performDefaults() {
        super.performDefaults();
        IPreferenceStore store = this.getPreferenceStore();
        int i = 0;
        while (i < this.fCheckBoxes.size()) {
            Button button = this.fCheckBoxes.get(i);
            String key = (String)button.getData();
            button.setSelection(store.getDefaultBoolean(key));
            ++i;
        }
    }
}

