/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.server.ui;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.php.internal.debug.core.pathmapper.PathMapper;
import org.eclipse.php.internal.debug.core.pathmapper.PathMapperRegistry;
import org.eclipse.php.internal.debug.ui.PHPDebugUIImages;
import org.eclipse.php.internal.debug.ui.pathmapper.PathMappingComposite;
import org.eclipse.php.internal.server.core.Server;
import org.eclipse.php.internal.server.ui.Messages;
import org.eclipse.php.internal.server.ui.ServerEditPage;
import org.eclipse.php.internal.ui.wizards.CompositeFragment;
import org.eclipse.php.internal.ui.wizards.IControlHandler;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class PathMapperCompositeFragment
extends CompositeFragment {
    private PathMappingComposite pathMapperComposite;

    public PathMapperCompositeFragment(Composite parent, IControlHandler handler, boolean isForEditing) {
        super(parent, handler, isForEditing);
        this.createDescription();
        if (isForEditing) {
            this.setData(((ServerEditPage)this.controlHandler).getServer());
        }
    }

    protected void createDescription() {
        this.setTitle(Messages.PathMapperCompositeFragment_0);
        this.controlHandler.setTitle(this.getTitle());
        this.setDescription(Messages.PathMapperCompositeFragment_1);
        this.controlHandler.setDescription(this.getDescription());
        this.setImageDescriptor(PHPDebugUIImages.getImageDescriptor((String)"IMG_WIZBAN_MAPPING_SERVER"));
        this.controlHandler.setImageDescriptor(this.getImageDescriptor());
        this.setDisplayName(Messages.PathMapperCompositeFragment_2);
    }

    protected void createContents(Composite parent) {
        this.pathMapperComposite = new PathMappingComposite(parent, 0);
        GridData data = new GridData(1808);
        this.pathMapperComposite.setLayoutData((Object)data);
        Dialog.applyDialogFont((Control)this);
        this.init();
        this.validate();
    }

    protected void init() {
        PathMapper pathMapper;
        if (this.pathMapperComposite == null || this.pathMapperComposite.isDisposed()) {
            return;
        }
        Server server = this.getServer();
        if (server != null && (pathMapper = PathMapperRegistry.getByServer((Server)server)) != null) {
            this.pathMapperComposite.setData((Object)pathMapper.getMapping());
        }
    }

    public void validate() {
        this.setMessage(this.getDescription(), 0);
        this.setComplete(true);
        this.controlHandler.update();
    }

    public boolean performOk() {
        Server server = this.getServer();
        if (server != null) {
            PathMapper pathMapper = PathMapperRegistry.getByServer((Server)server);
            pathMapper.setMapping(this.pathMapperComposite.getMappings());
            PathMapperRegistry.storeToPreferences();
        }
        return true;
    }

    public void setData(Object server) {
        if (!(server instanceof Server)) {
            throw new IllegalArgumentException("The given object is not a Server");
        }
        super.setData(server);
        this.init();
        this.validate();
    }

    public PathMapper.Mapping[] getMappings() {
        return this.pathMapperComposite.getMappings();
    }

    public Server getServer() {
        return (Server)this.getData();
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.pathMapperComposite.setEnabled(enabled);
    }
}

