/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.pldt.mpi.analysis.cdt.graphs.impl;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Stack;
import org.eclipse.cdt.core.dom.ast.ASTVisitor;
import org.eclipse.cdt.core.dom.ast.IASTBreakStatement;
import org.eclipse.cdt.core.dom.ast.IASTCaseStatement;
import org.eclipse.cdt.core.dom.ast.IASTCompoundStatement;
import org.eclipse.cdt.core.dom.ast.IASTContinueStatement;
import org.eclipse.cdt.core.dom.ast.IASTDeclarationStatement;
import org.eclipse.cdt.core.dom.ast.IASTDefaultStatement;
import org.eclipse.cdt.core.dom.ast.IASTDoStatement;
import org.eclipse.cdt.core.dom.ast.IASTExpression;
import org.eclipse.cdt.core.dom.ast.IASTExpressionStatement;
import org.eclipse.cdt.core.dom.ast.IASTForStatement;
import org.eclipse.cdt.core.dom.ast.IASTFunctionCallExpression;
import org.eclipse.cdt.core.dom.ast.IASTGotoStatement;
import org.eclipse.cdt.core.dom.ast.IASTIfStatement;
import org.eclipse.cdt.core.dom.ast.IASTLabelStatement;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IASTNullStatement;
import org.eclipse.cdt.core.dom.ast.IASTProblemStatement;
import org.eclipse.cdt.core.dom.ast.IASTReturnStatement;
import org.eclipse.cdt.core.dom.ast.IASTStatement;
import org.eclipse.cdt.core.dom.ast.IASTSwitchStatement;
import org.eclipse.cdt.core.dom.ast.IASTWhileStatement;
import org.eclipse.ptp.pldt.mpi.analysis.cdt.graphs.IBlock;
import org.eclipse.ptp.pldt.mpi.analysis.cdt.graphs.IControlFlowGraph;
import org.eclipse.ptp.pldt.mpi.analysis.cdt.graphs.impl.Block;

public class ControlFlowGraph
implements IControlFlowGraph {
    protected IASTStatement prog_;
    protected List<IBlock> BBs_;
    protected IBlock entry_;
    protected IBlock exit_;
    private static final boolean traceOn = false;
    private Stack<IBlock> order;

    public ControlFlowGraph(IASTStatement prog) {
        this.prog_ = prog;
        this.BBs_ = new ArrayList<IBlock>();
    }

    public void buildCFG() {
        this.collectBlocks();
        this.setBlockFlow();
        this.buildDOM();
        this.buildPDOM();
        this.sort();
        this.otherOPs();
    }

    protected void collectBlocks() {
        this.entry_ = new Block();
        this.exit_ = new Block();
        BasicBlockCollector bc = new BasicBlockCollector();
        bc.run();
    }

    protected void setBlockFlow() {
        FlowBuilder flowBuilder = new FlowBuilder();
        flowBuilder.run();
    }

    protected void addBasicBlock(IBlock block) {
        if (!this.BBs_.contains(block)) {
            this.BBs_.add(block);
        }
    }

    public IBlock getBlock(IASTExpression expr, IASTStatement parent) {
        for (IBlock bb : this.BBs_) {
            if (!bb.search(expr, parent)) continue;
            return bb;
        }
        return null;
    }

    public IBlock getBlock(IASTStatement stmt) {
        for (IBlock bb : this.BBs_) {
            if (!bb.search(stmt)) continue;
            return bb;
        }
        return null;
    }

    public IBlock getBlock(IASTName label) {
        for (IBlock bb : this.BBs_) {
            if (!bb.search(label)) continue;
            return bb;
        }
        return null;
    }

    public IBlock getBlock(IASTNode content, IASTStatement parent, int type) {
        for (Block block : this.BBs_) {
            if (!block.search(content, parent, type)) continue;
            return block;
        }
        return null;
    }

    public IBlock getEntry() {
        return this.entry_;
    }

    public IBlock getExit() {
        return this.exit_;
    }

    public void addBlock(IBlock bb) {
        if (!this.BBs_.contains(bb)) {
            this.BBs_.add(bb);
        }
    }

    public void buildDOM() {
        ArrayList<IBlock> all = new ArrayList<IBlock>();
        all.add(this.entry_);
        all.addAll(this.BBs_);
        all.add(this.exit_);
        this.entry_.getDOM().add(this.entry_);
        Iterator<IBlock> i = this.BBs_.iterator();
        while (i.hasNext()) {
            i.next().setDOM(all);
        }
        this.exit_.setDOM(all);
        boolean change = true;
        while (change) {
            change = false;
            for (IBlock block : all) {
                if (block == this.entry_) continue;
                List<IBlock> temp = new ArrayList<IBlock>(all);
                for (IBlock pred : block.getPreds()) {
                    temp = this.intersect(temp, pred.getDOM());
                }
                ArrayList<IBlock> D = new ArrayList<IBlock>(temp);
                if (!D.contains(block)) {
                    D.add(block);
                }
                if (this.equals(D, block.getDOM())) continue;
                change = true;
                block.setDOM(D);
            }
        }
    }

    public void buildPDOM() {
    }

    public List intersect(List A, List B) {
        if (A == null || B == null) {
            return null;
        }
        ArrayList list = new ArrayList();
        for (Object o : A) {
            if (!B.contains(o)) continue;
            list.add(o);
        }
        return list;
    }

    public boolean equals(List A, List B) {
        if (A == null && B == null) {
            return true;
        }
        if (A == null && B != null) {
            return false;
        }
        if (A != null && B == null) {
            return false;
        }
        if (A.size() != B.size()) {
            return false;
        }
        Iterator i = A.iterator();
        while (i.hasNext()) {
            if (B.contains(i.next())) continue;
            return false;
        }
        return true;
    }

    protected void sort() {
        ArrayList<IBlock> all = new ArrayList<IBlock>();
        all.add(this.entry_);
        all.addAll(this.BBs_);
        all.add(this.exit_);
        for (IBlock block : all) {
            block.setAttr("color", new Integer(0));
        }
        this.order = new Stack();
        for (IBlock block : all) {
            int color = (Integer)block.getAttr("color");
            if (color != 0) continue;
            this.DFSVisit(block);
        }
        IBlock b1 = this.order.pop();
        IBlock b2 = null;
        while (!this.order.empty()) {
            b2 = this.order.pop();
            b1.setTopNext(b2);
            b1 = b2;
        }
    }

    protected void DFSVisit(IBlock block) {
        block.setAttr("color", new Integer(1));
        for (IBlock succ : block.getSuccs()) {
            int color;
            if (this.isBackEdgeSucc(block, succ) || (color = ((Integer)succ.getAttr("color")).intValue()) != 0) continue;
            this.DFSVisit(succ);
        }
        this.order.push(block);
    }

    protected boolean isBackEdgeSucc(IBlock from, IBlock to) {
        return from.getSuccs().contains(to) && from.getDOM().contains(to);
    }

    protected void otherOPs() {
    }

    public void print() {
        IBlock b = this.entry_;
        while (b != null) {
            b.print();
            b = b.topNext();
        }
    }

    class BasicBlockCollector
    extends ASTVisitor {
        BasicBlockCollector() {
        }

        public void run() {
            this.shouldVisitStatements = true;
            this.shouldVisitDeclarations = true;
            ControlFlowGraph.this.prog_.accept((ASTVisitor)this);
        }

        public int visit(IASTStatement stmt) {
            if (stmt instanceof IASTBreakStatement) {
                Block block = new Block(stmt);
                ControlFlowGraph.this.addBlock(block);
            } else if (stmt instanceof IASTCaseStatement) {
                Block block = new Block(stmt);
                ControlFlowGraph.this.addBlock(block);
            } else if (!(stmt instanceof IASTCompoundStatement)) {
                if (stmt instanceof IASTContinueStatement) {
                    Block block = new Block(stmt);
                    ControlFlowGraph.this.addBlock(block);
                } else if (stmt instanceof IASTDeclarationStatement) {
                    Block block = new Block(stmt);
                    ControlFlowGraph.this.addBlock(block);
                } else if (stmt instanceof IASTDefaultStatement) {
                    Block block = new Block(stmt);
                    ControlFlowGraph.this.addBlock(block);
                } else if (stmt instanceof IASTDoStatement) {
                    IASTDoStatement doStmt = (IASTDoStatement)stmt;
                    Block block = new Block(doStmt.getCondition(), stmt);
                    ControlFlowGraph.this.addBlock(block);
                    Block exitjoin = new Block(null, stmt, 5);
                    ControlFlowGraph.this.addBlock(exitjoin);
                    Block continuejoin = new Block(null, stmt, 4);
                    ControlFlowGraph.this.addBlock(continuejoin);
                } else if (stmt instanceof IASTExpressionStatement) {
                    Block block = new Block(stmt);
                    ControlFlowGraph.this.addBlock(block);
                } else if (stmt instanceof IASTForStatement) {
                    IASTForStatement forStmt = (IASTForStatement)stmt;
                    Block block = new Block(forStmt.getConditionExpression(), stmt);
                    ControlFlowGraph.this.addBlock(block);
                    if (forStmt.getIterationExpression() != null) {
                        block = new Block(forStmt.getIterationExpression(), stmt);
                        ControlFlowGraph.this.addBlock(block);
                    }
                    Block continuejoin = new Block(null, stmt, 4);
                    ControlFlowGraph.this.addBlock(continuejoin);
                    Block exitjoin = new Block(null, stmt, 5);
                    ControlFlowGraph.this.addBlock(exitjoin);
                } else if (stmt instanceof IASTGotoStatement) {
                    Block block = new Block(stmt);
                    ControlFlowGraph.this.addBlock(block);
                } else if (stmt instanceof IASTIfStatement) {
                    IASTIfStatement ifStmt = (IASTIfStatement)stmt;
                    Block block = new Block(ifStmt.getConditionExpression(), stmt);
                    ControlFlowGraph.this.addBlock(block);
                    Block join = new Block(null, stmt, 5);
                    ControlFlowGraph.this.addBlock(join);
                } else if (stmt instanceof IASTLabelStatement) {
                    IASTLabelStatement labelS = (IASTLabelStatement)stmt;
                    Block block = new Block((IASTNode)labelS.getName(), stmt, 3);
                    ControlFlowGraph.this.addBlock(block);
                } else if (stmt instanceof IASTNullStatement) {
                    Block block = new Block(stmt);
                    ControlFlowGraph.this.addBlock(block);
                } else if (stmt instanceof IASTProblemStatement) {
                    Block block = new Block(stmt);
                    ControlFlowGraph.this.addBlock(block);
                } else if (stmt instanceof IASTReturnStatement) {
                    IASTReturnStatement rtStmt = (IASTReturnStatement)stmt;
                    Block block = new Block(rtStmt.getReturnValue(), stmt);
                    ControlFlowGraph.this.addBlock(block);
                } else if (stmt instanceof IASTSwitchStatement) {
                    IASTSwitchStatement swStmt = (IASTSwitchStatement)stmt;
                    Block block = new Block(swStmt.getControllerExpression(), stmt);
                    ControlFlowGraph.this.addBlock(block);
                    Block join = new Block(null, stmt, 5);
                    ControlFlowGraph.this.addBlock(join);
                } else if (stmt instanceof IASTWhileStatement) {
                    IASTWhileStatement whStmt = (IASTWhileStatement)stmt;
                    Block block = new Block(whStmt.getCondition(), stmt);
                    ControlFlowGraph.this.addBlock(block);
                    Block join = new Block(null, stmt, 4);
                    ControlFlowGraph.this.addBlock(join);
                    Block exitjoin = new Block(null, stmt, 5);
                    ControlFlowGraph.this.addBlock(exitjoin);
                }
            }
            return 3;
        }
    }

    public class FlowBuilder
    extends ASTVisitor {
        private boolean exitBlock = false;

        public void run() {
            this.shouldVisitStatements = true;
            this.shouldVisitDeclarations = true;
            this.shouldVisitTranslationUnit = true;
            this.shouldVisitExpressions = true;
            IBlock first = this.firstBlock(ControlFlowGraph.this.prog_);
            this.ControlFlowEdge(ControlFlowGraph.this.entry_, first);
            ControlFlowGraph.this.prog_.accept((ASTVisitor)this);
        }

        public int visit(IASTStatement stmt) {
            block56: {
                if (stmt instanceof IASTBreakStatement) {
                    IBlock block = ControlFlowGraph.this.getBlock(stmt);
                    IASTNode parent = stmt.getParent();
                    while (true) {
                        if (parent instanceof IASTDoStatement || parent instanceof IASTForStatement || parent instanceof IASTWhileStatement || parent instanceof IASTSwitchStatement) {
                            IBlock exitjoin = ControlFlowGraph.this.getBlock(null, (IASTStatement)parent, 5);
                            this.ControlFlowEdge(block, exitjoin);
                            break block56;
                        }
                        parent = parent.getParent();
                    }
                }
                if (stmt instanceof IASTCaseStatement || stmt instanceof IASTDefaultStatement) {
                    IASTNode parent = stmt.getParent();
                    while (!(parent instanceof IASTSwitchStatement)) {
                        parent = parent.getParent();
                    }
                    IASTSwitchStatement swStmt = (IASTSwitchStatement)parent;
                    IBlock swblock = ControlFlowGraph.this.getBlock(swStmt.getControllerExpression(), (IASTStatement)parent);
                    IBlock caseblock = ControlFlowGraph.this.getBlock(stmt);
                    this.ControlFlowEdge(swblock, caseblock);
                    IBlock next = this.nextBlock(stmt);
                    this.ControlFlowEdge(caseblock, next);
                } else if (!(stmt instanceof IASTCompoundStatement)) {
                    if (stmt instanceof IASTContinueStatement) {
                        IBlock block = ControlFlowGraph.this.getBlock(stmt);
                        IASTNode parent = stmt.getParent();
                        while (true) {
                            if (parent instanceof IASTDoStatement || parent instanceof IASTForStatement || parent instanceof IASTWhileStatement) {
                                IBlock continuejoin = ControlFlowGraph.this.getBlock(null, (IASTStatement)parent, 4);
                                this.ControlFlowEdge(block, continuejoin);
                                break block56;
                            }
                            parent = parent.getParent();
                        }
                    }
                    if (stmt instanceof IASTDeclarationStatement) {
                        IASTForStatement forStmt;
                        IASTNode parent = stmt.getParent();
                        if (parent instanceof IASTForStatement && (forStmt = (IASTForStatement)parent).getInitializerStatement() == stmt) {
                            return 3;
                        }
                        IBlock block = ControlFlowGraph.this.getBlock(stmt);
                        IBlock next = this.nextBlock(stmt);
                        this.ControlFlowEdge(block, next);
                    } else if (stmt instanceof IASTDoStatement) {
                        IASTDoStatement doStmt = (IASTDoStatement)stmt;
                        IBlock cond = ControlFlowGraph.this.getBlock(doStmt.getCondition(), stmt);
                        if (doStmt.getBody() == null) {
                            this.ControlFlowEdge(cond, cond);
                        } else {
                            IBlock first = this.firstBlock(doStmt.getBody());
                            this.ControlFlowEdge(cond, first);
                            IBlock continuejoin = ControlFlowGraph.this.getBlock(null, stmt, 4);
                            this.ControlFlowEdge(continuejoin, cond);
                        }
                        IBlock exitjoin = ControlFlowGraph.this.getBlock(null, stmt, 5);
                        this.ControlFlowEdge(cond, exitjoin);
                        IBlock next = this.nextBlock(stmt);
                        this.ControlFlowEdge(exitjoin, next);
                    } else if (stmt instanceof IASTExpressionStatement) {
                        IASTForStatement forStmt;
                        IASTNode parent = stmt.getParent();
                        if (parent instanceof IASTForStatement && (forStmt = (IASTForStatement)parent).getInitializerStatement() == stmt) {
                            return 3;
                        }
                        IBlock block = ControlFlowGraph.this.getBlock(stmt);
                        IASTExpressionStatement exprStmt = (IASTExpressionStatement)stmt;
                        this.exitBlock = false;
                        exprStmt.getExpression().accept((ASTVisitor)this);
                        if (this.exitBlock) {
                            this.ControlFlowEdge(block, ControlFlowGraph.this.exit_);
                        } else {
                            IBlock next = this.nextBlock(stmt);
                            this.ControlFlowEdge(block, next);
                        }
                    } else if (stmt instanceof IASTForStatement) {
                        IASTForStatement forStmt = (IASTForStatement)stmt;
                        IASTStatement initStmt = forStmt.getInitializerStatement();
                        IBlock init = ControlFlowGraph.this.getBlock(initStmt);
                        IBlock cond = ControlFlowGraph.this.getBlock(forStmt.getConditionExpression(), stmt);
                        IBlock iter = null;
                        IBlock continuejoin = ControlFlowGraph.this.getBlock(null, stmt, 4);
                        IBlock exitjoin = ControlFlowGraph.this.getBlock(null, stmt, 5);
                        if (forStmt.getIterationExpression() != null) {
                            iter = ControlFlowGraph.this.getBlock(forStmt.getIterationExpression(), stmt);
                        }
                        this.ControlFlowEdge(init, cond);
                        if (forStmt.getBody() != null) {
                            IBlock first = this.firstBlock(forStmt.getBody());
                            this.ControlFlowEdge(cond, first);
                            if (iter != null) {
                                this.ControlFlowEdge(continuejoin, iter);
                                this.ControlFlowEdge(iter, cond);
                            } else {
                                this.ControlFlowEdge(continuejoin, cond);
                            }
                        } else if (iter != null) {
                            this.ControlFlowEdge(cond, iter);
                            this.ControlFlowEdge(iter, cond);
                        } else {
                            this.ControlFlowEdge(cond, cond);
                        }
                        this.ControlFlowEdge(cond, exitjoin);
                        IBlock next = this.nextBlock(stmt);
                        this.ControlFlowEdge(exitjoin, next);
                    } else if (stmt instanceof IASTGotoStatement) {
                        IASTGotoStatement gotoStmt = (IASTGotoStatement)stmt;
                        IBlock label = ControlFlowGraph.this.getBlock((IASTNode)gotoStmt.getName(), (IASTStatement)gotoStmt, 3);
                        if (label == null) {
                            System.out.println("Null Label Error");
                        }
                        IBlock block = ControlFlowGraph.this.getBlock((IASTStatement)gotoStmt);
                        this.ControlFlowEdge(block, label);
                    } else if (stmt instanceof IASTIfStatement) {
                        IASTIfStatement ifStmt = (IASTIfStatement)stmt;
                        IBlock condb = ControlFlowGraph.this.getBlock(ifStmt.getConditionExpression(), stmt);
                        IBlock join = ControlFlowGraph.this.getBlock(null, stmt, 5);
                        if (ifStmt.getThenClause() != null) {
                            IBlock thenb = this.firstBlock(ifStmt.getThenClause());
                            this.ControlFlowEdge(condb, thenb);
                        } else {
                            this.ControlFlowEdge(condb, join);
                        }
                        if (ifStmt.getElseClause() != null) {
                            IBlock elseb = this.firstBlock(ifStmt.getElseClause());
                            this.ControlFlowEdge(condb, elseb);
                        } else {
                            this.ControlFlowEdge(condb, join);
                        }
                        IBlock next = this.nextBlock(stmt);
                        this.ControlFlowEdge(join, next);
                    } else if (stmt instanceof IASTLabelStatement) {
                        IASTLabelStatement label = (IASTLabelStatement)stmt;
                        IBlock block = ControlFlowGraph.this.getBlock((IASTNode)label.getName(), stmt, 3);
                        if (label.getNestedStatement() == null) {
                            IBlock next = this.nextBlock(stmt);
                            this.ControlFlowEdge(block, next);
                        } else {
                            IBlock next = this.firstBlock(label.getNestedStatement());
                            this.ControlFlowEdge(block, next);
                        }
                    } else if (stmt instanceof IASTNullStatement) {
                        IASTForStatement forStmt;
                        IASTNode parent = stmt.getParent();
                        if (parent instanceof IASTForStatement && (forStmt = (IASTForStatement)parent).getInitializerStatement() == stmt) {
                            return 3;
                        }
                        IBlock block = ControlFlowGraph.this.getBlock(stmt);
                        IBlock next = this.nextBlock(stmt);
                        this.ControlFlowEdge(block, next);
                    } else if (stmt instanceof IASTProblemStatement) {
                        IBlock block = ControlFlowGraph.this.getBlock(stmt);
                        IBlock next = this.nextBlock(stmt);
                        this.ControlFlowEdge(block, next);
                    } else if (stmt instanceof IASTReturnStatement) {
                        IASTReturnStatement rtStmt = (IASTReturnStatement)stmt;
                        IBlock rv = ControlFlowGraph.this.getBlock(rtStmt.getReturnValue(), stmt);
                        this.ControlFlowEdge(rv, ControlFlowGraph.this.exit_);
                    } else if (stmt instanceof IASTSwitchStatement) {
                        IBlock join = ControlFlowGraph.this.getBlock(null, stmt, 5);
                        IBlock next = this.nextBlock(stmt);
                        this.ControlFlowEdge(join, next);
                    } else if (stmt instanceof IASTWhileStatement) {
                        IASTWhileStatement whStmt = (IASTWhileStatement)stmt;
                        IBlock cond = ControlFlowGraph.this.getBlock(whStmt.getCondition(), stmt);
                        IBlock continuejoin = ControlFlowGraph.this.getBlock(null, stmt, 4);
                        IBlock exitjoin = ControlFlowGraph.this.getBlock(null, stmt, 5);
                        if (whStmt.getBody() == null) {
                            this.ControlFlowEdge(cond, cond);
                        } else {
                            IBlock first = this.firstBlock(whStmt.getBody());
                            this.ControlFlowEdge(cond, first);
                            this.ControlFlowEdge(continuejoin, cond);
                        }
                        IBlock next = this.nextBlock(stmt);
                        this.ControlFlowEdge(cond, exitjoin);
                        this.ControlFlowEdge(exitjoin, next);
                    }
                }
            }
            return 3;
        }

        public IBlock firstBlock(IASTStatement stmt) {
            if (stmt instanceof IASTBreakStatement) {
                return ControlFlowGraph.this.getBlock(stmt);
            }
            if (stmt instanceof IASTCaseStatement) {
                return ControlFlowGraph.this.getBlock(stmt);
            }
            if (stmt instanceof IASTCompoundStatement) {
                IASTCompoundStatement cmpStmt = (IASTCompoundStatement)stmt;
                IASTStatement[] stmts = cmpStmt.getStatements();
                int i = 0;
                while (i < stmts.length) {
                    if (stmts[i] != null) {
                        return this.firstBlock(stmts[i]);
                    }
                    ++i;
                }
                return this.nextBlock(stmt);
            }
            if (stmt instanceof IASTContinueStatement) {
                return ControlFlowGraph.this.getBlock(stmt);
            }
            if (stmt instanceof IASTDeclarationStatement) {
                return ControlFlowGraph.this.getBlock(stmt);
            }
            if (stmt instanceof IASTDefaultStatement) {
                return ControlFlowGraph.this.getBlock(stmt);
            }
            if (stmt instanceof IASTDoStatement) {
                IASTDoStatement doStmt = (IASTDoStatement)stmt;
                if (doStmt.getBody() != null) {
                    return this.firstBlock(doStmt.getBody());
                }
                return ControlFlowGraph.this.getBlock(doStmt.getCondition(), stmt);
            }
            if (stmt instanceof IASTExpressionStatement) {
                return ControlFlowGraph.this.getBlock(stmt);
            }
            if (stmt instanceof IASTForStatement) {
                IASTForStatement forStmt = (IASTForStatement)stmt;
                IASTStatement initS = forStmt.getInitializerStatement();
                if (initS != null) {
                    return ControlFlowGraph.this.getBlock(initS);
                }
                return ControlFlowGraph.this.getBlock(forStmt.getConditionExpression(), stmt);
            }
            if (stmt instanceof IASTGotoStatement) {
                return ControlFlowGraph.this.getBlock(stmt);
            }
            if (stmt instanceof IASTIfStatement) {
                IASTIfStatement ifStmt = (IASTIfStatement)stmt;
                return ControlFlowGraph.this.getBlock(ifStmt.getConditionExpression(), stmt);
            }
            if (stmt instanceof IASTLabelStatement) {
                IASTLabelStatement label = (IASTLabelStatement)stmt;
                return ControlFlowGraph.this.getBlock((IASTNode)label.getName(), stmt, 3);
            }
            if (stmt instanceof IASTNullStatement) {
                return ControlFlowGraph.this.getBlock(stmt);
            }
            if (stmt instanceof IASTProblemStatement) {
                return ControlFlowGraph.this.getBlock(stmt);
            }
            if (stmt instanceof IASTReturnStatement) {
                IASTReturnStatement rtStmt = (IASTReturnStatement)stmt;
                return ControlFlowGraph.this.getBlock(rtStmt.getReturnValue(), stmt);
            }
            if (stmt instanceof IASTSwitchStatement) {
                IASTSwitchStatement swStmt = (IASTSwitchStatement)stmt;
                return ControlFlowGraph.this.getBlock(swStmt.getControllerExpression(), stmt);
            }
            if (stmt instanceof IASTWhileStatement) {
                IASTWhileStatement whStmt = (IASTWhileStatement)stmt;
                return ControlFlowGraph.this.getBlock(whStmt.getCondition(), stmt);
            }
            return null;
        }

        public IBlock nextBlock(IASTStatement stmt) {
            IASTNode node = stmt.getParent();
            if (!(node instanceof IASTStatement)) {
                return ControlFlowGraph.this.exit_;
            }
            IASTStatement parent = (IASTStatement)node;
            if (parent instanceof IASTCompoundStatement) {
                IASTCompoundStatement cmpStmt = (IASTCompoundStatement)parent;
                IASTStatement[] stmts = cmpStmt.getStatements();
                int i = 0;
                while (i < stmts.length) {
                    if (stmts[i] == stmt) break;
                    ++i;
                }
                ++i;
                while (i < stmts.length) {
                    if (stmts[i] != null) {
                        return this.firstBlock(stmts[i]);
                    }
                    ++i;
                }
                return this.nextBlock(parent);
            }
            if (parent instanceof IASTDeclarationStatement) {
                return this.nextBlock(parent);
            }
            if (parent instanceof IASTDoStatement) {
                return ControlFlowGraph.this.getBlock(null, parent, 4);
            }
            if (parent instanceof IASTForStatement) {
                return ControlFlowGraph.this.getBlock(null, parent, 4);
            }
            if (parent instanceof IASTIfStatement) {
                return ControlFlowGraph.this.getBlock(null, parent, 5);
            }
            if (parent instanceof IASTLabelStatement) {
                return this.nextBlock(parent);
            }
            if (parent instanceof IASTSwitchStatement) {
                return ControlFlowGraph.this.getBlock(null, parent, 5);
            }
            if (parent instanceof IASTWhileStatement) {
                return ControlFlowGraph.this.getBlock(null, parent, 4);
            }
            return this.nextBlock(parent);
        }

        private void ControlFlowEdge(IBlock from, IBlock to) {
            if (!from.getSuccs().contains(to)) {
                from.getSuccs().add(to);
            }
            if (!to.getPreds().contains(from)) {
                to.getPreds().add(from);
            }
        }

        public int visit(IASTExpression expr) {
            if (expr instanceof IASTFunctionCallExpression) {
                IASTFunctionCallExpression funcExpr = (IASTFunctionCallExpression)expr;
                IASTExpression funcname = funcExpr.getFunctionNameExpression();
                String signature = funcname.getRawSignature();
                if (signature.equals("exit")) {
                    this.exitBlock = true;
                }
                return 1;
            }
            return 3;
        }
    }
}

