/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tm4e.core.internal.oniguruma;

import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import org.jcodings.specific.UTF8Encoding;

public class OnigString {
    public final String string;
    public final byte[] utf8_value;
    private int[] charsPosFromBytePos;
    private boolean computedOffsets;

    public OnigString(String str) {
        this.string = str;
        this.utf8_value = str.getBytes(StandardCharsets.UTF_8);
    }

    public int convertUtf16OffsetToUtf8(int posInChars) {
        if (!this.computedOffsets) {
            this.computeOffsets();
        }
        if (this.charsPosFromBytePos == null) {
            if (posInChars < 0 || this.utf8_value.length == 0 || posInChars > this.utf8_value.length) {
                throw new ArrayIndexOutOfBoundsException(posInChars);
            }
            return posInChars;
        }
        int[] charsLenInBytes = this.charsPosFromBytePos;
        if (posInChars < 0 || charsLenInBytes.length == 0) {
            throw new ArrayIndexOutOfBoundsException(posInChars);
        }
        if (posInChars == 0) {
            return 0;
        }
        int last = charsLenInBytes[charsLenInBytes.length - 1];
        if (last < posInChars) {
            if (last == posInChars - 1) {
                return charsLenInBytes.length;
            }
            throw new ArrayIndexOutOfBoundsException(posInChars);
        }
        int index = Arrays.binarySearch(charsLenInBytes, posInChars);
        while (index > 0) {
            if (charsLenInBytes[index - 1] != posInChars) break;
            --index;
        }
        return index;
    }

    public int convertUtf8OffsetToUtf16(int posInBytes) {
        if (!this.computedOffsets) {
            this.computeOffsets();
        }
        if (this.charsPosFromBytePos == null) {
            return posInBytes;
        }
        if (posInBytes < 0) {
            return posInBytes;
        }
        if (posInBytes >= this.charsPosFromBytePos.length) {
            return this.charsPosFromBytePos[posInBytes - 1] + 1;
        }
        return this.charsPosFromBytePos[posInBytes];
    }

    private void computeOffsets() {
        if (this.utf8_value.length != this.string.length()) {
            this.charsPosFromBytePos = new int[this.utf8_value.length];
            int bytesLen = 0;
            int charsLen = 0;
            int length = this.utf8_value.length;
            int i = 0;
            while (i < length) {
                int codeLen = UTF8Encoding.INSTANCE.length(this.utf8_value, i, length);
                int i1 = 0;
                while (i1 < codeLen) {
                    this.charsPosFromBytePos[bytesLen + i1] = charsLen;
                    ++i1;
                }
                bytesLen += codeLen;
                i += codeLen;
                ++charsLen;
            }
            if (bytesLen != this.utf8_value.length) {
                throw new AssertionError((Object)(String.valueOf(bytesLen) + " != " + this.utf8_value.length));
            }
        }
        this.computedOffsets = true;
    }
}

