/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.refactoring;

import org.eclipse.cdt.core.CConventions;
import org.eclipse.cdt.internal.ui.dialogs.TextFieldNavigationHandler;
import org.eclipse.cdt.internal.ui.refactoring.Messages;
import org.eclipse.cdt.internal.ui.refactoring.NameInformation;
import org.eclipse.cdt.internal.ui.viewsupport.BasicElementLabels;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.StatusDialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class ParameterEditDialog
extends StatusDialog {
    private final NameInformation fParameter;
    private final boolean fEditType;
    private final boolean fEditDefault;
    private final boolean fEditReturn;
    private Text fType;
    private Text fName;
    private Text fDefaultValue;
    private Button fReturn;

    public ParameterEditDialog(Shell parentShell, NameInformation parameter, boolean canEditType, boolean canEditDefault, boolean canChangeReturn) {
        super(parentShell);
        this.fParameter = parameter;
        this.fEditType = canEditType;
        this.fEditDefault = canEditDefault;
        this.fEditReturn = canChangeReturn;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(Messages.ParameterEditDialog_title);
    }

    protected Control createDialogArea(Composite parent) {
        Composite result = (Composite)super.createDialogArea(parent);
        GridLayout layout = (GridLayout)result.getLayout();
        layout.numColumns = 2;
        Label label = new Label(result, 0);
        String newName = this.fParameter.getNewName();
        if (newName.isEmpty()) {
            label.setText(Messages.ParameterEditDialog_message_new);
        } else {
            label.setText(NLS.bind((String)Messages.ParameterEditDialog_message, (Object)BasicElementLabels.getCElementName(newName)));
        }
        GridData gd = new GridData(768);
        gd.horizontalSpan = 2;
        label.setLayoutData((Object)gd);
        if (this.fEditType) {
            label = new Label(result, 0);
            label.setText(Messages.ParameterEditDialog_type);
            this.fType = new Text(result, 2048);
            gd = new GridData(768);
            this.fType.setLayoutData((Object)gd);
            this.fType.setText(this.fParameter.getTypeName());
            this.fType.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    ParameterEditDialog.this.validate((Text)e.widget);
                }
            });
            TextFieldNavigationHandler.install(this.fType);
        }
        label = new Label(result, 0);
        this.fName = new Text(result, 2048);
        this.initializeDialogUnits((Control)this.fName);
        label.setText(Messages.ParameterEditDialog_name);
        gd = new GridData(768);
        gd.widthHint = this.convertWidthInCharsToPixels(45);
        this.fName.setLayoutData((Object)gd);
        this.fName.setText(newName);
        this.fName.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ParameterEditDialog.this.validate((Text)e.widget);
            }
        });
        TextFieldNavigationHandler.install(this.fName);
        if (this.fEditDefault && this.fParameter.isAdded()) {
            label = new Label(result, 0);
            label.setText(Messages.ParameterEditDialog_default_value);
            this.fDefaultValue = new Text(result, 2048);
            gd = new GridData(768);
            this.fDefaultValue.setLayoutData((Object)gd);
            this.fDefaultValue.setText(this.fParameter.getDefaultValue());
            this.fDefaultValue.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    ParameterEditDialog.this.validate((Text)e.widget);
                }
            });
            TextFieldNavigationHandler.install(this.fDefaultValue);
        }
        if (this.fEditReturn) {
            this.fReturn = new Button(result, 32);
            this.fReturn.setText(Messages.ParameterEditDialog_use_as_return);
            this.fReturn.setSelection(this.fParameter.isReturnValue());
            this.fReturn.setLayoutData((Object)new GridData(768));
        }
        ParameterEditDialog.applyDialogFont((Control)result);
        return result;
    }

    protected void okPressed() {
        if (this.fType != null) {
            this.fParameter.setTypeName(this.fType.getText());
        }
        this.fParameter.setNewName(this.fName.getText());
        if (this.fDefaultValue != null) {
            this.fParameter.setDefaultValue(this.fDefaultValue.getText());
        }
        if (this.fReturn != null) {
            this.fParameter.setReturnValue(this.fReturn.getSelection());
        }
        super.okPressed();
    }

    private void validate(Text first) {
        IStatus[] result = new IStatus[3];
        if (first == this.fType) {
            result[0] = this.validateType();
            result[1] = this.validateName();
            result[2] = this.validateDefaultValue();
        } else if (first == this.fName) {
            result[0] = this.validateName();
            result[1] = this.validateType();
            result[2] = this.validateDefaultValue();
        } else {
            result[0] = this.validateDefaultValue();
            result[1] = this.validateName();
            result[2] = this.validateType();
        }
        int i = 0;
        while (i < result.length) {
            IStatus status = result[i];
            if (status != null && !status.isOK()) {
                this.updateStatus(status);
                return;
            }
            ++i;
        }
        this.updateStatus(Status.OK_STATUS);
    }

    private IStatus validateType() {
        return Status.OK_STATUS;
    }

    private IStatus validateName() {
        if (this.fName == null) {
            return null;
        }
        String name = this.fName.getText();
        if (name.isEmpty()) {
            return this.createErrorStatus(Messages.ParameterEditDialog_name_error);
        }
        IStatus status = CConventions.validateFieldName((String)name);
        if (status.matches(4)) {
            return status;
        }
        return Status.OK_STATUS;
    }

    private IStatus validateDefaultValue() {
        if (this.fDefaultValue == null) {
            return null;
        }
        String defaultValue = this.fDefaultValue.getText();
        if (defaultValue.isEmpty()) {
            return this.createErrorStatus(Messages.ParameterEditDialog_default_value_error);
        }
        return Status.OK_STATUS;
    }

    private Status createErrorStatus(String message) {
        return new Status(4, CUIPlugin.getPluginId(), 4, message, null);
    }
}

