/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.rpm.createrepo.dnd;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerDropAdapter;
import org.eclipse.linuxtools.internal.rpm.createrepo.CreaterepoProject;
import org.eclipse.linuxtools.internal.rpm.createrepo.CreaterepoUtils;
import org.eclipse.linuxtools.internal.rpm.createrepo.Messages;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.FileTransfer;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.ui.console.MessageConsoleStream;

public class ImportRPMDropListener
extends ViewerDropAdapter {
    private CreaterepoProject project;

    public ImportRPMDropListener(Viewer viewer, CreaterepoProject project) {
        super(viewer);
        this.project = project;
    }

    public void dragEnter(DropTargetEvent event) {
        if (FileTransfer.getInstance().isSupportedType(event.currentDataType)) {
            event.detail = 1;
        }
    }

    public boolean validateDrop(Object target, int operation, TransferData transferType) {
        return FileTransfer.getInstance().isSupportedType(transferType) && operation == 1;
    }

    public boolean performDrop(Object data) {
        if (data instanceof String[] var2_3) {
            void var8_4 = dragData;
            int n = ((void)var8_4).length;
            int n2 = 0;
            while (n2 < n) {
                void str = var8_4[n2];
                Path path = new Path((String)str);
                try {
                    this.project.importRPM(path.toFile());
                }
                catch (CoreException e) {
                    MessageConsoleStream os = CreaterepoUtils.findConsole(Messages.CreaterepoProject_consoleName).newMessageStream();
                    os.print(NLS.bind((String)Messages.ImportRPMDropListener_errorCopyingFileToProject, (Object)path.segment(path.segmentCount() - 1)));
                }
                ++n2;
            }
            return true;
        }
        return false;
    }
}

