/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.modisco.facet.widgets.celleditors.internal.ui;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.modisco.facet.widgets.celleditors.IModelCellEditHandler;
import org.eclipse.modisco.facet.widgets.celleditors.internal.ui.FeatureValuesInput;
import org.eclipse.swt.widgets.Shell;

public abstract class AbstractNaryEditingDialog<T>
extends Dialog {
    public static final int AVAILABLE_VALUES_TREE_WIDTH = 200;
    public static final int AVAILABLE_VALUES_TREE_HEIGHT = 250;
    private final List<T> values;
    private final IModelCellEditHandler editHandler;
    private final EObject eObject;
    private final EStructuralFeature feature;

    protected AbstractNaryEditingDialog(Shell shell, List<T> values, IModelCellEditHandler editHandler, EObject eObject, EStructuralFeature feature) {
        super(shell);
        this.values = new ArrayList<T>(values);
        this.feature = feature;
        this.editHandler = editHandler;
        this.eObject = eObject;
    }

    public List<T> getValue() {
        return this.values;
    }

    public void upButtonClicked() {
        IStructuredSelection selection = (IStructuredSelection)this.getSelection();
        int minIndex = 0;
        for (Object element : selection.toList()) {
            int index = this.values.indexOf(element);
            T object = this.values.set(Math.max(index - 1, minIndex++), element);
            this.values.set(index, object);
        }
        this.refresh();
    }

    public void downButtonClicked() {
        StructuredSelection selection = (StructuredSelection)this.getSelection();
        List selectionList = selection.toList();
        boolean canMove = !selectionList.contains(this.values.get(this.values.size() - 1));
        int i = this.values.size() - 2;
        while (i >= 0) {
            T selectedObject = this.values.get(i);
            if (selectionList.contains(selectedObject)) {
                if (canMove) {
                    T object = this.values.set(i + 1, selectedObject);
                    this.values.set(i, object);
                }
            } else {
                canMove = true;
            }
            --i;
        }
        this.refresh();
    }

    public abstract ISelection getSelection();

    public abstract void refresh();

    protected void okPressed() {
        super.okPressed();
        this.editHandler.commit();
    }

    protected List<T> getValues() {
        return this.values;
    }

    protected IModelCellEditHandler getEditHandler() {
        return this.editHandler;
    }

    protected EObject geteObject() {
        return this.eObject;
    }

    protected EStructuralFeature getFeature() {
        return this.feature;
    }

    public class AssignedValuesContentProvider
    implements IStructuredContentProvider {
        public Object[] getElements(Object inputElement) {
            if (inputElement instanceof FeatureValuesInput) {
                FeatureValuesInput valuesInput = (FeatureValuesInput)inputElement;
                EObject source = valuesInput.getSource();
                List list = (List)source.eGet(valuesInput.getFeature());
                if (list == null) {
                    return new Object[0];
                }
                return list.toArray();
            }
            if (inputElement instanceof List) {
                return ((List)inputElement).toArray();
            }
            throw new IllegalArgumentException(String.valueOf(FeatureValuesInput.class.getSimpleName()) + " expected");
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }
}

