/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.ui.wizards;

import java.net.URL;
import java.util.ArrayList;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.ElementTreeSelectionDialog;
import org.eclipse.ui.dialogs.ISelectionStatusValidator;
import org.eclipse.ui.model.WorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import org.eclipse.ui.views.navigator.ResourceComparator;
import org.eclipse.wst.jsdt.core.IIncludePathEntry;
import org.eclipse.wst.jsdt.core.IJavaScriptProject;
import org.eclipse.wst.jsdt.core.LibrarySuperType;
import org.eclipse.wst.jsdt.internal.ui.JavaScriptPlugin;
import org.eclipse.wst.jsdt.internal.ui.wizards.NewWizardMessages;
import org.eclipse.wst.jsdt.internal.ui.wizards.TypedElementSelectionValidator;
import org.eclipse.wst.jsdt.internal.ui.wizards.TypedViewerFilter;
import org.eclipse.wst.jsdt.internal.ui.wizards.buildpaths.ArchiveFileFilter;
import org.eclipse.wst.jsdt.internal.ui.wizards.buildpaths.CPListElement;
import org.eclipse.wst.jsdt.internal.ui.wizards.buildpaths.JavadocLocationDialog;
import org.eclipse.wst.jsdt.internal.ui.wizards.buildpaths.JsGlobalScopeContainerWizard;
import org.eclipse.wst.jsdt.internal.ui.wizards.buildpaths.MultipleFolderSelectionDialog;
import org.eclipse.wst.jsdt.internal.ui.wizards.buildpaths.SourceAttachmentDialog;
import org.eclipse.wst.jsdt.ui.JavaScriptUI;

public final class BuildPathDialogAccess {
    private BuildPathDialogAccess() {
    }

    public static IIncludePathEntry configureSourceAttachment(Shell shell, IIncludePathEntry initialEntry) {
        if (initialEntry == null) {
            throw new IllegalArgumentException();
        }
        int entryKind = initialEntry.getEntryKind();
        if (entryKind != 1 && entryKind != 4) {
            throw new IllegalArgumentException();
        }
        SourceAttachmentDialog dialog = new SourceAttachmentDialog(shell, initialEntry);
        if (dialog.open() == 0) {
            return dialog.getResult();
        }
        return null;
    }

    public static URL[] configureJavadocLocation(Shell shell, String libraryName, URL initialURL) {
        if (libraryName == null) {
            throw new IllegalArgumentException();
        }
        JavadocLocationDialog dialog = new JavadocLocationDialog(shell, libraryName, initialURL);
        if (dialog.open() == 0) {
            return new URL[]{dialog.getResult()};
        }
        return null;
    }

    public static IIncludePathEntry configureJavadocLocation(Shell shell, IIncludePathEntry initialEntry) {
        if (initialEntry == null) {
            throw new IllegalArgumentException();
        }
        int entryKind = initialEntry.getEntryKind();
        if (entryKind != 1 && entryKind != 4) {
            throw new IllegalArgumentException();
        }
        URL location = JavaScriptUI.getLibraryJSdocLocation(initialEntry);
        JavadocLocationDialog dialog = new JavadocLocationDialog(shell, initialEntry.getPath().toString(), location);
        if (dialog.open() == 0) {
            CPListElement element = CPListElement.createFromExisting(initialEntry, null);
            URL res = dialog.getResult();
            element.setAttribute("javadoc_location", res != null ? res.toExternalForm() : null);
            return element.getClasspathEntry();
        }
        return null;
    }

    public static IIncludePathEntry configureContainerEntry(Shell shell, IIncludePathEntry initialEntry, IJavaScriptProject project, IIncludePathEntry[] currentClasspath) {
        IIncludePathEntry[] created;
        if (initialEntry == null || currentClasspath == null) {
            throw new IllegalArgumentException();
        }
        JsGlobalScopeContainerWizard wizard = new JsGlobalScopeContainerWizard(initialEntry, project, currentClasspath);
        if (JsGlobalScopeContainerWizard.openWizard(shell, wizard) == 0 && (created = wizard.getNewEntries()) != null && created.length == 1) {
            return created[0];
        }
        return null;
    }

    public static IIncludePathEntry[] chooseContainerEntries(Shell shell, IJavaScriptProject project, IIncludePathEntry[] currentClasspath) {
        if (currentClasspath == null) {
            throw new IllegalArgumentException();
        }
        JsGlobalScopeContainerWizard wizard = new JsGlobalScopeContainerWizard(null, project, currentClasspath);
        if (JsGlobalScopeContainerWizard.openWizard(shell, wizard) == 0) {
            return wizard.getNewEntries();
        }
        return null;
    }

    public static IPath configureJAREntry(Shell shell, IPath initialEntry, IPath[] usedEntries) {
        if (initialEntry == null || usedEntries == null) {
            throw new IllegalArgumentException();
        }
        Class[] acceptedClasses = new Class[]{IFile.class};
        TypedElementSelectionValidator validator = new TypedElementSelectionValidator(acceptedClasses, false);
        ArrayList<IResource> usedJars = new ArrayList<IResource>(usedEntries.length);
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        int i = 0;
        while (i < usedEntries.length) {
            IResource resource;
            IPath curr = usedEntries[i];
            if (!curr.equals((Object)initialEntry) && (resource = root.findMember(usedEntries[i])) instanceof IFile) {
                usedJars.add(resource);
            }
            ++i;
        }
        IResource existing = root.findMember(initialEntry);
        ElementTreeSelectionDialog dialog = new ElementTreeSelectionDialog(shell, (ILabelProvider)new WorkbenchLabelProvider(), (ITreeContentProvider)new WorkbenchContentProvider());
        dialog.setValidator((ISelectionStatusValidator)validator);
        dialog.setTitle(NewWizardMessages.BuildPathDialogAccess_JARArchiveDialog_edit_title);
        dialog.setMessage(NewWizardMessages.BuildPathDialogAccess_JARArchiveDialog_edit_description);
        dialog.addFilter((ViewerFilter)new ArchiveFileFilter(usedJars, true));
        dialog.setInput((Object)root);
        dialog.setComparator((ViewerComparator)new ResourceComparator(1));
        dialog.setInitialSelection((Object)existing);
        if (dialog.open() == 0) {
            IResource element = (IResource)dialog.getFirstResult();
            return element.getFullPath();
        }
        return null;
    }

    public static IPath[] chooseJAREntries(Shell shell, IPath initialSelection, IPath[] usedEntries) {
        if (usedEntries == null) {
            throw new IllegalArgumentException();
        }
        Class[] acceptedClasses = new Class[]{IFile.class};
        TypedElementSelectionValidator validator = new TypedElementSelectionValidator(acceptedClasses, true);
        ArrayList<IResource> usedJars = new ArrayList<IResource>(usedEntries.length);
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        int i = 0;
        while (i < usedEntries.length) {
            IResource resource = root.findMember(usedEntries[i]);
            if (resource instanceof IFile) {
                usedJars.add(resource);
            }
            ++i;
        }
        IResource focus = initialSelection != null ? root.findMember(initialSelection) : null;
        ElementTreeSelectionDialog dialog = new ElementTreeSelectionDialog(shell, (ILabelProvider)new WorkbenchLabelProvider(), (ITreeContentProvider)new WorkbenchContentProvider());
        dialog.setHelpAvailable(false);
        dialog.setValidator((ISelectionStatusValidator)validator);
        dialog.setTitle(NewWizardMessages.BuildPathDialogAccess_JARArchiveDialog_new_title);
        dialog.setMessage(NewWizardMessages.BuildPathDialogAccess_JARArchiveDialog_new_description);
        dialog.addFilter((ViewerFilter)new ArchiveFileFilter(usedJars, true));
        dialog.setInput((Object)root);
        dialog.setComparator((ViewerComparator)new ResourceComparator(1));
        dialog.setInitialSelection((Object)focus);
        if (dialog.open() == 0) {
            Object[] elements = dialog.getResult();
            IPath[] res = new IPath[elements.length];
            int i2 = 0;
            while (i2 < res.length) {
                IResource elem = (IResource)elements[i2];
                res[i2] = elem.getFullPath();
                ++i2;
            }
            return res;
        }
        return null;
    }

    public static LibrarySuperType chooseSuperType(Shell shell, CPListElement[] cpEntries, LibrarySuperType initialSelection, IJavaScriptProject project) {
        if (cpEntries == null) {
            throw new IllegalArgumentException();
        }
        ArrayList<LibrarySuperType> allLibsSuper = new ArrayList<LibrarySuperType>();
        int i = 0;
        while (i < cpEntries.length) {
            LibrarySuperType libSuperParent = new LibrarySuperType(cpEntries[i].getPath(), cpEntries[i].getJavaProject());
            if (libSuperParent.hasChildren()) {
                allLibsSuper.add(libSuperParent);
            }
            ++i;
        }
        boolean currentIsValid = initialSelection != null && allLibsSuper.contains(initialSelection.getParent());
        LibrarySuperType[] libSupers = allLibsSuper.toArray(new LibrarySuperType[allLibsSuper.size()]);
        class LibrarySuperTypeContentProvider
        implements ITreeContentProvider,
        ILabelProvider,
        ISelectionStatusValidator {
            LibrarySuperTypeContentProvider() {
            }

            public Object[] getChildren(Object parentElement) {
                if (parentElement == null) {
                    return null;
                }
                return ((LibrarySuperType)parentElement).getChildren();
            }

            public Object getParent(Object element) {
                if (element == null) {
                    return null;
                }
                return ((LibrarySuperType)element).getParent();
            }

            public boolean hasChildren(Object element) {
                if (element == null) {
                    return false;
                }
                return ((LibrarySuperType)element).hasChildren();
            }

            public Object[] getElements(Object inputElement) {
                if (inputElement instanceof Object[]) {
                    return (Object[])inputElement;
                }
                return new Object[]{inputElement};
            }

            public void dispose() {
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }

            public Image getImage(Object element) {
                return null;
            }

            public String getText(Object element) {
                if (element == null) {
                    return null;
                }
                String superTypeName = ((LibrarySuperType)element).getSuperTypeName();
                String libraryName = ((LibrarySuperType)element).getLibraryName();
                if (superTypeName != null) {
                    return superTypeName;
                }
                return libraryName;
            }

            public void addListener(ILabelProviderListener listener) {
            }

            public boolean isLabelProperty(Object element, String property) {
                return false;
            }

            public void removeListener(ILabelProviderListener listener) {
            }

            public IStatus validate(Object[] selection) {
                if (selection == null || selection.length != 1) {
                    return new Status(4, JavaScriptPlugin.getPluginId(), 4, null, null);
                }
                if (!(selection[0] instanceof LibrarySuperType)) {
                    return new Status(4, JavaScriptPlugin.getPluginId(), 4, null, null);
                }
                if (((LibrarySuperType)selection[0]).isParent()) {
                    return new Status(4, JavaScriptPlugin.getPluginId(), 4, null, null);
                }
                return new Status(0, JavaScriptPlugin.getPluginId(), 0, "", null);
            }
        }
        LibrarySuperTypeContentProvider libValidator = new LibrarySuperTypeContentProvider();
        ElementTreeSelectionDialog dialog = new ElementTreeSelectionDialog(shell, (ILabelProvider)libValidator, (ITreeContentProvider)libValidator);
        dialog.setAllowMultiple(false);
        dialog.setHelpAvailable(false);
        dialog.setInput((Object)libSupers);
        dialog.setValidator((ISelectionStatusValidator)libValidator);
        dialog.setTitle(NewWizardMessages.BuildPathDialogAccess_SuperTypeSelection);
        dialog.setMessage(NewWizardMessages.BuildPathDialogAccess_SelectSupertType);
        if (currentIsValid) {
            dialog.setInitialSelection((Object)initialSelection);
        }
        if (dialog.open() == 0) {
            Object[] elements = dialog.getResult();
            if (elements == null || elements.length == 0 || !(elements[0] instanceof LibrarySuperType)) {
                return null;
            }
            return (LibrarySuperType)elements[0];
        }
        return null;
    }

    public static IPath configureExternalJAREntry(Shell shell, IPath initialEntry) {
        if (initialEntry == null) {
            throw new IllegalArgumentException();
        }
        String lastUsedPath = initialEntry.removeLastSegments(1).toOSString();
        FileDialog dialog = new FileDialog(shell, 4);
        dialog.setText(NewWizardMessages.BuildPathDialogAccess_ExtJARArchiveDialog_edit_title);
        dialog.setFilterExtensions(ArchiveFileFilter.FILTER_EXTENSIONS);
        dialog.setFilterPath(lastUsedPath);
        dialog.setFileName(initialEntry.lastSegment());
        String res = dialog.open();
        if (res == null) {
            return null;
        }
        JavaScriptPlugin.getDefault().getDialogSettings().put("org.eclipse.wst.jsdt.ui.lastextjar", dialog.getFilterPath());
        return Path.fromOSString((String)res).makeAbsolute();
    }

    public static IPath[] chooseExternalJAREntries(Shell shell) {
        String lastUsedPath = JavaScriptPlugin.getDefault().getDialogSettings().get("org.eclipse.wst.jsdt.ui.lastextjar");
        if (lastUsedPath == null) {
            lastUsedPath = "";
        }
        FileDialog dialog = new FileDialog(shell, 2);
        dialog.setText(NewWizardMessages.BuildPathDialogAccess_ExtJARArchiveDialog_new_title);
        dialog.setFilterExtensions(ArchiveFileFilter.FILTER_EXTENSIONS);
        dialog.setFilterPath(lastUsedPath);
        String res = dialog.open();
        if (res == null) {
            return null;
        }
        String[] fileNames = dialog.getFileNames();
        int nChosen = fileNames.length;
        IPath filterPath = Path.fromOSString((String)dialog.getFilterPath());
        IPath[] elems = new IPath[nChosen];
        int i = 0;
        while (i < nChosen) {
            elems[i] = filterPath.append(fileNames[i]).makeAbsolute();
            ++i;
        }
        JavaScriptPlugin.getDefault().getDialogSettings().put("org.eclipse.wst.jsdt.ui.lastextjar", dialog.getFilterPath());
        return elems;
    }

    public static IPath[] chooseClassFolderEntries(Shell shell, IPath initialSelection, IPath[] usedEntries) {
        if (usedEntries == null) {
            throw new IllegalArgumentException();
        }
        String title = NewWizardMessages.BuildPathDialogAccess_ExistingClassFolderDialog_new_title;
        String message = NewWizardMessages.BuildPathDialogAccess_ExistingClassFolderDialog_new_description;
        return BuildPathDialogAccess.internalChooseFolderEntry(shell, initialSelection, usedEntries, title, message);
    }

    public static IPath[] chooseSourceFolderEntries(Shell shell, IPath initialSelection, IPath[] usedEntries) {
        if (usedEntries == null) {
            throw new IllegalArgumentException();
        }
        String title = NewWizardMessages.BuildPathDialogAccess_ExistingSourceFolderDialog_new_title;
        String message = NewWizardMessages.BuildPathDialogAccess_ExistingSourceFolderDialog_new_description;
        return BuildPathDialogAccess.internalChooseFolderEntry(shell, initialSelection, usedEntries, title, message);
    }

    private static IPath[] internalChooseFolderEntry(Shell shell, IPath initialSelection, IPath[] usedEntries, String title, String message) {
        Class[] acceptedClasses = new Class[]{IProject.class, IFolder.class};
        ArrayList<IResource> usedContainers = new ArrayList<IResource>(usedEntries.length);
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        int i = 0;
        while (i < usedEntries.length) {
            IResource resource = root.findMember(usedEntries[i]);
            if (resource instanceof IContainer) {
                usedContainers.add(resource);
            }
            ++i;
        }
        IResource focus = initialSelection != null ? root.findMember(initialSelection) : null;
        Object[] used = usedContainers.toArray();
        MultipleFolderSelectionDialog dialog = new MultipleFolderSelectionDialog(shell, (ILabelProvider)new WorkbenchLabelProvider(), (ITreeContentProvider)new WorkbenchContentProvider());
        dialog.setExisting(used);
        dialog.setTitle(title);
        dialog.setMessage(message);
        dialog.setHelpAvailable(false);
        dialog.addFilter(new TypedViewerFilter(acceptedClasses, used));
        dialog.setInput(root);
        dialog.setInitialFocus(focus);
        if (dialog.open() == 0) {
            Object[] elements = dialog.getResult();
            IPath[] res = new IPath[elements.length];
            int i2 = 0;
            while (i2 < res.length) {
                IResource elem = (IResource)elements[i2];
                res[i2] = elem.getFullPath();
                ++i2;
            }
            return res;
        }
        return null;
    }
}

