/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.queries.intervals;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.lucene.queries.intervals.IntervalIterator;
import org.apache.lucene.queries.intervals.IntervalMatchesIterator;
import org.apache.lucene.search.FilterMatchesIterator;
import org.apache.lucene.search.MatchesIterator;
import org.apache.lucene.search.MatchesUtils;
import org.apache.lucene.search.Query;

class ConjunctionMatchesIterator
implements IntervalMatchesIterator {
    final IntervalIterator iterator;
    final List<? extends IntervalMatchesIterator> subs;
    boolean cached = true;

    ConjunctionMatchesIterator(IntervalIterator iterator, List<? extends IntervalMatchesIterator> subs) {
        this.iterator = iterator;
        this.subs = subs;
    }

    public boolean next() throws IOException {
        if (this.cached) {
            this.cached = false;
            return true;
        }
        return this.iterator.nextInterval() != Integer.MAX_VALUE;
    }

    public int startPosition() {
        return this.iterator.start();
    }

    public int endPosition() {
        return this.iterator.end();
    }

    public int startOffset() throws IOException {
        int start = Integer.MAX_VALUE;
        for (MatchesIterator matchesIterator : this.subs) {
            int v = matchesIterator.startOffset();
            if (v == -1) {
                return -1;
            }
            start = Math.min(start, v);
        }
        return start;
    }

    public int endOffset() throws IOException {
        int end = -1;
        for (MatchesIterator matchesIterator : this.subs) {
            int v = matchesIterator.endOffset();
            if (v == -1) {
                return -1;
            }
            end = Math.max(end, v);
        }
        return end;
    }

    public MatchesIterator getSubMatches() throws IOException {
        ArrayList<MatchesIterator> subMatches = new ArrayList<MatchesIterator>();
        for (MatchesIterator matchesIterator : this.subs) {
            Object sub = matchesIterator.getSubMatches();
            if (sub == null) {
                sub = new SingletonMatchesIterator(matchesIterator);
            }
            subMatches.add((MatchesIterator)sub);
        }
        return MatchesUtils.disjunction(subMatches);
    }

    public Query getQuery() {
        throw new UnsupportedOperationException();
    }

    @Override
    public int gaps() {
        return this.iterator.gaps();
    }

    @Override
    public int width() {
        return this.iterator.width();
    }

    static class SingletonMatchesIterator
    extends FilterMatchesIterator {
        boolean exhausted = false;

        SingletonMatchesIterator(MatchesIterator in) {
            super(in);
        }

        public boolean next() {
            if (this.exhausted) {
                return false;
            }
            this.exhausted = true;
            return true;
        }
    }
}

