/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.enablement.ibm.db2.luw.catalog.util;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.ref.WeakReference;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Vector;
import org.eclipse.datatools.connectivity.sqm.internal.core.connection.ConnectionInfo;
import org.eclipse.datatools.connectivity.sqm.internal.core.connection.DatabaseConnectionRegistry;
import org.eclipse.datatools.enablement.ibm.db2.luw.catalog.util.GUIOption;
import org.eclipse.datatools.enablement.ibm.db2.luw.catalog.util.ParseXMLFile;
import org.eclipse.datatools.enablement.ibm.db2.luw.catalog.util.WrapperConfigData;
import org.eclipse.datatools.enablement.ibm.db2.luw.model.LUWDatabase;
import org.eclipse.datatools.enablement.ibm.util.CommonOptions;
import org.eclipse.datatools.enablement.ibm.util.ConfigMessage;
import org.eclipse.datatools.modelbase.sql.schema.Database;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class WrapperConfigFile
implements WrapperConfigData {
    public static Vector instances = new Vector();
    private static final String rootNodeName = "wrapper";
    private Node rootNode = null;
    private String XMLFileName = null;
    private ParseXMLFile parser = null;
    private Hashtable textBundle = null;
    private boolean hasPropertiesFile = false;
    private boolean wrapperParsed = false;
    private String wid = null;
    private String libname = null;
    private boolean sample_contents = false;
    private boolean userid_required = false;
    private String wrapperDescription = "";
    private Hashtable wrapperoptionnameToOption = null;
    private Vector vecWrapperoptionnameToOption = null;
    private Hashtable wrapperLibraryToPlatform = null;
    private Hashtable optionnameToKey = null;
    private boolean serverParsed = false;
    private String serverPlatform = null;
    private boolean fUnixServer = false;
    private boolean allServerTypesVersionsSameDataTypes = true;
    private Hashtable serverkindnameToDescription = null;
    private Hashtable serveroptionnameToOption = null;
    private Vector vecServeroptionnameToOption = null;
    private Hashtable servertypenameToVersionlist = null;
    private Hashtable servertypenameandversionToDatatype = null;
    private boolean discoverParsed = false;
    private String discoverClassName = "";
    private Hashtable discoveroptionnameToOption = null;
    private Hashtable discoverServerOptions = null;
    private Vector vDiscoverOptions = null;
    private Vector vDiscoverServerOptions = null;
    private Hashtable discoverparmnameToParmvalue = null;
    private Vector vDiscoverParms = null;
    private boolean userParsed = false;
    private Hashtable useroptionnameToOption = null;
    private String usersMappingType = "optional";
    private boolean commonOptionsParsed = false;
    private CommonOptions commonOptions = null;
    public static final String SERVER_PLATFORM_AIX = "aix";
    public static final String SERVER_PLATFORM_WINDOWS = "windows";
    public static final String SERVER_PLATFORM_SOLARIS = "solaris";
    public static final String SERVER_PLATFORM_LINUX = "linux";
    public static final String SERVER_PLATFORM_UNIX = "unix";
    public static final String SERVER_PLATFORM_HPUX = "hpux";
    public static final String OPTION_PLATFORM_AIX = "aix";
    public static final String OPTION_PLATFORM_WINDOWS = "windows";
    public static final String OPTION_PLATFORM_SOLARIS = "solaris";
    public static final String OPTION_PLATFORM_LINUX = "linux";
    public static final String OPTION_PLATFORM_HPUX = "hpux";
    public static final String OPTION_PLATFORM_ALLUNIX = "all_unix";
    public static final String OPTION_PLATFORM_ALL = "all";
    public static final String NICKNAME_DDLSYNTAX_WITHCOL = "with_columns";
    public static final String NICKNAME_DDLSYNTAX_WITHOUTCOL = "without_columns";
    public static final String NICKNAME_DDLSYNTAX_EITHER = "either ";
    public static final String ATTRIBUTE_VALUE_YES = "Y";
    public static final String ATTRIBUTE_VALUE_NO = "N";
    public static final String USER_MAPPING_NOTSUPPORT = "not_supported";
    public static final String USER_MAPPING_OPTIONAL = "optional";
    public static final String USER_MAPPING_REQUIRED = "required";

    public WrapperConfigFile() {
        instances.addElement(new WeakReference<WrapperConfigFile>(this));
    }

    public void initFile(String wrapperID, LUWDatabase aDatabase) throws Exception {
        Thread.dumpStack();
        this.wid = wrapperID;
        ConnectionInfo conInfo = DatabaseConnectionRegistry.getInstance().getConnectionForDatabase((Database)aDatabase);
        Connection conn = conInfo.getSharedConnection();
        CallableStatement callStmt = conn.prepareCall("CALL GET_WRAP_CFG_C(?,?,?,?,?)");
        callStmt.setString(1, wrapperID);
        String clientLocale = Locale.getDefault().toString();
        if (clientLocale.length() > 5) {
            clientLocale = clientLocale.substring(0, 5);
        } else if (clientLocale.length() < 5) {
            clientLocale = "en_US";
        }
        callStmt.setString(2, clientLocale);
        callStmt.registerOutParameter(3, 12);
        callStmt.registerOutParameter(4, 12);
        callStmt.registerOutParameter(5, 4);
        callStmt.execute();
        int returncode = callStmt.getInt(5);
        if (returncode != 0) {
            String msg = new String("The GET_WRAP_CFG_C stored procedure returned an error. Return  code " + new String(String.valueOf(returncode)) + ", wrapper id: " + wrapperID + ", locale: " + clientLocale);
            String sp_msg = WrapperConfigFile.getSPMessage(returncode);
            Exception err = new Exception(String.valueOf(msg) + " " + sp_msg);
            throw err;
        }
        this.serverPlatform = callStmt.getString(3);
        callStmt.getString(4);
        ResultSet rs = callStmt.getResultSet();
        int count = 1;
        InputSource binDTDFile = null;
        InputSource binXMLFile = null;
        while (rs.next()) {
            if (count == 1) {
                ByteArrayInputStream bais = new ByteArrayInputStream(rs.getBytes(2));
                binDTDFile = new InputSource(bais);
                ++count;
                continue;
            }
            this.XMLFileName = rs.getString(1);
            Blob blob = rs.getBlob(2);
            byte[] b1 = blob.getBytes(1L, (int)blob.length());
            ByteArrayInputStream bais = new ByteArrayInputStream(b1, 0, b1.length);
            binXMLFile = new InputSource(bais);
            Blob propertiesFile = rs.getBlob(3);
            if (propertiesFile == null) continue;
            byte[] b2 = propertiesFile.getBytes(1L, (int)propertiesFile.length());
            ByteArrayInputStream prop_bais = new ByteArrayInputStream(b2, 0, b2.length);
            InputStreamReader prop_isr = new InputStreamReader((InputStream)prop_bais, "UTF-8");
            this.textBundle = this.buildResources(prop_isr);
            this.hasPropertiesFile = true;
        }
        this.parser = new ParseXMLFile(binDTDFile, binXMLFile, rootNodeName);
        this.rootNode = this.parser.getRootNode();
        rs.close();
        callStmt.close();
    }

    public static Hashtable initAllFiles(LUWDatabase aDatabase) throws Exception {
        Hashtable<String, WrapperConfigFile> h = new Hashtable<String, WrapperConfigFile>();
        CallableStatement callStmt = null;
        String clientLocale = null;
        ConnectionInfo conInfo = DatabaseConnectionRegistry.getInstance().getConnectionForDatabase((Database)aDatabase);
        Connection conn = conInfo.getSharedConnection();
        try {
            callStmt = conn.prepareCall("CALL GET_WRAP_CFG_C(?,?,?,?,?)");
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        callStmt.setString(1, "");
        clientLocale = Locale.getDefault().toString();
        if (clientLocale.length() > 5) {
            clientLocale = clientLocale.substring(0, 5);
        } else if (clientLocale.length() < 5) {
            clientLocale = "en_US";
        }
        callStmt.setString(2, clientLocale);
        callStmt.registerOutParameter(3, 12);
        callStmt.registerOutParameter(4, 12);
        callStmt.registerOutParameter(5, 4);
        callStmt.execute();
        int returncode = callStmt.getInt(5);
        if (returncode != 0) {
            String msg = new String("The GET_WRAP_CFG_C stored procedure returned an error. Return  code " + new String(String.valueOf(returncode)) + ", locale: " + clientLocale);
            String sp_msg = WrapperConfigFile.getSPMessage(returncode);
            Exception err = new Exception(String.valueOf(msg) + " " + sp_msg);
            throw err;
        }
        String tempServerPlatform = callStmt.getString(3);
        callStmt.getString(4);
        ResultSet rs = callStmt.getResultSet();
        int count = 1;
        InputSource binDTDFile = null;
        InputSource binXMLFile = null;
        ByteArrayInputStream baisDTD = null;
        while (rs.next()) {
            if (count == 1) {
                baisDTD = new ByteArrayInputStream(rs.getBytes(2));
                binDTDFile = new InputSource(baisDTD);
                ++count;
                continue;
            }
            WrapperConfigFile wcf = new WrapperConfigFile();
            wcf.setServerPlatform(tempServerPlatform);
            String filename = rs.getString(1);
            wcf.setXMLFileName(filename);
            wcf.setWrapperID(filename.substring(0, filename.length() - 4));
            Blob blob = rs.getBlob(2);
            byte[] b1 = blob.getBytes(1L, (int)blob.length());
            ByteArrayInputStream bais = new ByteArrayInputStream(b1, 0, b1.length);
            binXMLFile = new InputSource(bais);
            Blob propertiesFile = rs.getBlob(3);
            if (propertiesFile != null) {
                byte[] b2 = propertiesFile.getBytes(1L, (int)propertiesFile.length());
                ByteArrayInputStream prop_bais = new ByteArrayInputStream(b2, 0, b2.length);
                InputStreamReader prop_isr = new InputStreamReader((InputStream)prop_bais, "UTF-8");
                Hashtable t = wcf.buildResources(prop_isr);
                wcf.setTextBundle(t);
                wcf.setHasTextBundle(true);
            }
            try {
                wcf.setXMLParser(new ParseXMLFile(binDTDFile, binXMLFile, rootNodeName));
                wcf.setRootNode(wcf.getXMLParser().getRootNode());
                h.put(wcf.getWrapperID(), wcf);
            }
            catch (SAXException parseError) {
                parseError.printStackTrace();
            }
        }
        rs.close();
        callStmt.close();
        return h;
    }

    public void initWithXMLFile(File XMLFile, File DTDFile, File propertiesFile) throws Exception {
        InputSource binDTDFile = null;
        InputSource binXMLFile = null;
        FileInputStream fis_xml = new FileInputStream(XMLFile);
        InputStreamReader isr_xml = new InputStreamReader((InputStream)fis_xml, "UTF-8");
        BufferedReader xmlReader = new BufferedReader(isr_xml);
        binXMLFile = new InputSource(xmlReader);
        FileInputStream fis_dtd = new FileInputStream(DTDFile);
        InputStreamReader isr_dtd = new InputStreamReader(fis_dtd);
        BufferedReader dtdReader = new BufferedReader(isr_dtd);
        binDTDFile = new InputSource(dtdReader);
        this.parser = new ParseXMLFile(binDTDFile, binXMLFile, rootNodeName);
        this.rootNode = this.parser.getRootNode();
        if (propertiesFile != null) {
            FileInputStream fis_prop = new FileInputStream(propertiesFile);
            InputStreamReader isr_prop = new InputStreamReader((InputStream)fis_prop, "UTF-8");
            this.textBundle = this.buildResources(isr_prop);
            this.hasPropertiesFile = true;
        }
    }

    @Override
    public String getXMLFileName() {
        return this.XMLFileName;
    }

    public void setXMLFileName(String f) {
        this.XMLFileName = f;
    }

    public ParseXMLFile getXMLParser() {
        return this.parser;
    }

    public void setXMLParser(ParseXMLFile p) {
        this.parser = p;
    }

    public boolean hasTextBundle() {
        return this.hasPropertiesFile;
    }

    public Hashtable getTextBundle() {
        return this.textBundle;
    }

    public void setTextBundle(Hashtable p) {
        this.textBundle = p;
    }

    public void setHasTextBundle(boolean t) {
        this.hasPropertiesFile = t;
    }

    @Override
    public Node getRootNode() {
        return this.rootNode;
    }

    public void setRootNode(Node n) {
        this.rootNode = n;
    }

    @Override
    public InputSource getBinaryXMLFile() {
        return this.parser.getBinaryXMLFile();
    }

    @Override
    public InputSource getBinaryDTDFile() {
        return this.parser.getBinaryDTDFile();
    }

    @Override
    public String getServerPlatform() {
        return this.serverPlatform;
    }

    public void setServerPlatform(String sp) {
        this.serverPlatform = sp;
    }

    @Override
    public Enumeration getServerTypes() throws Exception {
        if (!this.serverParsed) {
            this.getServer();
        }
        return this.servertypenameToVersionlist.keys();
    }

    @Override
    public Hashtable getServerOptions() throws Exception {
        if (!this.serverParsed) {
            this.getServer();
        }
        return this.serveroptionnameToOption;
    }

    public Vector getServerOptionsVector() throws Exception {
        if (!this.serverParsed) {
            this.getServer();
        }
        return this.vecServeroptionnameToOption;
    }

    @Override
    public Vector getServerVersionsByType(String serverType) throws Exception {
        if (!this.serverParsed) {
            this.getServer();
        }
        Vector v = (Vector)this.servertypenameToVersionlist.get(serverType);
        return v;
    }

    @Override
    public Hashtable getServerKinds() throws Exception {
        if (!this.serverParsed) {
            this.getServer();
        }
        return this.serverkindnameToDescription;
    }

    @Override
    public String getLibname() throws Exception {
        if (!this.serverParsed) {
            this.getServer();
        }
        return this.libname;
    }

    public boolean isAllServerTypesVersionsSameDataTypes() throws Exception {
        if (!this.serverParsed) {
            this.getServer();
        }
        return this.allServerTypesVersionsSameDataTypes;
    }

    @Override
    public Hashtable getWrapperOptions() throws Exception {
        if (!this.wrapperParsed) {
            this.getWrapper();
        }
        return this.wrapperoptionnameToOption;
    }

    public Vector getWrapperOptionsVector() throws Exception {
        if (!this.wrapperParsed) {
            this.getWrapper();
        }
        return this.vecWrapperoptionnameToOption;
    }

    public Hashtable getLibraries() throws Exception {
        if (!this.wrapperParsed) {
            this.getWrapper();
        }
        return this.wrapperLibraryToPlatform;
    }

    @Override
    public String getWrapperID() throws Exception {
        if (!this.wrapperParsed) {
            this.getWrapper();
        }
        return this.wid;
    }

    public void setWrapperID(String w) throws Exception {
        this.wid = w;
    }

    @Override
    public String getWrapperDescription() throws Exception {
        if (!this.wrapperParsed) {
            this.getWrapper();
        }
        return this.wrapperDescription;
    }

    @Override
    public boolean isSampleContentsAvailable() throws Exception {
        if (!this.wrapperParsed) {
            this.getWrapper();
        }
        return this.sample_contents;
    }

    @Override
    public boolean isServerUseridRequired() throws Exception {
        if (!this.wrapperParsed) {
            this.getWrapper();
        }
        return this.userid_required;
    }

    public boolean isServerUseridRequired(String serverType) throws Exception {
        if (!this.wrapperParsed) {
            this.getWrapper();
        }
        return this.userid_required;
    }

    public Hashtable getOriginalKeyTable() throws Exception {
        if (!this.wrapperParsed) {
            this.getWrapper();
        }
        if (!this.serverParsed) {
            this.getServer();
        }
        return this.optionnameToKey;
    }

    @Override
    public Hashtable getDiscoverOptions() throws Exception {
        if (!this.discoverParsed) {
            this.getDiscover();
        }
        return this.discoveroptionnameToOption;
    }

    @Override
    public Hashtable getDiscoverServerOptions() throws Exception {
        if (!this.discoverParsed) {
            this.getDiscover();
        }
        return this.discoverServerOptions;
    }

    @Override
    public Vector getDiscoverOptionsVector() throws Exception {
        if (!this.discoverParsed) {
            this.getDiscover();
        }
        return this.vDiscoverOptions;
    }

    @Override
    public Vector getDiscoverServerOptionsVector() throws Exception {
        if (!this.discoverParsed) {
            this.getDiscover();
        }
        return this.vDiscoverServerOptions;
    }

    @Override
    public Hashtable getDiscoverParms() throws Exception {
        if (!this.discoverParsed) {
            this.getDiscover();
        }
        return this.discoverparmnameToParmvalue;
    }

    public Vector getDiscoverParmsVector() throws Exception {
        if (!this.discoverParsed) {
            this.getDiscover();
        }
        return this.vDiscoverParms;
    }

    @Override
    public String getDiscoverClassName() throws Exception {
        if (!this.discoverParsed) {
            this.getDiscover();
        }
        return this.discoverClassName;
    }

    public Hashtable getUserOptions() throws Exception {
        if (this.useroptionnameToOption == null) {
            this.getUser();
        }
        return this.useroptionnameToOption;
    }

    public String getUsersMappingType() throws Exception {
        if (!this.userParsed) {
            this.getUser();
        }
        return this.usersMappingType;
    }

    private void getWrapper() throws Exception {
        String valueUseridRequired;
        if (this.wid == null) {
            this.wid = this.findAttribute(this.rootNode, "wrapper_id", "");
        }
        this.wrapperLibraryToPlatform = new Hashtable();
        this.optionnameToKey = new Hashtable();
        String valueSampleConents = this.findAttribute(this.rootNode, "sample_contents", "");
        if (valueSampleConents.equals(ATTRIBUTE_VALUE_YES)) {
            this.sample_contents = true;
        }
        if ((valueUseridRequired = this.findAttribute(this.rootNode, "userid_required", "")).equals(ATTRIBUTE_VALUE_YES)) {
            this.userid_required = true;
        }
        if (this.serverPlatform != null && (this.serverPlatform.equals("aix") || this.serverPlatform.equals("solaris") || this.serverPlatform.equals(SERVER_PLATFORM_UNIX) || this.serverPlatform.equals("linux") || this.serverPlatform.equals("hpux"))) {
            this.fUnixServer = true;
        }
        Node child = this.rootNode.getFirstChild();
        while (child != null) {
            if ("description".equals(child.getNodeName())) {
                Node tNode = child.getFirstChild();
                if (tNode != null) {
                    String textDescription;
                    this.wrapperDescription = tNode.getNodeValue().trim();
                    if (this.optionnameToKey != null) {
                        this.optionnameToKey.put("WRAPPER_DESC", this.wrapperDescription);
                    }
                    if (this.hasTextBundle() && this.wrapperDescription.length() > 0 && (textDescription = this.getResource(this.wrapperDescription)).length() > 0) {
                        this.wrapperDescription = textDescription;
                    }
                }
            } else if ("wrapper_options".equals(child.getNodeName())) {
                this.wrapperoptionnameToOption = this.getOptions(child);
                this.vecWrapperoptionnameToOption = this.getOptionsVector(child);
            } else if ("libraries".equals(child.getNodeName())) {
                if (this.serverPlatform != null) {
                    this.libname = this.serverPlatform.equals("aix") ? this.findAttribute(child, "aix", "") : (this.serverPlatform.equals("windows") ? this.findAttribute(child, "windows", "") : (this.serverPlatform.equals("solaris") ? this.findAttribute(child, "solaris", "") : (this.serverPlatform.equals("linux") ? this.findAttribute(child, "linux", "") : (this.serverPlatform.equals("hpux") ? this.findAttribute(child, "hpux", "") : (this.serverPlatform.equals(SERVER_PLATFORM_UNIX) ? this.findAttribute(child, SERVER_PLATFORM_UNIX, "") : "")))));
                }
                this.libname = this.findAttribute(child, "windows", "");
                if (this.libname.length() > 0) {
                    this.wrapperLibraryToPlatform.put("windows", this.libname);
                }
                this.libname = this.findAttribute(child, "aix", "");
                if (this.libname.length() > 0) {
                    this.wrapperLibraryToPlatform.put("aix", this.libname);
                }
                this.libname = this.findAttribute(child, "solaris", "");
                if (this.libname.length() > 0) {
                    this.wrapperLibraryToPlatform.put("solaris", this.libname);
                }
                this.libname = this.findAttribute(child, "hpux", "");
                if (this.libname.length() > 0) {
                    this.wrapperLibraryToPlatform.put("hpux", this.libname);
                }
                this.libname = this.findAttribute(child, SERVER_PLATFORM_UNIX, "");
                if (this.libname.length() > 0) {
                    this.wrapperLibraryToPlatform.put(SERVER_PLATFORM_UNIX, this.libname);
                }
                this.libname = this.findAttribute(child, "linux", "");
                if (this.libname.length() > 0) {
                    this.wrapperLibraryToPlatform.put("linux", this.libname);
                }
            }
            child = child.getNextSibling();
        }
        if (this.wrapperoptionnameToOption == null) {
            this.wrapperoptionnameToOption = new Hashtable();
        }
        if (this.vecWrapperoptionnameToOption == null) {
            this.vecWrapperoptionnameToOption = new Vector();
        }
        this.wrapperParsed = true;
    }

    private void getServer() throws Exception {
        if (this.serverPlatform != null && (this.serverPlatform.equals("aix") || this.serverPlatform.equals("solaris") || this.serverPlatform.equals(SERVER_PLATFORM_UNIX) || this.serverPlatform.equals("linux") || this.serverPlatform.equals("hpux"))) {
            this.fUnixServer = true;
        }
        this.serverkindnameToDescription = new Hashtable();
        this.servertypenameToVersionlist = new Hashtable();
        this.servertypenameandversionToDatatype = new Hashtable();
        Node child = this.rootNode.getFirstChild();
        while (child != null) {
            if ("server_kind".equals(child.getNodeName())) {
                String textDisplayName;
                String name = this.findAttribute(child, "display_name", "");
                if (this.optionnameToKey != null) {
                    this.optionnameToKey.put("SERVER_DISPLAYNAME", name);
                }
                if (this.hasTextBundle() && name.length() > 0 && (textDisplayName = this.getResource(name)).length() > 0) {
                    name = textDisplayName;
                }
                Node descNode = child.getFirstChild();
                String desc = "";
                while (descNode != null) {
                    Node tNode;
                    if ("description".equals(descNode.getNodeName()) && (tNode = descNode.getFirstChild()) != null) {
                        String textDescription;
                        desc = tNode.getNodeValue().trim();
                        if (this.hasTextBundle() && desc.length() > 0 && (textDescription = this.getResource(desc)).length() > 0) {
                            desc = textDescription;
                        }
                    }
                    descNode = descNode.getNextSibling();
                }
                if (desc == null) {
                    this.serverkindnameToDescription.put(name, "");
                } else {
                    this.serverkindnameToDescription.put(name, desc);
                }
            } else if ("libraries".equals(child.getNodeName())) {
                if (this.serverPlatform != null) {
                    this.libname = this.serverPlatform.equals("aix") ? this.findAttribute(child, "aix", "") : (this.serverPlatform.equals("windows") ? this.findAttribute(child, "windows", "") : (this.serverPlatform.equals("solaris") ? this.findAttribute(child, "solaris", "") : (this.serverPlatform.equals("linux") ? this.findAttribute(child, "linux", "") : (this.serverPlatform.equals("hpux") ? this.findAttribute(child, "hpux", "") : (this.serverPlatform.equals(SERVER_PLATFORM_UNIX) ? this.findAttribute(child, SERVER_PLATFORM_UNIX, "") : "")))));
                }
            } else if ("servers".equals(child.getNodeName())) {
                Node typesNode = child.getFirstChild();
                while (typesNode != null) {
                    if ("types".equals(typesNode.getNodeName())) {
                        Node typeNode = typesNode.getFirstChild();
                        while (typeNode != null) {
                            if ("type".equals(typeNode.getNodeName())) {
                                Vector<String> vValues = new Vector<String>();
                                String typeName = this.findAttribute(typeNode, "name", "");
                                Node versionNode = typeNode.getFirstChild();
                                while (versionNode != null) {
                                    if ("version".equals(versionNode.getNodeName())) {
                                        String versionValue = this.findAttribute(versionNode, "version_number", "");
                                        if (versionValue.length() > 0) {
                                            vValues.add(versionValue);
                                        }
                                        Node datatypeNode = versionNode.getFirstChild();
                                        while (datatypeNode != null) {
                                            if ("column_datatypes".equals(datatypeNode.getNodeName())) {
                                                this.allServerTypesVersionsSameDataTypes = false;
                                                Vector vVersionDataTypes = this.getDatatypes(datatypeNode);
                                                if (versionValue.length() > 0) {
                                                    this.servertypenameandversionToDatatype.put(String.valueOf(typeName) + versionValue, vVersionDataTypes);
                                                }
                                            }
                                            datatypeNode = datatypeNode.getNextSibling();
                                        }
                                    }
                                    if ("column_datatypes".equals(versionNode.getNodeName())) {
                                        this.allServerTypesVersionsSameDataTypes = false;
                                        Vector vServerDataTypes = this.getDatatypes(versionNode);
                                        this.servertypenameandversionToDatatype.put(typeName, vServerDataTypes);
                                    }
                                    versionNode = versionNode.getNextSibling();
                                }
                                this.servertypenameToVersionlist.put(typeName, vValues);
                            }
                            typeNode = typeNode.getNextSibling();
                        }
                    } else if ("server_options".equals(typesNode.getNodeName())) {
                        this.serveroptionnameToOption = this.getOptions(typesNode);
                        this.vecServeroptionnameToOption = this.getOptionsVector(typesNode);
                    }
                    typesNode = typesNode.getNextSibling();
                }
            }
            child = child.getNextSibling();
        }
        if (this.serveroptionnameToOption == null) {
            this.serveroptionnameToOption = new Hashtable();
        }
        if (this.vecServeroptionnameToOption == null) {
            this.vecServeroptionnameToOption = new Vector();
        }
        this.serverParsed = true;
    }

    private void getDiscover() throws Exception {
        this.discoverparmnameToParmvalue = new Hashtable();
        this.vDiscoverOptions = new Vector();
        this.vDiscoverParms = new Vector();
        this.vDiscoverServerOptions = new Vector();
        Node child = this.rootNode.getFirstChild();
        while (child != null) {
            if ("discover".equals(child.getNodeName())) {
                this.discoverClassName = this.findAttribute(child, "class_name", "");
                int location = this.discoverClassName.lastIndexOf(".");
                String discoveryClass = this.discoverClassName.substring(location);
                if (discoveryClass.equalsIgnoreCase(".OdbcDiscovery") || discoveryClass.equalsIgnoreCase(".TeradataDiscovery")) {
                    discoveryClass = new String(".RelationalDiscovery");
                }
                this.discoverClassName = new String("com.ibm.datatools.db2.luw.serverdiscovery" + discoveryClass);
                Node propertyNode = child.getFirstChild();
                while (propertyNode != null) {
                    if ("property".equals(propertyNode.getNodeName())) {
                        String propName = this.findAttribute(propertyNode, "name", "");
                        Node tNode = propertyNode.getFirstChild();
                        if (tNode != null) {
                            this.discoverparmnameToParmvalue.put(propName, tNode.getNodeValue().trim());
                            Object[] aParm = new Object[]{propName, tNode.getNodeValue().trim()};
                            this.vDiscoverParms.add(aParm);
                        }
                    } else if ("generic_gui".equals(propertyNode.getNodeName())) {
                        this.discoveroptionnameToOption = this.getOptions(propertyNode);
                    } else if ("serverObject_gui".equals(propertyNode.getNodeName())) {
                        this.discoverServerOptions = this.getOptions(propertyNode);
                    }
                    propertyNode = propertyNode.getNextSibling();
                }
            }
            child = child.getNextSibling();
        }
        if (this.discoveroptionnameToOption == null) {
            this.discoveroptionnameToOption = new Hashtable();
        }
        if (this.discoverServerOptions == null) {
            this.discoverServerOptions = new Hashtable();
        }
        this.discoverParsed = true;
    }

    private void getUser() throws Exception {
        Node child = this.rootNode.getFirstChild();
        while (child != null) {
            if ("users".equals(child.getNodeName())) {
                this.usersMappingType = this.findAttribute(child, "user_mapping", "");
                Node userOpNode = child.getFirstChild();
                while (userOpNode != null) {
                    if ("user_options".equals(userOpNode.getNodeName())) {
                        this.useroptionnameToOption = this.getOptions(userOpNode);
                    }
                    userOpNode = userOpNode.getNextSibling();
                }
            }
            child = child.getNextSibling();
        }
        if (this.useroptionnameToOption == null) {
            this.useroptionnameToOption = new Hashtable();
        }
        this.userParsed = true;
    }

    private String findAttribute(Node node, String key, String defV) {
        NamedNodeMap nnm = node.getAttributes();
        if (nnm == null) {
            return defV;
        }
        int i = 0;
        while (i < nnm.getLength()) {
            Node attr = nnm.item(i);
            if (key.equals(attr.getNodeName())) {
                return attr.getNodeValue().trim();
            }
            ++i;
        }
        return defV;
    }

    private Hashtable getOptions(Node node) throws Exception {
        Hashtable<String, GUIOption> h = new Hashtable<String, GUIOption>();
        Node option = node.getFirstChild();
        while (option != null) {
            String optPlatform;
            if ("option".equals(option.getNodeName()) && ((optPlatform = this.findAttribute(option, "platform", "")).equals(OPTION_PLATFORM_ALL) || optPlatform.equals(this.serverPlatform) || optPlatform.equals(OPTION_PLATFORM_ALLUNIX) && this.fUnixServer)) {
                String optName = this.findAttribute(option, "name", "");
                String optDescription = this.findAttribute(option, "description", "");
                String optRequired = this.findAttribute(option, USER_MAPPING_REQUIRED, "");
                boolean fRequired = false;
                if (optRequired.equals(ATTRIBUTE_VALUE_YES)) {
                    fRequired = true;
                }
                String optEditable = this.findAttribute(option, "editable", "");
                boolean fEdit = false;
                if (optEditable.equals(ATTRIBUTE_VALUE_YES)) {
                    fEdit = true;
                }
                String optDefault = this.findAttribute(option, "default", "");
                String optHints = this.findAttribute(option, "hints", "");
                String optAlter = this.findAttribute(option, "alter", "");
                boolean fAlter = false;
                if (optAlter.equals(ATTRIBUTE_VALUE_YES)) {
                    fAlter = true;
                }
                Vector<String> vValues = new Vector<String>();
                Node values = option.getFirstChild();
                boolean fMultivalue = false;
                String optDelimiter = "";
                while (values != null) {
                    if ("values".equals(values.getNodeName())) {
                        String optMultivalue = this.findAttribute(values, "multivalue", "");
                        if (optMultivalue.equals(ATTRIBUTE_VALUE_YES)) {
                            fMultivalue = true;
                        }
                        optDelimiter = this.findAttribute(option, "delimiter", "");
                        Node setting = values.getFirstChild();
                        while (setting != null) {
                            Node settingValue;
                            if ("setting".equals(setting.getNodeName()) && (settingValue = setting.getFirstChild()) != null) {
                                String optSetting = settingValue.getNodeValue().trim();
                                vValues.add(optSetting);
                            }
                            setting = setting.getNextSibling();
                        }
                    }
                    values = values.getNextSibling();
                }
                if (optHints.length() > 0 && this.optionnameToKey != null) {
                    this.optionnameToKey.put(String.valueOf(optName) + "HINT", optHints);
                }
                if (optDescription.length() > 0 && this.optionnameToKey != null) {
                    this.optionnameToKey.put(String.valueOf(optName) + "DESC", optDescription);
                }
                if (this.hasTextBundle()) {
                    String textDescription;
                    String textHints;
                    if (optHints.length() > 0 && (textHints = this.getResource(optHints)).length() > 0) {
                        optHints = textHints;
                    }
                    if (optDescription.length() > 0 && (textDescription = this.getResource(optDescription)).length() > 0) {
                        optDescription = textDescription;
                    }
                }
                GUIOption op = new GUIOption(optName, vValues, optDefault, fEdit, fRequired, fMultivalue, fAlter, optDelimiter, optPlatform, optHints, optDescription);
                if (!h.containsKey(optName)) {
                    h.put(optName, op);
                }
                if ("generic_gui".equals(node.getNodeName())) {
                    this.vDiscoverOptions.add(op);
                }
                if ("serverObject_gui".equals(node.getNodeName())) {
                    this.vDiscoverServerOptions.add(op);
                }
            }
            option = option.getNextSibling();
        }
        return h;
    }

    private Vector getOptionsVector(Node node) throws Exception {
        Vector<GUIOption> h = new Vector<GUIOption>();
        Node option = node.getFirstChild();
        while (option != null) {
            if ("option".equals(option.getNodeName())) {
                String optPlatform = this.findAttribute(option, "platform", "");
                String optName = this.findAttribute(option, "name", "");
                String optDescription = this.findAttribute(option, "description", "");
                String optRequired = this.findAttribute(option, USER_MAPPING_REQUIRED, "");
                boolean fRequired = false;
                if (optRequired.equals(ATTRIBUTE_VALUE_YES)) {
                    fRequired = true;
                }
                String optEditable = this.findAttribute(option, "editable", "");
                boolean fEdit = false;
                if (optEditable.equals(ATTRIBUTE_VALUE_YES)) {
                    fEdit = true;
                }
                String optDefault = this.findAttribute(option, "default", "");
                String optHints = this.findAttribute(option, "hints", "");
                String optAlter = this.findAttribute(option, "alter", "");
                boolean fAlter = false;
                if (optAlter.equals(ATTRIBUTE_VALUE_YES)) {
                    fAlter = true;
                }
                Vector<String> vValues = new Vector<String>();
                Node values = option.getFirstChild();
                boolean fMultivalue = false;
                String optDelimiter = "";
                while (values != null) {
                    if ("values".equals(values.getNodeName())) {
                        String optMultivalue = this.findAttribute(values, "multivalue", "");
                        if (optMultivalue.equals(ATTRIBUTE_VALUE_YES)) {
                            fMultivalue = true;
                        }
                        optDelimiter = this.findAttribute(option, "delimiter", "");
                        Node setting = values.getFirstChild();
                        while (setting != null) {
                            Node settingValue;
                            if ("setting".equals(setting.getNodeName()) && (settingValue = setting.getFirstChild()) != null) {
                                String optSetting = settingValue.getNodeValue().trim();
                                vValues.add(optSetting);
                            }
                            setting = setting.getNextSibling();
                        }
                    }
                    values = values.getNextSibling();
                }
                if (optHints.length() > 0 && this.optionnameToKey != null) {
                    this.optionnameToKey.put(String.valueOf(optName) + "HINT", optHints);
                }
                if (optDescription.length() > 0 && this.optionnameToKey != null) {
                    this.optionnameToKey.put(String.valueOf(optName) + "DESC", optDescription);
                }
                if (this.hasTextBundle()) {
                    String textDescription;
                    String textHints;
                    if (optHints.length() > 0 && (textHints = this.getResource(optHints)).length() > 0) {
                        optHints = textHints;
                    }
                    if (optDescription.length() > 0 && (textDescription = this.getResource(optDescription)).length() > 0) {
                        optDescription = textDescription;
                    }
                }
                GUIOption op = new GUIOption(optName, vValues, optDefault, fEdit, fRequired, fMultivalue, fAlter, optDelimiter, optPlatform, optHints, optDescription);
                h.add(op);
                if ("generic_gui".equals(node.getNodeName())) {
                    this.vDiscoverOptions.add(op);
                }
                if ("serverObject_gui".equals(node.getNodeName())) {
                    this.vDiscoverServerOptions.add(op);
                }
            }
            option = option.getNextSibling();
        }
        return h;
    }

    private Vector getDatatypes(Node node) throws Exception {
        Vector<String> v = new Vector<String>();
        Node datatypeNode = node.getFirstChild();
        while (datatypeNode != null) {
            Node tNode;
            if ("datatype".equals(datatypeNode.getNodeName()) && (tNode = datatypeNode.getFirstChild()) != null) {
                v.add(tNode.getNodeValue().trim());
            }
            datatypeNode = datatypeNode.getNextSibling();
        }
        return v;
    }

    private Hashtable buildResources(InputStreamReader prop_isr) throws Exception {
        Hashtable<String, String> h = new Hashtable<String, String>();
        BufferedReader br = new BufferedReader(prop_isr);
        boolean fContinue = false;
        String key = "";
        String value = "";
        String line = br.readLine();
        while (line != null) {
            if (line.length() > 0 && !(line = line.trim()).startsWith("#")) {
                int index;
                if (!fContinue) {
                    index = line.indexOf("=");
                    if (index != -1) {
                        key = new String(line.substring(0, index));
                        key = key.trim();
                        value = new String(line.substring(index + 1));
                        value = value.trim();
                    }
                } else {
                    value = String.valueOf(value) + line;
                }
                if (value.endsWith("\\")) {
                    fContinue = true;
                    index = value.lastIndexOf("\\");
                    value = value.substring(0, index);
                } else {
                    if (key.length() > 0 && !h.containsKey(key)) {
                        h.put(key, value);
                    }
                    fContinue = false;
                }
            }
            line = br.readLine();
        }
        return h;
    }

    private String getResource(String key) {
        if (this.textBundle.containsKey(key)) {
            String value = (String)this.textBundle.get(key);
            return value;
        }
        return "";
    }

    private static String getSPMessage(int rc) {
        String sp_msg = "";
        if (rc == 40) {
            sp_msg = new String("The DB2 install path is invalid.");
        } else if (rc == 41) {
            sp_msg = new String("The wrapper XML file path is invalid.");
        } else if (rc == 42) {
            sp_msg = new String("The wrapper XML files do not exist or cannot be read. Make sure the files have public read permission.");
        } else if (rc == 43) {
            sp_msg = new String("Cannot find the default English locale directory.");
        } else if (rc == 44) {
            sp_msg = new String("No XML files were found in directory");
        } else if (rc == 45) {
            sp_msg = new String("A memory error occurred while executing the stored procedure GET_WRAP_CFG_C.");
        } else if (rc == 46) {
            sp_msg = new String("Cannot open or read wrapper.dtd file.");
        } else if (rc == 47) {
            sp_msg = new String("No XML files were found in directory.");
        } else if (rc == 48) {
            sp_msg = new String("No properties files were found in directory.");
        } else if (rc == 49) {
            sp_msg = new String("The wrapper properties files cannot be read. Make sure the files have public read permission.");
        } else {
            return "";
        }
        return sp_msg;
    }

    @Override
    public CommonOptions getCommonOptions() throws Exception {
        if (!this.commonOptionsParsed) {
            this.parseCommonOptions();
        }
        return this.commonOptions;
    }

    private void parseCommonOptions() throws Exception {
        Vector<ConfigMessage> messages = new Vector<ConfigMessage>();
        Vector configVars = new Vector();
        Node child = this.rootNode.getFirstChild();
        while (child != null) {
            if ("common_options".equals(child.getNodeName())) {
                Node node2 = child.getFirstChild();
                while (node2 != null) {
                    if ("config_variable".equals(node2.getNodeName())) {
                        String type = this.findAttribute(node2, "type", "");
                        String location = this.findAttribute(node2, "location", "");
                        Hashtable ht = this.getOptions(node2);
                        if (ht != null && ht.size() == 1 && type != null) {
                            // empty if block
                        }
                    } else if ("message".equals(node2.getNodeName())) {
                        String platform = this.findAttribute(node2, "platform", "");
                        String msgText = null;
                        Node msgTextNode = node2.getFirstChild();
                        if (msgTextNode != null) {
                            msgText = msgTextNode.getNodeValue();
                        }
                        if (msgText != null && platform != null) {
                            messages.add(new ConfigMessage(msgText, platform));
                        }
                    }
                    node2 = node2.getNextSibling();
                }
            }
            child = child.getNextSibling();
        }
        this.commonOptions = new CommonOptions(messages, configVars);
        this.commonOptionsParsed = true;
    }
}

