/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.repository;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.egit.ui.Activator;
import org.eclipse.egit.ui.internal.UIText;
import org.eclipse.egit.ui.internal.repository.CreateBranchPage;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevWalk;

public class CreateBranchWizard
extends Wizard {
    private String newBranchName;
    private CreateBranchPage myPage;

    public CreateBranchWizard(Repository repository) {
        this(repository, null);
    }

    public CreateBranchWizard(Repository repository, String base) {
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try (RevWalk rw = new RevWalk(repository);){
                if (base == null) {
                    this.myPage = new CreateBranchPage(repository, null);
                } else if (ObjectId.isId((String)base)) {
                    RevCommit commit = rw.parseCommit((AnyObjectId)ObjectId.fromString((String)base));
                    this.myPage = new CreateBranchPage(repository, commit);
                } else if (base.startsWith("refs/heads/") || base.startsWith("refs/remotes/") || base.startsWith("refs/tags/")) {
                    Ref currentBranch = repository.exactRef(base);
                    this.myPage = new CreateBranchPage(repository, currentBranch);
                } else {
                    RevCommit commit = rw.parseCommit((AnyObjectId)repository.resolve(String.valueOf(base) + "^{commit}"));
                    this.myPage = new CreateBranchPage(repository, commit);
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            Activator.handleError(e.getMessage(), e, false);
            this.myPage = new CreateBranchPage(repository, null);
        }
        this.setWindowTitle(UIText.CreateBranchWizard_NewBranchTitle);
    }

    public void addPages() {
        this.addPage((IWizardPage)this.myPage);
    }

    public boolean performFinish() {
        final CreateBranchPage cp = (CreateBranchPage)this.getPages()[0];
        this.newBranchName = cp.getBranchName();
        final boolean checkoutNewBranch = cp.checkoutNewBranch();
        try {
            this.getContainer().run(true, true, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    try {
                        cp.createBranch(CreateBranchWizard.this.newBranchName, checkoutNewBranch, monitor);
                    }
                    catch (IOException | CoreException ioe) {
                        throw new InvocationTargetException(ioe);
                    }
                }
            });
        }
        catch (InvocationTargetException ite) {
            Activator.handleError(UIText.CreateBranchWizard_CreationFailed, ite.getCause(), true);
            return false;
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return true;
    }

    public String getNewBranchName() {
        return this.newBranchName;
    }
}

