/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.wtp.overlay.internal.modulecore;

import java.util.Arrays;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.jst.common.internal.modulecore.AddClasspathFoldersParticipant;
import org.eclipse.jst.common.internal.modulecore.AddClasspathLibReferencesParticipant;
import org.eclipse.jst.common.internal.modulecore.AddMappedOutputFoldersParticipant;
import org.eclipse.jst.common.internal.modulecore.IgnoreJavaInSourceFolderParticipant;
import org.eclipse.jst.common.internal.modulecore.SingleRootExportParticipant;
import org.eclipse.jst.j2ee.internal.common.exportmodel.JEEHeirarchyExportParticipant;
import org.eclipse.jst.j2ee.internal.common.exportmodel.JavaEESingleRootCallback;
import org.eclipse.m2e.wtp.overlay.internal.modulecore.CompositeVirtualFolder;
import org.eclipse.m2e.wtp.overlay.internal.modulecore.DynamicResourceFilter;
import org.eclipse.m2e.wtp.overlay.modulecore.IOverlayVirtualComponent;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.internal.flat.FlatVirtualComponent;
import org.eclipse.wst.common.componentcore.internal.flat.IFlattenParticipant;
import org.eclipse.wst.common.componentcore.internal.resources.VirtualComponent;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.componentcore.resources.IVirtualFolder;
import org.eclipse.wst.common.componentcore.resources.IVirtualReference;

public class OverlayVirtualComponent
extends VirtualComponent
implements IOverlayVirtualComponent {
    protected IProject project;
    protected Set<String> exclusionPatterns;
    protected Set<String> inclusionPatterns;
    protected Set<IVirtualReference> references;
    private CompositeVirtualFolder cachedRoot;
    private long lastCacheUpdate;
    private static int MAX_CACHE = 2000;

    public OverlayVirtualComponent(IProject project) {
        super(project, ROOT);
        this.project = project;
    }

    public IVirtualFolder getRootFolder() {
        return this.getRoot();
    }

    private CompositeVirtualFolder getRoot() {
        IVirtualComponent component;
        if (this.cachedRoot != null && System.currentTimeMillis() - this.lastCacheUpdate < (long)MAX_CACHE) {
            return this.cachedRoot;
        }
        if (this.project != null && (component = ComponentCore.createComponent((IProject)this.project)) != null) {
            FlatVirtualComponent flatVirtualComponent = new FlatVirtualComponent(component, this.getOptions());
            DynamicResourceFilter filter = new DynamicResourceFilter(this.getInclusions(), this.getExclusions());
            this.cachedRoot = new CompositeVirtualFolder(flatVirtualComponent, ROOT, filter);
        }
        this.lastCacheUpdate = System.currentTimeMillis();
        return this.cachedRoot;
    }

    private FlatVirtualComponent.FlatComponentTaskModel getOptions() {
        FlatVirtualComponent.FlatComponentTaskModel options = new FlatVirtualComponent.FlatComponentTaskModel();
        IFlattenParticipant[] participants = new IFlattenParticipant[]{new SingleRootExportParticipant((SingleRootExportParticipant.SingleRootParticipantCallback)new JavaEESingleRootCallback()), new JEEHeirarchyExportParticipant(){

            protected boolean isApprovedNesting(String parentType, String childType, boolean binary) {
                if (childType == null) {
                    return false;
                }
                if ("jst.utility".equals(childType) && binary) {
                    return false;
                }
                return !"jst.webfragment".equals(childType) || !binary;
            }
        }, new AddClasspathLibReferencesParticipant(), new AddClasspathFoldersParticipant(), new AddMappedOutputFoldersParticipant(), new IgnoreJavaInSourceFolderParticipant()};
        options.put((Object)"org.eclipse.wst.common.componentcore.export.participantList", Arrays.asList(participants));
        return options;
    }

    @Override
    public void setInclusions(Set<String> inclusionPatterns) {
        this.inclusionPatterns = inclusionPatterns;
    }

    @Override
    public void setExclusions(Set<String> exclusionPatterns) {
        this.exclusionPatterns = exclusionPatterns;
    }

    @Override
    public Set<String> getExclusions() {
        return this.exclusionPatterns;
    }

    @Override
    public Set<String> getInclusions() {
        return this.inclusionPatterns;
    }

    public IVirtualReference[] getReferences(Map<String, Object> paramMap) {
        CompositeVirtualFolder root = this.getRoot();
        if (root != null) {
            try {
                IVirtualReference[] references = root.getReferences();
                return references;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return new IVirtualReference[0];
    }

    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.exclusionPatterns == null ? 0 : this.exclusionPatterns.hashCode());
        result = 31 * result + (this.inclusionPatterns == null ? 0 : this.inclusionPatterns.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OverlayVirtualComponent other = (OverlayVirtualComponent)obj;
        if (!super.equals(obj)) {
            return false;
        }
        if (this.exclusionPatterns == null ? other.exclusionPatterns != null : !this.exclusionPatterns.equals(other.exclusionPatterns)) {
            return false;
        }
        return !(this.inclusionPatterns == null ? other.inclusionPatterns != null : !this.inclusionPatterns.equals(other.inclusionPatterns));
    }
}

