/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.modisco.infra.browser.custom.editor.dialogs;

import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.modisco.infra.browser.custom.editor.Activator;
import org.eclipse.modisco.infra.browser.custom.editor.Messages;
import org.eclipse.modisco.infra.browser.custom.editor.dialogs.IconFeatureDialog;
import org.eclipse.modisco.infra.browser.custom.util.OverlayIconInfo;
import org.eclipse.modisco.infra.browser.custom.util.OverlayIconPosition;
import org.eclipse.modisco.infra.browser.custom.util.UicustomUtil;
import org.eclipse.modisco.infra.common.core.logging.MoDiscoLogger;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class OverlayIconFeatureDialog
extends IconFeatureDialog {
    private Text text;
    private Combo combo;

    public OverlayIconFeatureDialog(Shell parentShell, boolean withCondition, boolean withDefault, List<String> availableQuerySets, List<Class<?>> expectedReturnTypes, EClass customizedMetaclass) {
        super(parentShell, withCondition, withDefault, availableQuerySets, expectedReturnTypes, customizedMetaclass);
    }

    @Override
    protected void createValueEditor(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(2, false));
        composite.setLayoutData((Object)new GridData(4, 4, true, true));
        this.text = new Text(composite, 2048);
        this.text.setLayoutData((Object)new GridData(4, 4, true, false));
        Button button = new Button(composite, 8);
        button.setText(Messages.CustomizationEditor_btnOpenElementSelectionDialogText);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IFile selectedFile = OverlayIconFeatureDialog.super.openIconSelectionDialog(OverlayIconFeatureDialog.this.getShell(), OverlayIconFeatureDialog.this.getText().getText());
                if (selectedFile != null) {
                    OverlayIconFeatureDialog.this.getText().setText(selectedFile.getFullPath().toString());
                }
            }
        });
        this.combo = new Combo(composite, 12);
        OverlayIconPosition[] overlayIconPositionArray = OverlayIconPosition.values();
        int n = overlayIconPositionArray.length;
        int n2 = 0;
        while (n2 < n) {
            OverlayIconPosition overlayIconPosition = overlayIconPositionArray[n2];
            this.combo.add(overlayIconPosition.name());
            ++n2;
        }
        if (this.getInitialStaticValue() != null) {
            try {
                OverlayIconInfo overlayIcon = UicustomUtil.decodeOverlayIcon((String)this.getInitialStaticValue());
                this.text.setText(overlayIcon.getPath());
                this.combo.setText(overlayIcon.getIconPosition().name());
            }
            catch (Exception e) {
                MoDiscoLogger.logError((Throwable)e, (String)"Error decoding overlay icon", (Plugin)Activator.getDefault());
            }
        }
        if (this.combo.getSelectionIndex() == -1) {
            this.combo.select(0);
        }
    }

    @Override
    protected void okPressed() {
        OverlayIconPosition iconPosition = OverlayIconPosition.valueOf((String)this.combo.getText());
        this.setStaticValue(UicustomUtil.encodeOverlayIcon((String)this.text.getText(), (OverlayIconPosition)iconPosition));
        super.okPressed();
    }

    @Override
    public Text getText() {
        return this.text;
    }
}

