/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.xtext.serializer;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.ENamedElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.examples.xtext.serializer.DiagnosticStringBuilder;
import org.eclipse.ocl.examples.xtext.serializer.DynamicRuleMatch;
import org.eclipse.ocl.examples.xtext.serializer.EClassValue;
import org.eclipse.ocl.examples.xtext.serializer.EnumerationValue;
import org.eclipse.ocl.examples.xtext.serializer.GrammarCardinality;
import org.eclipse.ocl.examples.xtext.serializer.GrammarRuleValue;
import org.eclipse.ocl.examples.xtext.serializer.GrammarRuleVector;
import org.eclipse.ocl.examples.xtext.serializer.Nameable;
import org.eclipse.ocl.examples.xtext.serializer.ParserRuleValue;
import org.eclipse.ocl.examples.xtext.serializer.SerializationMetaData;
import org.eclipse.ocl.examples.xtext.serializer.SerializationRule;
import org.eclipse.ocl.examples.xtext.serializer.SerializationUtils;
import org.eclipse.ocl.examples.xtext.serializer.UserModelAnalysis;
import org.eclipse.ocl.examples.xtext.serializer.UserSlotAnalysis;

public class UserElementAnalysis
implements Nameable {
    private static int count = 0;
    protected final @NonNull UserModelAnalysis modelAnalysis;
    protected final @NonNull SerializationMetaData serializationMetaData;
    protected final @Nullable UserElementAnalysis containingElementAnalysis;
    protected final @NonNull EObject eObject;
    protected final @NonNull EClass eClass;
    protected final @NonNull EClassValue eClassValue;
    protected final @NonNull String name;
    protected final @NonNull SerializationRule @NonNull [] serializationRules;
    protected final @NonNull GrammarRuleVector grammarRuleVector;
    private final @Nullable DynamicRuleMatch @NonNull [] dynamicRuleMatches;
    private final @NonNull Map<@NonNull EStructuralFeature, @NonNull UserSlotAnalysis> eStructuralFeature2slotAnalysis;

    public UserElementAnalysis(@NonNull UserModelAnalysis modelAnalysis, @Nullable UserElementAnalysis containingElementAnalysis, @NonNull EObject eObject) {
        assert (eObject.eContainer() == (containingElementAnalysis == null ? null : containingElementAnalysis.getEObject()));
        this.modelAnalysis = modelAnalysis;
        this.serializationMetaData = modelAnalysis.getSerializationMetaData();
        this.containingElementAnalysis = containingElementAnalysis;
        this.eObject = eObject;
        this.eClass = SerializationUtils.eClass(eObject);
        this.eClassValue = this.serializationMetaData.getEClassValue(this.eClass);
        this.name = String.valueOf(this.eClass.getName()) + "@" + ++count;
        this.serializationRules = this.analyzeSerializationRules();
        this.grammarRuleVector = this.analyzeGrammarRuleVector();
        this.dynamicRuleMatches = new DynamicRuleMatch[this.serializationRules.length];
        int i = 0;
        while (i < this.serializationRules.length) {
            this.dynamicRuleMatches[i] = null;
            ++i;
        }
        this.eStructuralFeature2slotAnalysis = this.analyzeSlots();
        modelAnalysis.debugAddUserElementAnalysis(this);
    }

    public boolean allRulesNeedDefault(@NonNull EAttribute eAttribute) {
        SerializationRule[] serializationRuleArray = this.serializationRules;
        int n = this.serializationRules.length;
        int n2 = 0;
        while (n2 < n) {
            @NonNull SerializationRule serializationRule = serializationRuleArray[n2];
            if (!serializationRule.needsDefault(eAttribute)) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    protected @NonNull UserSlotAnalysis analyzeEAttribute(@NonNull EAttribute eAttribute) {
        UserSlotAnalysis slotAnalysis;
        Object object = this.eObject.eGet((EStructuralFeature)eAttribute);
        if (eAttribute.isMany()) {
            Iterable<@NonNull EnumerationValue> enumerationValues = this.getEnumerationValues(eAttribute);
            List elements = (List)object;
            int size = elements.size();
            slotAnalysis = size > 0 && enumerationValues != null ? new UserSlotAnalysis.EnumeratedSlotAnalysis(enumerationValues, elements) : UserSlotAnalysis.CountedSlotAnalysis.valueOf(size);
        } else {
            boolean allRulesNeedDefault;
            Iterable<EnumerationValue> enumerationValues;
            slotAnalysis = object instanceof Boolean ? UserSlotAnalysis.CountedSlotAnalysis.valueOf(object == Boolean.TRUE ? 1 : 0) : (this.eObject.eIsSet((EStructuralFeature)eAttribute) ? ((enumerationValues = this.getEnumerationValues(eAttribute)) != null ? new UserSlotAnalysis.EnumeratedSlotAnalysis(enumerationValues, object) : UserSlotAnalysis.CountedSlotAnalysis.valueOf(1)) : (eAttribute.isUnsettable() ? UserSlotAnalysis.CountedSlotAnalysis.valueOf(0) : UserSlotAnalysis.CountedSlotAnalysis.valueOf((allRulesNeedDefault = this.allRulesNeedDefault(eAttribute)) ? 1 : 0)));
        }
        return slotAnalysis;
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    protected @Nullable UserSlotAnalysis analyzeEReference(@NonNull EReference eReference) {
        UserSlotAnalysis.CountedSlotAnalysis slotAnalysis;
        if (eReference.isContainer()) {
            return null;
        }
        Object object = this.eObject.eGet((EStructuralFeature)eReference);
        if (eReference.isMany()) {
            @NonNull List elements = (List)object;
            int size = elements.size();
            slotAnalysis = UserSlotAnalysis.CountedSlotAnalysis.valueOf(size);
        } else {
            slotAnalysis = object == null ? UserSlotAnalysis.CountedSlotAnalysis.valueOf(0) : UserSlotAnalysis.CountedSlotAnalysis.valueOf(1);
        }
        return slotAnalysis;
    }

    private @NonNull GrammarRuleVector analyzeGrammarRuleVector() {
        GrammarRuleVector grammarRuleVector = new GrammarRuleVector();
        SerializationRule[] serializationRuleArray = this.serializationRules;
        int n = this.serializationRules.length;
        int n2 = 0;
        while (n2 < n) {
            @NonNull SerializationRule serializationRule = serializationRuleArray[n2];
            grammarRuleVector.set(serializationRule.getGrammarRuleValueIndex());
            ++n2;
        }
        return grammarRuleVector;
    }

    private @NonNull SerializationRule @NonNull [] analyzeSerializationRules() {
        GrammarRuleVector targetRuleValueIndexes = null;
        UserElementAnalysis containingElementAnalysis2 = this.containingElementAnalysis;
        if (containingElementAnalysis2 != null) {
            EReference eContainmentFeature = this.eObject.eContainmentFeature();
            assert (eContainmentFeature != null);
            EClassValue parentEClassValue = this.serializationMetaData.getEClassValue(containingElementAnalysis2.getEClass());
            GrammarRuleVector targetRuleValues = parentEClassValue.getAssignedTargetRuleValues(eContainmentFeature);
            if (targetRuleValues != null) {
                targetRuleValueIndexes = new GrammarRuleVector();
                for (int targetRuleValueIndex : targetRuleValues) {
                    GrammarRuleValue targetRuleValue = this.serializationMetaData.getGrammarRuleValue(targetRuleValueIndex);
                    if (!(targetRuleValue instanceof ParserRuleValue)) continue;
                    targetRuleValueIndexes.set(targetRuleValueIndex);
                    GrammarRuleVector subParserRuleValueIndexes = ((ParserRuleValue)targetRuleValue).getSubParserRuleValueIndexes();
                    if (subParserRuleValueIndexes == null) continue;
                    targetRuleValueIndexes.setAll(subParserRuleValueIndexes);
                }
            }
        }
        EClassValue parentEClassValue = this.serializationMetaData.getEClassValue(this.eClass);
        return parentEClassValue.createDynamicSerializationRules(targetRuleValueIndexes);
    }

    protected @NonNull Map<@NonNull EStructuralFeature, @NonNull UserSlotAnalysis> analyzeSlots() {
        HashMap<@NonNull EStructuralFeature, @NonNull UserSlotAnalysis> eStructuralFeature2slotAnalysis = new HashMap<EStructuralFeature, UserSlotAnalysis>();
        for (EStructuralFeature eFeature : this.eClass.getEAllStructuralFeatures()) {
            assert (eFeature != null);
            if (eFeature.isDerived() || eFeature.isTransient() || eFeature.isVolatile()) continue;
            UserSlotAnalysis slotAnalysis = null;
            slotAnalysis = eFeature instanceof EReference ? this.analyzeEReference((EReference)eFeature) : this.analyzeEAttribute((EAttribute)eFeature);
            if (slotAnalysis == null) continue;
            eStructuralFeature2slotAnalysis.put(eFeature, slotAnalysis);
        }
        return eStructuralFeature2slotAnalysis;
    }

    public @Nullable DynamicRuleMatch basicCreateDynamicRuleMatch(int targetParserRuleValueIndex) {
        ParserRuleValue targetParserRuleValue = (ParserRuleValue)this.serializationMetaData.getGrammarRuleValue(targetParserRuleValueIndex);
        return this.basicCreateDynamicRuleMatch(targetParserRuleValue);
    }

    public @Nullable DynamicRuleMatch basicCreateDynamicRuleMatch(@Nullable ParserRuleValue targetParserRuleValue) {
        int serializationRulesIndex = 0;
        while (serializationRulesIndex < this.serializationRules.length) {
            SerializationRule serializationRule = this.serializationRules[serializationRulesIndex];
            DynamicRuleMatch dynamicRuleMatch = this.basicCreateDynamicRuleMatch(serializationRule, serializationRulesIndex);
            if ((targetParserRuleValue == null || targetParserRuleValue.subParserRuleValueClosureContains(serializationRule.getGrammarRuleValueIndex())) && dynamicRuleMatch != null) {
                return dynamicRuleMatch;
            }
            ++serializationRulesIndex;
        }
        return null;
    }

    public @Nullable DynamicRuleMatch basicCreateDynamicRuleMatch(@NonNull SerializationRule serializationRule) {
        int serializationRulesIndex = 0;
        while (serializationRulesIndex < this.serializationRules.length) {
            if (this.serializationRules[serializationRulesIndex] == serializationRule) {
                return this.basicCreateDynamicRuleMatch(serializationRule, serializationRulesIndex);
            }
            ++serializationRulesIndex;
        }
        return null;
    }

    private @Nullable DynamicRuleMatch basicCreateDynamicRuleMatch(@NonNull SerializationRule serializationRule, int serializationRulesIndex) {
        assert (this.serializationRules[serializationRulesIndex] == serializationRule);
        DynamicRuleMatch dynamicRuleMatch = this.dynamicRuleMatches[serializationRulesIndex];
        if (dynamicRuleMatch == null) {
            this.dynamicRuleMatches[serializationRulesIndex] = dynamicRuleMatch = new DynamicRuleMatch(this, serializationRule);
            if (!dynamicRuleMatch.analyze()) {
                assert (dynamicRuleMatch.matchFailed());
                return null;
            }
        } else if (dynamicRuleMatch.matchFailed()) {
            return null;
        }
        return dynamicRuleMatch;
    }

    public @Nullable UserSlotAnalysis basicGetSlotAnalysis(@NonNull EStructuralFeature eStructuralFeature) {
        return this.eStructuralFeature2slotAnalysis.get(eStructuralFeature);
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    public boolean diagnose(@NonNull DiagnosticStringBuilder s) {
        Object[] objectArray;
        boolean hasFailure = false;
        DynamicRuleMatch[] dynamicRuleMatchArray = this.dynamicRuleMatches;
        int n = this.dynamicRuleMatches.length;
        int n2 = 0;
        while (n2 < n) {
            @Nullable DynamicRuleMatch dynamicRuleMatch = dynamicRuleMatchArray[n2];
            if (dynamicRuleMatch != null) {
                if (dynamicRuleMatch.matchFailed()) {
                    hasFailure = true;
                } else {
                    return false;
                }
            }
            ++n2;
        }
        if (!hasFailure) {
            return false;
        }
        this.diagnoseEObject(s, this.eObject);
        char c = 'A';
        SerializationRule[] serializationRuleArray = this.serializationRules;
        int n3 = this.serializationRules.length;
        n = 0;
        while (n < n3) {
            SerializationRule serializationRule = serializationRuleArray[n];
            s.append("\n  [");
            char c2 = c;
            c = (char)(c2 + 1);
            s.append(c2);
            s.append("] ");
            serializationRule.toRuleString(s);
            ++n;
        }
        s.append("\n");
        @NonNull ArrayList sortedFeatures = Lists.newArrayList(this.getEStructuralFeatures());
        if (!sortedFeatures.isEmpty()) {
            Collections.sort(sortedFeatures, SerializationUtils.ENAMED_ELEMENT_COMPARATOR);
            c = 'A';
            s.appendWithFormat("%-30.30s%9s", "feature", "actual");
            objectArray = this.serializationRules;
            int n4 = this.serializationRules.length;
            n3 = 0;
            while (n3 < n4) {
                Object serializationRule = objectArray[n3];
                s.append(" [");
                char c3 = c;
                c = (char)(c3 + '\u0001');
                s.append(c3);
                s.append("]");
                ++n3;
            }
            for (EStructuralFeature eStructuralFeature : sortedFeatures) {
                GrammarCardinality grammarCardinality;
                SerializationRule serializationRule;
                int n5;
                int n6;
                SerializationRule[] serializationRuleArray2;
                int size2;
                s.append("\n");
                int size = this.getSize(eStructuralFeature);
                s.appendWithFormat("%-30.30s%8d", eStructuralFeature.getName(), size);
                Object object = this.serializationRules;
                int n7 = this.serializationRules.length;
                int n8 = 0;
                while (n8 < n7) {
                    SerializationRule serializationRule2 = object[n8];
                    GrammarCardinality grammarCardinality2 = serializationRule2.basicGetGrammarCardinality(eStructuralFeature);
                    s.appendWithFormat("%4s", grammarCardinality2 != null ? grammarCardinality2.toString() : "0");
                    ++n8;
                }
                if (eStructuralFeature instanceof EAttribute) {
                    EAttribute eAttribute = (EAttribute)eStructuralFeature;
                    Iterable<@NonNull EnumerationValue> enumerationValues = this.getEnumerationValues(eAttribute);
                    if (enumerationValues == null) continue;
                    @NonNull ArrayList sortedEnumerationValues = Lists.newArrayList(enumerationValues);
                    Collections.sort(sortedEnumerationValues, SerializationUtils.NAMEABLE_COMPARATOR);
                    for (EnumerationValue enumerationValue : sortedEnumerationValues) {
                        size2 = this.getSize(eAttribute, enumerationValue);
                        s.appendWithFormat("\n %-29.29s%8d", "'" + enumerationValue.getName() + "'", size2);
                        serializationRuleArray2 = this.serializationRules;
                        n6 = this.serializationRules.length;
                        n5 = 0;
                        while (n5 < n6) {
                            serializationRule = serializationRuleArray2[n5];
                            grammarCardinality = serializationRule.basicGetGrammarCardinality(eAttribute, enumerationValue);
                            s.appendWithFormat("%4s", grammarCardinality != null ? grammarCardinality.toString() : "0");
                            ++n5;
                        }
                    }
                    continue;
                }
                EReference eReference = (EReference)eStructuralFeature;
                GrammarRuleVector assignedRuleValueIndexes = this.getAssignedRuleValueIndexes(eReference);
                if (assignedRuleValueIndexes == null) continue;
                object = assignedRuleValueIndexes.iterator();
                while (object.hasNext()) {
                    int ruleValueIndex = (Integer)object.next();
                    ParserRuleValue ruleValue = (ParserRuleValue)this.serializationMetaData.getGrammarRuleValue(ruleValueIndex);
                    size2 = this.getSize(eReference, assignedRuleValueIndexes);
                    s.appendWithFormat("\n %-29.29s%8d", "'" + ruleValue.getName() + "'", size2);
                    serializationRuleArray2 = this.serializationRules;
                    n6 = this.serializationRules.length;
                    n5 = 0;
                    while (n5 < n6) {
                        serializationRule = serializationRuleArray2[n5];
                        grammarCardinality = serializationRule.basicGetGrammarCardinality(eReference, ruleValue);
                        s.appendWithFormat("%4s", grammarCardinality != null ? grammarCardinality.toString() : "0");
                        ++n5;
                    }
                }
            }
        } else {
            s.append("no features");
        }
        c = 'A';
        objectArray = this.dynamicRuleMatches;
        int n9 = this.dynamicRuleMatches.length;
        int n10 = 0;
        while (n10 < n9) {
            DynamicRuleMatch dynamicRuleMatch = objectArray[n10];
            s.append("\n [");
            char c4 = c;
            c = (char)(c4 + '\u0001');
            s.append(c4);
            s.append("] ");
            s.append(dynamicRuleMatch != null ? dynamicRuleMatch.getReasonString() : "Not analyzed.");
            ++n10;
        }
        s.append("\n");
        return true;
    }

    public void diagnoseEObject(@NonNull DiagnosticStringBuilder s, @NonNull EObject eObject) {
        EObject eContainer = eObject.eContainer();
        if (eContainer != null) {
            this.diagnoseEObject(s, eContainer);
            s.appendObject("::");
            EReference eContainmentFeature = eObject.eContainmentFeature();
            if (eContainmentFeature != null) {
                s.appendObject(eContainmentFeature.getName());
                if (eContainmentFeature.isMany()) {
                    s.append("[");
                    s.appendObject(((EList)eContainer.eGet((EStructuralFeature)eContainmentFeature)).indexOf((Object)eObject));
                    s.append("]");
                }
                s.append("\n   / ");
            }
        }
        EClass eClass = eObject.eClass();
        s.appendObject(eClass.getName());
        String name = null;
        String id = null;
        String string = null;
        for (EStructuralFeature eStructuralFeature : eClass.getEAllStructuralFeatures()) {
            EAttribute eAttribute;
            if (!(eStructuralFeature instanceof EAttribute) || (eAttribute = (EAttribute)eStructuralFeature).getEAttributeType().getInstanceClass() != String.class) continue;
            String featureName = eAttribute.getName();
            if ("name".equals(featureName)) {
                name = (String)eObject.eGet((EStructuralFeature)eAttribute);
                break;
            }
            if ("id".equals(featureName)) {
                id = (String)eObject.eGet((EStructuralFeature)eAttribute);
                continue;
            }
            string = (String)eObject.eGet((EStructuralFeature)eAttribute);
        }
        if (name == null) {
            name = id;
        }
        if (name == null) {
            name = string;
        }
        if (name != null) {
            s.append("'");
            s.append(name);
            s.append("'");
        }
    }

    public @Nullable GrammarRuleVector getAssignedRuleValueIndexes(@NonNull EReference eReference) {
        GrammarRuleVector allAssignedRuleValueIndexes = null;
        SerializationRule[] serializationRuleArray = this.serializationRules;
        int n = this.serializationRules.length;
        int n2 = 0;
        while (n2 < n) {
            @NonNull SerializationRule serializationRule = serializationRuleArray[n2];
            GrammarRuleVector assignedRuleValueIndexes = serializationRule.basicGetTargetGrammarRuleVector(eReference);
            if (assignedRuleValueIndexes != null) {
                if (allAssignedRuleValueIndexes == null) {
                    allAssignedRuleValueIndexes = new GrammarRuleVector();
                }
                allAssignedRuleValueIndexes.setAll(assignedRuleValueIndexes);
            }
            ++n2;
        }
        return allAssignedRuleValueIndexes;
    }

    public @Nullable UserElementAnalysis getContainingElementAnalysis() {
        return this.containingElementAnalysis;
    }

    public @NonNull EClass getEClass() {
        return this.eClass;
    }

    public @NonNull EObject getEObject() {
        return this.eObject;
    }

    public @NonNull Iterable<@NonNull EStructuralFeature> getEStructuralFeatures() {
        @NonNull Set<@NonNull EStructuralFeature> castKeySet = this.eStructuralFeature2slotAnalysis.keySet();
        return castKeySet;
    }

    public @Nullable Iterable<@NonNull EnumerationValue> getEnumerationValues(@NonNull EAttribute eAttribute) {
        HashSet<@NonNull EnumerationValue> allEnumerationValues = null;
        SerializationRule[] serializationRuleArray = this.serializationRules;
        int n = this.serializationRules.length;
        int n2 = 0;
        while (n2 < n) {
            @NonNull SerializationRule serializationRule = serializationRuleArray[n2];
            @NonNull EnumerationValue[] enumerationValues = serializationRule.basicGetEnumerationValues(eAttribute);
            if (enumerationValues != null && enumerationValues.length > 0) {
                if (allEnumerationValues == null) {
                    allEnumerationValues = new HashSet<EnumerationValue>();
                }
                EnumerationValue[] enumerationValueArray = enumerationValues;
                int n3 = enumerationValues.length;
                int n4 = 0;
                while (n4 < n3) {
                    EnumerationValue enumerationValue = enumerationValueArray[n4];
                    allEnumerationValues.add(enumerationValue);
                    ++n4;
                }
            }
            ++n2;
        }
        return allEnumerationValues;
    }

    public @NonNull GrammarRuleVector getGrammarRuleVector() {
        return this.grammarRuleVector;
    }

    public @Nullable Iterable<@NonNull GrammarRuleVector> getGrammarRuleVectors(@NonNull EReference eReference) {
        HashSet<@NonNull GrammarRuleVector> allGrammarRuleVectors = null;
        SerializationRule[] serializationRuleArray = this.serializationRules;
        int n = this.serializationRules.length;
        int n2 = 0;
        while (n2 < n) {
            @NonNull SerializationRule serializationRule = serializationRuleArray[n2];
            GrammarRuleVector grammarRuleVector = serializationRule.basicGetTargetGrammarRuleVector(eReference);
            if (grammarRuleVector != null) {
                if (allGrammarRuleVectors == null) {
                    allGrammarRuleVectors = new HashSet<GrammarRuleVector>();
                }
                allGrammarRuleVectors.add(grammarRuleVector);
            }
            ++n2;
        }
        return allGrammarRuleVectors;
    }

    public @NonNull UserModelAnalysis getModelAnalysis() {
        return this.modelAnalysis;
    }

    @Override
    public @NonNull String getName() {
        return this.name;
    }

    public @NonNull SerializationRule @NonNull [] getSerializationRules() {
        return this.serializationRules;
    }

    public int getSize(@NonNull EStructuralFeature eStructuralFeature) {
        UserSlotAnalysis slotAnalysis = this.basicGetSlotAnalysis(eStructuralFeature);
        if (slotAnalysis == null) {
            return 0;
        }
        if (slotAnalysis.isCounted()) {
            return slotAnalysis.asCounted();
        }
        if (slotAnalysis.isEnumerated()) {
            return slotAnalysis.asCounted();
        }
        throw new UnsupportedOperationException();
    }

    public int getSize(@NonNull EAttribute eAttribute, @NonNull EnumerationValue enumerationValue) {
        UserSlotAnalysis slotAnalysis = this.basicGetSlotAnalysis((EStructuralFeature)eAttribute);
        if (slotAnalysis == null) {
            return 0;
        }
        if (slotAnalysis.isCounted()) {
            return slotAnalysis.asCounted();
        }
        if (slotAnalysis.isEnumerated()) {
            return slotAnalysis.asEnumerated(enumerationValue);
        }
        throw new UnsupportedOperationException();
    }

    public int getSize(@NonNull EReference eReference, @NonNull GrammarRuleVector grammarRuleVector) {
        UserSlotAnalysis slotAnalysis = this.basicGetSlotAnalysis((EStructuralFeature)eReference);
        if (slotAnalysis == null) {
            return 0;
        }
        if (slotAnalysis.isCounted()) {
            return slotAnalysis.asCounted();
        }
        if (slotAnalysis.isDiscriminated()) {
            return slotAnalysis.asDiscriminated(grammarRuleVector);
        }
        throw new UnsupportedOperationException();
    }

    public @NonNull UserSlotAnalysis getSlotAnalysis(@NonNull EStructuralFeature eStructuralFeature) {
        return SerializationUtils.nonNullState(this.eStructuralFeature2slotAnalysis.get(eStructuralFeature));
    }

    public @NonNull String toString() {
        DiagnosticStringBuilder.SerializationMetaDataDiagnosticStringBuilder s = new DiagnosticStringBuilder.SerializationMetaDataDiagnosticStringBuilder(this.serializationMetaData);
        this.toString(s, 0);
        return s.toString();
    }

    public void toString(@NonNull DiagnosticStringBuilder s, int depth) {
        s.append(this.getName());
        s.append(" - ");
        EClass eClass = this.eClassValue.getEClass();
        s.append(SerializationUtils.getName((ENamedElement)SerializationUtils.getEPackage((EClassifier)eClass)));
        s.append("::");
        s.append(SerializationUtils.getName((ENamedElement)eClass));
        Object object = this.serializationRules;
        int n = this.serializationRules.length;
        int n2 = 0;
        while (n2 < n) {
            SerializationRule serializationRule = object[n2];
            s.appendIndentation(depth + 1);
            serializationRule.toMatchTermString(s, depth + 2);
            ++n2;
        }
        s.append(": ");
        if (SerializationUtils.maybeNull(this.eStructuralFeature2slotAnalysis) != null) {
            ArrayList<@NonNull EStructuralFeature> keys = new ArrayList<EStructuralFeature>(this.eStructuralFeature2slotAnalysis.keySet());
            Collections.sort(keys, SerializationUtils.ENAMED_ELEMENT_COMPARATOR);
            boolean isFirst = true;
            for (EStructuralFeature key : keys) {
                if (!isFirst) {
                    s.append(", ");
                }
                s.appendObject(key.getName());
                s.append("=");
                s.appendObject(this.eStructuralFeature2slotAnalysis.get(key));
                isFirst = false;
            }
        }
        object = this.dynamicRuleMatches;
        n = this.dynamicRuleMatches.length;
        n2 = 0;
        while (n2 < n) {
            Object dynamicRuleMatch = object[n2];
            if (dynamicRuleMatch != null && ((DynamicRuleMatch)dynamicRuleMatch).matchFailed()) {
                s.append("\n\t");
                s.append(((DynamicRuleMatch)dynamicRuleMatch).getSerializationRule().toRuleString());
                String reasonString = ((DynamicRuleMatch)dynamicRuleMatch).basicGetReasonString();
                if (reasonString != null) {
                    s.append("\n\t\t");
                    s.append(reasonString);
                }
            }
            ++n2;
        }
    }
}

