/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.core;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.StringJoiner;
import java.util.StringTokenizer;
import java.util.TreeSet;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.internal.compiler.env.IModule;
import org.eclipse.jdt.internal.core.builder.ClasspathJrt;
import org.eclipse.jdt.internal.core.builder.ClasspathLocation;
import org.eclipse.jdt.launching.IVMInstall;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.jdt.launching.environments.IExecutionEnvironment;
import org.eclipse.osgi.service.resolver.BundleDescription;
import org.eclipse.osgi.service.resolver.State;
import org.eclipse.pde.core.plugin.IPluginLibrary;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.core.plugin.PluginRegistry;
import org.eclipse.pde.core.plugin.TargetPlatform;
import org.eclipse.pde.core.target.ITargetDefinition;
import org.eclipse.pde.core.target.ITargetHandle;
import org.eclipse.pde.core.target.ITargetLocation;
import org.eclipse.pde.core.target.ITargetPlatformService;
import org.eclipse.pde.internal.core.ClasspathUtilCore;
import org.eclipse.pde.internal.core.MinimalState;
import org.eclipse.pde.internal.core.PDECore;
import org.eclipse.pde.internal.core.PDECoreMessages;
import org.eclipse.pde.internal.core.PDEExtensionRegistry;
import org.eclipse.pde.internal.core.PDEPreferencesManager;
import org.eclipse.pde.internal.core.PDEState;
import org.eclipse.pde.internal.core.ifeature.IFeatureModel;
import org.eclipse.pde.internal.core.target.IUBundleContainer;
import org.eclipse.pde.internal.core.target.TargetDefinition;
import org.eclipse.pde.internal.core.util.CoreUtility;
import org.eclipse.pde.internal.core.util.ManifestUtils;
import org.eclipse.pde.internal.core.util.VersionUtil;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.Version;

public class TargetPlatformHelper {
    public static final String REFERENCE_PREFIX = "reference:";
    public static final String PLATFORM_PREFIX = "platform:";
    public static final String FILE_URL_PREFIX = "file:";
    public static final String JAR_EXTENSION = ".jar";
    private static final Pattern PATTERN_BUNDLE_PATH_POSTFIX = Pattern.compile("(_\\d+(?<!x86_64|ia64_32)(\\.\\d+(\\.\\d+(\\.[a-zA-Z0-9_-]+)?)?)?(\\.\\w+)?$)|(\\.(?:jar|war|zip)$)", 2);
    private static Map<String, String> fgCachedLocations;
    private static Map<ITargetHandle, List<TargetDefinition>> fgCachedTargetDefinitionMap;

    static {
        fgCachedTargetDefinitionMap = new HashMap<ITargetHandle, List<TargetDefinition>>();
    }

    private TargetPlatformHelper() {
    }

    public static Properties getConfigIniProperties() {
        File iniFile = new File(TargetPlatform.getLocation(), "configuration/config.ini");
        if (!iniFile.exists()) {
            return null;
        }
        Properties pini = new Properties();
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (FileInputStream fis = new FileInputStream(iniFile);){
                pini.load(fis);
                return pini;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            PDECore.logException(e);
            return null;
        }
    }

    public static String getBundleList() {
        Properties properties = TargetPlatformHelper.getConfigIniProperties();
        String osgiBundles = properties == null ? null : properties.getProperty("osgi.bundles");
        osgiBundles = osgiBundles == null ? TargetPlatformHelper.getDefaultBundleList() : TargetPlatformHelper.stripPathInformation(osgiBundles);
        return osgiBundles;
    }

    public static String getDefaultBundleList() {
        StringBuilder buffer = new StringBuilder();
        double targetVersion = TargetPlatformHelper.getTargetVersion();
        if (targetVersion >= 3.8) {
            buffer.append("org.apache.felix.scr@1:start,");
            buffer.append("org.eclipse.equinox.common@2:start,");
            buffer.append("org.eclipse.equinox.event@2:start,");
            buffer.append("org.eclipse.core.runtime@start");
        } else {
            buffer.append("org.eclipse.equinox.common@2:start,");
            buffer.append("org.eclipse.core.runtime@2:start,");
        }
        return buffer.toString();
    }

    public static String stripPathInformation(String osgiBundles) {
        StringBuilder result = new StringBuilder();
        StringTokenizer tokenizer = new StringTokenizer(osgiBundles, ",");
        while (tokenizer.hasMoreElements()) {
            String token = tokenizer.nextToken();
            int atIndex = (token = token.replaceAll("\\\\:|/:", ":")).indexOf(64);
            String bundle = atIndex > 0 ? token.substring(0, atIndex) : token;
            if ((bundle = bundle.trim()).startsWith(REFERENCE_PREFIX) && bundle.length() > REFERENCE_PREFIX.length()) {
                bundle = bundle.substring(REFERENCE_PREFIX.length());
            }
            if (bundle.startsWith(PLATFORM_PREFIX) && bundle.length() > PLATFORM_PREFIX.length()) {
                bundle = bundle.substring(PLATFORM_PREFIX.length());
            }
            if (bundle.startsWith(FILE_URL_PREFIX) && bundle.length() > FILE_URL_PREFIX.length()) {
                bundle = bundle.substring(FILE_URL_PREFIX.length());
            }
            Path path = new Path(bundle);
            String id = null;
            if (path.isAbsolute()) {
                id = TargetPlatformHelper.getSymbolicName(bundle);
            }
            if (id == null) {
                id = path.lastSegment();
            }
            if (id != null) {
                id = PATTERN_BUNDLE_PATH_POSTFIX.matcher(id).replaceFirst("");
            }
            if (result.length() > 0) {
                result.append(",");
            }
            result.append(id != null ? id : bundle);
            if (atIndex <= -1) continue;
            result.append(token.substring(atIndex).trim());
        }
        return result.toString();
    }

    private static synchronized String getSymbolicName(String path) {
        if (fgCachedLocations == null) {
            fgCachedLocations = new HashMap<String, String>();
        }
        if (fgCachedLocations.containsKey(path)) {
            return fgCachedLocations.get(path);
        }
        File file = new File(path);
        if (file.exists()) {
            try {
                Map<String, String> manifest = ManifestUtils.loadManifest(file);
                String name = manifest.get("Bundle-SymbolicName");
                if (name != null) {
                    fgCachedLocations.put(path, name);
                    return name;
                }
            }
            catch (CoreException coreException) {}
        }
        return null;
    }

    public static void checkPluginPropertiesConsistency(Map<String, List<IPluginModelBase>> map, File configDir) {
        File runtimeDir = new File(configDir, "org.eclipse.core.runtime");
        if (runtimeDir.exists() && runtimeDir.isDirectory()) {
            long timestamp = runtimeDir.lastModified();
            for (List<IPluginModelBase> models : map.values()) {
                if (!models.stream().anyMatch(m -> TargetPlatformHelper.hasChanged(m, timestamp))) continue;
                CoreUtility.deleteContent(runtimeDir);
                break;
            }
        }
    }

    private static boolean hasChanged(IPluginModelBase model, long timestamp) {
        File[] files;
        if (model.getUnderlyingResource() != null && (files = new File(model.getInstallLocation()).listFiles()) != null) {
            File[] fileArray = files;
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                String name;
                File file = fileArray[n2];
                if (!file.isDirectory() && (name = file.getName()).startsWith("OSGI-INF/l10n/bundle") && name.endsWith(".properties") && file.lastModified() > timestamp) {
                    return true;
                }
                ++n2;
            }
        }
        return false;
    }

    public static ITargetDefinition getUnresolvedRepositoryBasedWorkspaceTarget() throws CoreException {
        ITargetPlatformService service = PDECore.getDefault().acquireService(ITargetPlatformService.class);
        if (service == null) {
            throw new CoreException(Status.error((String)PDECoreMessages.TargetPlatformHelper_CouldNotAcquireTargetService));
        }
        ITargetDefinition target = service.getWorkspaceTargetDefinition();
        if (target != null && !target.isResolved() && TargetPlatformHelper.containsNotEmptyIULocation(target.getTargetLocations())) {
            return target;
        }
        return null;
    }

    private static boolean containsNotEmptyIULocation(ITargetLocation[] locations) {
        if (locations != null) {
            if (Arrays.stream(locations).filter(IUBundleContainer.class::isInstance).map(IUBundleContainer.class::cast).map(IUBundleContainer::getRepositories).anyMatch(uri -> uri != null && ((URI[])uri).length > 0)) {
                return true;
            }
        }
        return false;
    }

    public static Set<String> getApplicationNameSet() {
        IExtension[] extensions;
        TreeSet<String> result = new TreeSet<String>();
        IExtension[] iExtensionArray = extensions = PDECore.getDefault().getExtensionsRegistry().findExtensions("org.eclipse.core.runtime.applications", true);
        int n = extensions.length;
        int n2 = 0;
        while (n2 < n) {
            IExtension extension = iExtensionArray[n2];
            String id = extension.getUniqueIdentifier();
            IConfigurationElement[] elements = extension.getConfigurationElements();
            if (elements.length == 1) {
                boolean visible;
                String visiblity = elements[0].getAttribute("visible");
                boolean bl = visible = visiblity == null || Boolean.parseBoolean(visiblity);
                if (id != null && visible) {
                    result.add(id);
                }
            }
            ++n2;
        }
        result.add("org.eclipse.ui.ide.workbench");
        return result;
    }

    public static String[] getApplicationNames() {
        Set<String> result = TargetPlatformHelper.getApplicationNameSet();
        return result.toArray(new String[result.size()]);
    }

    public static Set<String> getProductNameSet() {
        PDEExtensionRegistry registry = PDECore.getDefault().getExtensionsRegistry();
        return Arrays.stream(registry.findExtensions("org.eclipse.core.runtime.products", true)).filter(extension -> {
            IConfigurationElement[] elements = extension.getConfigurationElements();
            return elements.length == 1 && "product".equals(elements[0].getName());
        }).map(IExtension::getUniqueIdentifier).filter(id -> id != null && !id.isBlank()).collect(Collectors.toCollection(TreeSet::new));
    }

    public static String[] getProductNames() {
        return (String[])TargetPlatformHelper.getProductNameSet().toArray(String[]::new);
    }

    public static Dictionary<String, String> getTargetEnvironment() {
        Hashtable<String, String> result = new Hashtable<String, String>();
        ((Dictionary)result).put("osgi.os", TargetPlatform.getOS());
        ((Dictionary)result).put("osgi.ws", TargetPlatform.getWS());
        ((Dictionary)result).put("osgi.nl", TargetPlatform.getNL());
        ((Dictionary)result).put("osgi.arch", TargetPlatform.getOSArch());
        ((Dictionary)result).put("osgi.resolveOptional", "true");
        ((Dictionary)result).put("osgi.resolverMode", "development");
        return result;
    }

    public static Dictionary<String, String> getTargetEnvironment(MinimalState state) {
        Dictionary<String, String> result = TargetPlatformHelper.getTargetEnvironment();
        result.put("osgi.system.bundle", state.getSystemBundle());
        return result;
    }

    public static Dictionary<String, String>[] getPlatformProperties(String[] profiles, MinimalState state) {
        if (profiles == null || profiles.length == 0) {
            return new Dictionary[]{TargetPlatformHelper.getTargetEnvironment(state)};
        }
        ArrayList<Dictionary<String, String>> result = new ArrayList<Dictionary<String, String>>(profiles.length);
        String[] stringArray = profiles;
        int n = profiles.length;
        int n2 = 0;
        while (n2 < n) {
            Properties profileProps;
            String profile = stringArray[n2];
            IExecutionEnvironment environment = JavaRuntime.getExecutionEnvironmentsManager().getEnvironment(profile);
            if (environment != null && (profileProps = environment.getProfileProperties()) != null) {
                Dictionary<String, String> props = TargetPlatformHelper.getTargetEnvironment(state);
                TargetPlatformHelper.addEnvironmentProperties(props, environment, profileProps);
                result.add(props);
            }
            ++n2;
        }
        if (!result.isEmpty()) {
            return (Dictionary[])result.toArray(Dictionary[]::new);
        }
        return new Dictionary[]{TargetPlatformHelper.getTargetEnvironment(state)};
    }

    public static void addEnvironmentProperties(Dictionary<String, String> properties, IExecutionEnvironment environment, Properties profileProps) {
        String frameworkExecutionenvironment;
        String ee;
        String systemPackages = profileProps.getProperty("org.osgi.framework.system.packages");
        if (systemPackages == null) {
            systemPackages = TargetPlatformHelper.querySystemPackages(environment);
        }
        if (systemPackages != null) {
            properties.put("org.osgi.framework.system.packages", systemPackages);
        }
        if ((ee = profileProps.getProperty(frameworkExecutionenvironment = "org.osgi.framework.executionenvironment")) != null) {
            properties.put(frameworkExecutionenvironment, ee);
        }
    }

    public static String querySystemPackages(IExecutionEnvironment environment) {
        IVMInstall vm = TargetPlatformHelper.bestVmInstallFor(environment);
        if (vm == null || !JavaRuntime.isModularJava((IVMInstall)vm)) {
            return null;
        }
        String release = environment.getProfileProperties().getProperty("org.eclipse.jdt.core.compiler.compliance");
        try {
            TreeSet<String> packages = new TreeSet<String>();
            String jrtPath = "lib/jrt-fs.jar";
            String path = new File(vm.getInstallLocation(), jrtPath).toString();
            ClasspathJrt jrt = ClasspathLocation.forJrtSystem((String)path, null, null, (String)release);
            for (String moduleName : jrt.getModuleNames(null)) {
                IModule module = jrt.getModule(moduleName);
                if (module == null) continue;
                IModule.IPackageExport[] iPackageExportArray = module.exports();
                int n = iPackageExportArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IModule.IPackageExport packageExport = iPackageExportArray[n2];
                    if (!packageExport.isQualified()) {
                        packages.add(new String(packageExport.name()));
                    }
                    ++n2;
                }
            }
            return String.join((CharSequence)",", packages);
        }
        catch (CoreException e) {
            PDECore.logException(e, "failed to read system packages for " + environment);
            return null;
        }
    }

    private static IVMInstall bestVmInstallFor(IExecutionEnvironment environment) {
        if (environment == null) {
            return null;
        }
        IVMInstall defaultVM = environment.getDefaultVM();
        if (defaultVM != null) {
            return defaultVM;
        }
        IVMInstall[] compatible = environment.getCompatibleVMs();
        if (compatible.length == 0) {
            return null;
        }
        IVMInstall[] iVMInstallArray = compatible;
        int n = compatible.length;
        int n2 = 0;
        while (n2 < n) {
            IVMInstall vm = iVMInstallArray[n2];
            if (environment.isStrictlyCompatible(vm)) {
                return vm;
            }
            ++n2;
        }
        return compatible[0];
    }

    public static String[] getKnownExecutionEnvironments() {
        String jreProfile = System.getProperty("pde.jreProfile");
        if (jreProfile != null && jreProfile.length() > 0) {
            if ("none".equals(jreProfile)) {
                return new String[0];
            }
            return new String[]{jreProfile};
        }
        IExecutionEnvironment[] environments = JavaRuntime.getExecutionEnvironmentsManager().getExecutionEnvironments();
        String[] ids = new String[environments.length];
        int i = 0;
        while (i < environments.length) {
            ids[i] = environments[i].getId();
            ++i;
        }
        return ids;
    }

    public static String getTargetVersionString() {
        IPluginModelBase model = PluginRegistry.findModel("org.eclipse.osgi");
        if (model == null) {
            return "3.8";
        }
        String version = model.getPluginBase().getVersion();
        if (VersionUtil.validateVersion(version).isOK()) {
            Version vid = new Version(version);
            int major = vid.getMajor();
            int minor = vid.getMinor();
            if (major == 3 && minor == 0) {
                return "3.0";
            }
            if (major == 3 && minor == 1) {
                return "3.1";
            }
            if (major == 3 && minor == 2) {
                return "3.2";
            }
            if (major == 3 && minor == 3) {
                return "3.3";
            }
            if (major == 3 && minor == 4) {
                return "3.4";
            }
            if (major == 3 && minor == 5) {
                return "3.5";
            }
            if (major == 3 && minor == 6) {
                return "3.6";
            }
            if (major == 3 && minor == 7) {
                return "3.7";
            }
            if (major == 3 && minor == 8) {
                return "3.8";
            }
        }
        return "3.8";
    }

    public static double getTargetVersion() {
        return Double.parseDouble(TargetPlatformHelper.getTargetVersionString());
    }

    public static String getSchemaVersionForTargetVersion(String targetVersion) {
        double target = targetVersion == null ? TargetPlatformHelper.getTargetVersion() : Double.parseDouble(targetVersion);
        String schemaVersion = "3.4";
        if (target < 3.2) {
            schemaVersion = "3.0";
        } else if (target < 3.4) {
            schemaVersion = "3.2";
        }
        return schemaVersion;
    }

    public static String getTargetVersionForSchemaVersion(String schemaVersion) {
        if (schemaVersion == null) {
            return TargetPlatformHelper.getTargetVersionString();
        }
        if (schemaVersion.equals("3.0")) {
            return "3.1";
        }
        if (schemaVersion.equals("3.2")) {
            return "3.3";
        }
        return TargetPlatformHelper.getTargetVersionString();
    }

    public static String getSchemaVersion() {
        return TargetPlatformHelper.getSchemaVersionForTargetVersion(null);
    }

    public static PDEState getPDEState() {
        return PDECore.getDefault().getModelManager().getState();
    }

    public static State getState() {
        return TargetPlatformHelper.getPDEState().getState();
    }

    public static ITargetDefinition getWorkspaceTargetResolved(IProgressMonitor monitor) throws CoreException {
        ITargetPlatformService service = PDECore.getDefault().acquireService(ITargetPlatformService.class);
        if (service == null) {
            throw new CoreException(Status.error((String)PDECoreMessages.TargetPlatformHelper_CouldNotAcquireTargetService));
        }
        ITargetDefinition target = service.getWorkspaceTargetDefinition();
        if (!target.isResolved()) {
            target.resolve(monitor);
            if (monitor != null && monitor.isCanceled()) {
                return null;
            }
            PDEPreferencesManager preferences = PDECore.getDefault().getPreferencesManager();
            String memento = target.getHandle().getMemento();
            if (memento != null && memento.equals(preferences.getString("workspace_target_handle"))) {
                preferences.setValue("workspace_target_handle", "");
                preferences.setValue("workspace_target_handle", memento);
            }
        }
        return target;
    }

    public static Map<Long, String> getPatchMap(PDEState state) {
        IPluginModelBase[] models;
        LinkedHashMap<Long, String> properties = new LinkedHashMap<Long, String>();
        IPluginModelBase[] iPluginModelBaseArray = models = PluginRegistry.getActiveModels();
        int n = models.length;
        int n2 = 0;
        while (n2 < n) {
            IPluginModelBase model = iPluginModelBaseArray[n2];
            BundleDescription desc = model.getBundleDescription();
            if (desc != null) {
                Long id = desc.getBundleId();
                if (ClasspathUtilCore.hasExtensibleAPI(model)) {
                    properties.put(id, "Eclipse-ExtensibleAPI: true");
                } else if (ClasspathUtilCore.isPatchFragment(model)) {
                    properties.put(id, "Eclipse-PatchFragment: true");
                }
            }
            ++n2;
        }
        return properties;
    }

    public static HashMap<Long, String[]> getBundleClasspaths(PDEState state) {
        BundleDescription[] bundles;
        LinkedHashMap<Long, String[]> properties = new LinkedHashMap<Long, String[]>();
        BundleDescription[] bundleDescriptionArray = bundles = state.getState().getBundles();
        int n = bundles.length;
        int n2 = 0;
        while (n2 < n) {
            BundleDescription bundle = bundleDescriptionArray[n2];
            properties.put(bundle.getBundleId(), TargetPlatformHelper.getValue(bundle, state));
            ++n2;
        }
        return properties;
    }

    private static String[] getValue(BundleDescription bundle, PDEState state) {
        IPluginModelBase model = PluginRegistry.findModel(bundle);
        String[] result = null;
        if (model != null) {
            IPluginLibrary[] libs = model.getPluginBase().getLibraries();
            result = new String[libs.length];
            int i = 0;
            while (i < libs.length) {
                result[i] = libs[i].getName();
                ++i;
            }
        } else {
            result = (String[])state.getLibraryNames(bundle.getBundleId()).clone();
        }
        if (result.length == 0) {
            return new String[]{"."};
        }
        return result;
    }

    public static String[] getFeaturePaths() {
        IFeatureModel[] models = PDECore.getDefault().getFeatureModelManager().getModels();
        ArrayList<String> list = new ArrayList<String>();
        IFeatureModel[] iFeatureModelArray = models;
        int n = models.length;
        int n2 = 0;
        while (n2 < n) {
            IFeatureModel model = iFeatureModelArray[n2];
            String location = model.getInstallLocation();
            if (location != null) {
                list.add(String.valueOf(location) + '/' + "feature.xml");
            }
            ++n2;
        }
        return list.toArray(new String[list.size()]);
    }

    public static boolean matchesCurrentEnvironment(IPluginModelBase model) {
        String filterSpec;
        BundleDescription bundle = model.getBundleDescription();
        String string = filterSpec = bundle != null ? bundle.getPlatformFilter() : null;
        if (filterSpec == null) {
            return true;
        }
        BundleContext context = PDECore.getDefault().getBundleContext();
        Dictionary<String, String> environment = TargetPlatformHelper.getTargetEnvironment();
        try {
            return context.createFilter(filterSpec).match(environment);
        }
        catch (InvalidSyntaxException invalidSyntaxException) {
            return false;
        }
    }

    public static boolean usesNewApplicationModel() {
        return PluginRegistry.findModel("org.eclipse.equinox.app") != null;
    }

    public static String getIniVMArgs() {
        File installDirectory = new File(Platform.getInstallLocation().getURL().getFile());
        File eclipseIniFile = new File(installDirectory, "eclipse.ini");
        StringJoiner result = new StringJoiner(" ");
        if (eclipseIniFile.exists()) {
            try {
                Throwable throwable = null;
                Object var4_6 = null;
                try (Stream<String> lines = Files.lines(eclipseIniFile.toPath(), StandardCharsets.UTF_8);){
                    boolean vmargs = false;
                    for (String str : lines::iterator) {
                        if (vmargs) {
                            result.add(str);
                        }
                        if (vmargs || !str.equals("-vmargs")) continue;
                        vmargs = true;
                    }
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (IOException e) {
                PDECore.log(e);
            }
        }
        return result.toString();
    }

    public static Map<ITargetHandle, List<TargetDefinition>> getTargetDefinitionMap() {
        return fgCachedTargetDefinitionMap;
    }

    public static void addTargetDefinitionMap(TargetDefinition targetDefinition) {
        if (fgCachedTargetDefinitionMap.containsKey(targetDefinition.getHandle())) {
            List<TargetDefinition> targets = fgCachedTargetDefinitionMap.get(targetDefinition.getHandle());
            if (!targets.contains(targetDefinition)) {
                targets.add(0, targetDefinition);
            }
        } else {
            ArrayList<TargetDefinition> target = new ArrayList<TargetDefinition>();
            target.add(targetDefinition);
            fgCachedTargetDefinitionMap.put(targetDefinition.getHandle(), target);
        }
    }
}

