/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum BackgroundStyle implements Enumerator
{
    GRADIENT_LEFT_TO_RIGHT_LITERAL(0, "GradientLeftToRight", "GradientLeftToRight"),
    LIQUID_LITERAL(1, "Liquid", "Liquid"),
    GRADIENT_TOP_TO_BOTTOM_LITERAL(3, "GradientTopToBottom", "GradientTopToBottom");

    public static final int GRADIENT_LEFT_TO_RIGHT = 0;
    public static final int LIQUID = 1;
    public static final int GRADIENT_TOP_TO_BOTTOM = 3;
    private static final BackgroundStyle[] VALUES_ARRAY;
    public static final List<BackgroundStyle> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new BackgroundStyle[]{GRADIENT_LEFT_TO_RIGHT_LITERAL, LIQUID_LITERAL, GRADIENT_TOP_TO_BOTTOM_LITERAL};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static BackgroundStyle get(String literal) {
        BackgroundStyle[] backgroundStyleArray = VALUES_ARRAY;
        int n = VALUES_ARRAY.length;
        int n2 = 0;
        while (n2 < n) {
            BackgroundStyle result = backgroundStyleArray[n2];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++n2;
        }
        return null;
    }

    public static BackgroundStyle getByName(String name) {
        BackgroundStyle[] backgroundStyleArray = VALUES_ARRAY;
        int n = VALUES_ARRAY.length;
        int n2 = 0;
        while (n2 < n) {
            BackgroundStyle result = backgroundStyleArray[n2];
            if (result.getName().equals(name)) {
                return result;
            }
            ++n2;
        }
        return null;
    }

    public static BackgroundStyle get(int value) {
        switch (value) {
            case 0: {
                return GRADIENT_LEFT_TO_RIGHT_LITERAL;
            }
            case 1: {
                return LIQUID_LITERAL;
            }
            case 3: {
                return GRADIENT_TOP_TO_BOTTOM_LITERAL;
            }
        }
        return null;
    }

    private BackgroundStyle(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

