/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.formatting2.debug;

import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import java.util.List;
import org.eclipse.xtext.formatting2.debug.TextRegionListToString;
import org.eclipse.xtext.formatting2.debug.TextRegionsInTextToString;
import org.eclipse.xtext.formatting2.regionaccess.ITextRegionAccess;
import org.eclipse.xtext.formatting2.regionaccess.ITextReplacement;
import org.eclipse.xtext.formatting2.regionaccess.ITextSegment;
import org.eclipse.xtext.util.Strings;

public class TextRegionsToString {
    private TextRegionListToString list = new TextRegionListToString();
    private TextRegionsInTextToString text = new TextRegionsInTextToString();
    private boolean ignoreCarriageReturnInQuotes = false;

    public boolean isIgnoreCarriageReturnInQuotes() {
        return this.ignoreCarriageReturnInQuotes;
    }

    public TextRegionsToString setIgnoreCarriageReturnInQuotes(boolean ignoreCarriageReturnInQuotes) {
        this.ignoreCarriageReturnInQuotes = ignoreCarriageReturnInQuotes;
        return this;
    }

    public TextRegionsToString add(ITextReplacement region) {
        return this.add(region, region.getReplacementText());
    }

    public TextRegionsToString add(ITextSegment region, String description) {
        this.text.add(region, this.getReplacement(region, region.getText()));
        this.list.add(region, String.valueOf(this.quote(region.getText(), 20)) + ": " + description);
        return this;
    }

    public TextRegionsToString addAllReplacements(Iterable<? extends ITextReplacement> regions) {
        for (ITextReplacement iTextReplacement : regions) {
            this.addReplacement((ITextSegment)iTextReplacement, iTextReplacement.getReplacementText());
        }
        return this;
    }

    public TextRegionsToString addReplacement(ITextReplacement region, String description) {
        return this.addReplacement(region, region.getReplacementText(), description);
    }

    public TextRegionsToString addReplacement(ITextSegment region, String replacement) {
        this.text.add(region, this.getReplacement(region, replacement));
        this.list.add(region, String.valueOf(this.quote(region.getText(), 20)) + " -> " + this.quote(replacement, 20));
        return this;
    }

    public TextRegionsToString addReplacement(ITextSegment region, String replacement, String description) {
        this.text.add(region, this.getReplacement(region, replacement));
        this.list.add(region, String.valueOf(this.quote(region.getText(), 20)) + " -> " + this.quote(replacement, 20) + ": " + description);
        return this;
    }

    protected String getReplacement(ITextSegment region, String replacement) {
        String string = region.getText();
        if (Strings.equal((String)string, (String)replacement)) {
            return "<" + region.getOffset() + "|" + replacement + ">";
        }
        return "<" + region.getOffset() + ":" + region.getLength() + "|" + replacement + ">";
    }

    protected String quote(String string, int maxLength) {
        if (string == null) {
            return "null";
        }
        List<String> result = Lists.newArrayList();
        int max = Math.min(string.length(), maxLength + 1);
        int i = 0;
        while (i < max) {
            char c = string.charAt(i);
            switch (c) {
                case '\n': {
                    result.add("\\n");
                    break;
                }
                case '\r': {
                    if (this.ignoreCarriageReturnInQuotes) {
                        max = Math.min(max + 1, string.length());
                        break;
                    }
                    result.add("\\r");
                    break;
                }
                default: {
                    result.add(String.valueOf(c));
                }
            }
            ++i;
        }
        if (result.size() > maxLength) {
            result = result.subList(0, maxLength - 3);
            result.add("...");
        }
        return "\"" + Joiner.on((String)"").join((Iterable)result) + "\"";
    }

    public TextRegionsToString setTitle(String title) {
        this.text.setTitle(String.valueOf(title) + " (syntax: <offset|text>)");
        return this;
    }

    public TextRegionsToString setFrame(ITextSegment frame) {
        this.text.setFrame(frame);
        return this;
    }

    public TextRegionsToString setLeadingLines(int leadingLines) {
        this.text.setLeadingLines(leadingLines);
        return this;
    }

    public TextRegionsToString setTextRegionAccess(ITextRegionAccess textRegionAccess) {
        this.text.setTextRegionAccess(textRegionAccess);
        return this;
    }

    public TextRegionsToString setTrailingLines(int trailingLines) {
        this.text.setTrailingLines(trailingLines);
        return this;
    }

    public String toString() {
        return this.text + "\n" + this.list;
    }
}

