/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.internal.ui.actions;

import org.eclipse.cdt.debug.core.model.ICSignal;
import org.eclipse.cdt.debug.internal.ui.actions.ActionMessages;
import org.eclipse.cdt.debug.ui.CDebugUIPlugin;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.debug.core.DebugException;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.actions.ActionDelegate;

public class SignalActionDelegate
extends ActionDelegate
implements IObjectActionDelegate {
    private ICSignal fSignal = null;

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
    }

    public void run(IAction action) {
        if (this.getSignal() != null) {
            MultiStatus ms = new MultiStatus(CDebugUIPlugin.getUniqueIdentifier(), 5012, ActionMessages.getString("SignalActionDelegate.0"), null);
            BusyIndicator.showWhile((Display)Display.getCurrent(), () -> {
                try {
                    this.doAction(this.getSignal());
                }
                catch (DebugException e) {
                    ms.merge(e.getStatus());
                }
            });
            if (!ms.isOK()) {
                IWorkbenchWindow window = CDebugUIPlugin.getActiveWorkbenchWindow();
                if (window != null) {
                    CDebugUIPlugin.errorDialog(ActionMessages.getString("SignalActionDelegate.1"), (IStatus)ms);
                } else {
                    CDebugUIPlugin.log((IStatus)ms);
                }
            }
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
        Object element;
        if (selection instanceof IStructuredSelection && (element = ((IStructuredSelection)selection).getFirstElement()) instanceof ICSignal) {
            boolean enabled = this.enablesFor((ICSignal)element);
            action.setEnabled(enabled);
            if (enabled) {
                this.setSignal((ICSignal)element);
                return;
            }
        }
        action.setEnabled(false);
        this.setSignal(null);
    }

    protected void doAction(ICSignal signal) throws DebugException {
        signal.signal();
    }

    private boolean enablesFor(ICSignal signal) {
        return signal != null && signal.getDebugTarget().isSuspended();
    }

    private void setSignal(ICSignal signal) {
        this.fSignal = signal;
    }

    protected ICSignal getSignal() {
        return this.fSignal;
    }
}

