/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.managedbuilder.ui.properties;

import java.net.URL;
import org.eclipse.cdt.managedbuilder.core.IOptionCategory;
import org.eclipse.cdt.managedbuilder.core.ITool;
import org.eclipse.cdt.managedbuilder.internal.ui.Messages;
import org.eclipse.cdt.managedbuilder.ui.properties.ManagedBuilderUIImages;
import org.eclipse.cdt.managedbuilder.ui.properties.ToolListElement;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;

public class ToolListLabelProvider
extends LabelProvider {
    private final Image IMG_TOOL = ManagedBuilderUIImages.get(ManagedBuilderUIImages.IMG_BUILD_TOOL);
    private final Image IMG_CAT = ManagedBuilderUIImages.get(ManagedBuilderUIImages.IMG_BUILD_CAT);
    private ImageDescriptor descriptor = null;
    private ResourceManager manager = null;

    private Image getIconFromOptionCategory(IOptionCategory cat) {
        Image img = null;
        URL url = cat.getIconPath();
        if (url != null) {
            this.descriptor = ImageDescriptor.createFromURL((URL)url);
            this.manager = JFaceResources.getResources((Display)Display.getCurrent());
            Assert.isNotNull((Object)this.manager);
            img = this.manager.createImageWithDefault(this.descriptor);
            if (img == null) {
                System.err.println("Couldn't create image from URL \"" + String.valueOf(url) + "\", to display icon for Tool Options.");
            }
        }
        return img;
    }

    public Image getImage(Object element) {
        Image img;
        if (!(element instanceof ToolListElement)) {
            throw this.unknownElement(element);
        }
        Image defaultImage = this.IMG_CAT;
        ToolListElement toolListElement = (ToolListElement)element;
        IOptionCategory cat = toolListElement.getOptionCategory();
        if (cat == null) {
            defaultImage = this.IMG_TOOL;
            cat = (IOptionCategory)toolListElement.getTool();
        }
        if (cat != null && (img = this.getIconFromOptionCategory(cat)) != null) {
            return img;
        }
        return defaultImage;
    }

    public String getText(Object element) {
        if (!(element instanceof ToolListElement)) {
            throw this.unknownElement(element);
        }
        ToolListElement toolListElement = (ToolListElement)element;
        IOptionCategory cat = toolListElement.getOptionCategory();
        if (cat == null) {
            ITool tool = toolListElement.getTool();
            return tool.getUniqueRealName();
        }
        return cat.getName();
    }

    protected RuntimeException unknownElement(Object element) {
        return new RuntimeException(NLS.bind((String)Messages.BuildPropertyPage_error_Unknown_tree_element, (Object)element.getClass().getName()));
    }

    public void dispose() {
        if (this.descriptor != null && this.manager != null) {
            this.manager.destroyImage(this.descriptor);
        }
    }
}

