/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.importer.rose.parser;

import java.io.File;
import java.util.StringTokenizer;

public class Util {
    public static final String QUOTE = "\"";
    public static final int PATH_NOT_VALID = 0;
    public static final int DIRECTORY_NOT_FOUND = 1;
    public static final int PATH_OK = 2;
    public static final int NOT_A_DIRECTORY = 3;

    public static int isValidPath(String pathname) {
        File testDirectory;
        try {
            testDirectory = new File(pathname);
        }
        catch (NullPointerException e) {
            return 0;
        }
        boolean exists = false;
        try {
            exists = testDirectory.exists();
        }
        catch (SecurityException e) {
            return 0;
        }
        boolean isDirectory = false;
        try {
            isDirectory = testDirectory.isDirectory();
        }
        catch (SecurityException e) {
            return 0;
        }
        if (!isDirectory) {
            if (exists) {
                return 3;
            }
            return 1;
        }
        return 2;
    }

    public static boolean createDirectory(String dirName) {
        try {
            File newDir = new File(dirName);
            return newDir.mkdirs();
        }
        catch (NullPointerException e) {
            return false;
        }
        catch (SecurityException e) {
            return false;
        }
    }

    public static String trimQuotes(String str) {
        int f_ind = str.indexOf(QUOTE);
        int l_ind = str.lastIndexOf(QUOTE);
        if (f_ind == -1) {
            return str;
        }
        if (f_ind == l_ind) {
            return str.substring(f_ind + 1);
        }
        return str.substring(f_ind + 1, l_ind);
    }

    public static String getType(String str) {
        return Util.getWord(str, 1);
    }

    public static String getName(String str) {
        int ind_end = str.lastIndexOf(QUOTE);
        if (ind_end == -1) {
            return null;
        }
        String temp = str.substring(0, ind_end);
        int ind_start = temp.lastIndexOf(QUOTE);
        if (ind_start == -1) {
            return null;
        }
        String name = str.substring(ind_start + 1, ind_end);
        if (name.indexOf("$UNNAMED") != -1) {
            name = "";
        }
        return name;
    }

    public static String getWord(String str, int n) {
        StringTokenizer st = new StringTokenizer(str);
        int i = 0;
        while (st.hasMoreTokens()) {
            String tok = st.nextToken();
            if (++i != n) continue;
            return tok;
        }
        return null;
    }

    public static String updateFileName(String fileName, String dilimiter) {
        String name = "";
        while (true) {
            int ind;
            if ((ind = fileName.indexOf(dilimiter)) == -1) break;
            name = String.valueOf(name) + fileName.substring(0, ind) + File.separator;
            fileName = fileName.substring(ind + dilimiter.length());
        }
        name = String.valueOf(name) + fileName;
        return name;
    }
}

