/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.core.internal.launch;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.versioning.DefaultArtifactVersion;
import org.apache.maven.project.MavenProject;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.m2e.core.MavenPlugin;
import org.eclipse.m2e.core.internal.Messages;
import org.eclipse.m2e.core.internal.launch.ClasspathEntry;
import org.eclipse.m2e.core.internal.launch.ProjectClasspathEntry;
import org.eclipse.m2e.core.project.IMavenProjectFacade;
import org.eclipse.m2e.core.project.IMavenProjectRegistry;
import org.eclipse.osgi.util.NLS;

public abstract class AbstractMavenRuntime {
    private final String name;
    private List<ClasspathEntry> extensions;

    protected AbstractMavenRuntime(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name != null ? this.name : this.getLocation();
    }

    public List<ClasspathEntry> getExtensions() {
        return this.extensions;
    }

    public void setExtensions(List<ClasspathEntry> extensions) {
        this.extensions = extensions != null && !extensions.isEmpty() ? new ArrayList<ClasspathEntry>(extensions) : null;
    }

    public boolean isLegacy() {
        return this.name == null;
    }

    /*
     * WARNING - void declaration
     */
    protected void collectExtensions(IMavenLauncherConfiguration collector, IProgressMonitor monitor) throws CoreException {
        if (this.extensions != null) {
            IMavenProjectRegistry registry = MavenPlugin.getMavenProjectRegistry();
            for (ClasspathEntry entry : this.extensions) {
                void projectClasspathEntry;
                ClasspathEntry classpathEntry = entry;
                if (!(classpathEntry instanceof ProjectClasspathEntry)) continue;
                ProjectClasspathEntry cfr_ignored_0 = (ProjectClasspathEntry)classpathEntry;
                ProjectClasspathEntry cfr_ignored_1 = (ProjectClasspathEntry)classpathEntry;
                this.collectProject(collector, (ProjectClasspathEntry)projectClasspathEntry, registry, monitor);
            }
        }
    }

    private void collectProject(IMavenLauncherConfiguration collector, ProjectClasspathEntry entry, IMavenProjectRegistry registry, IProgressMonitor monitor) throws CoreException {
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(entry.getProject());
        IMavenProjectFacade facade = registry.create(project, monitor);
        if (facade == null) {
            throw new CoreException(Status.error((String)NLS.bind((String)Messages.AbstractMavenRuntime_unknownProject, (Object)entry.getProject())));
        }
        collector.addProjectEntry(facade);
        MavenProject mavenProject = facade.getMavenProject(monitor);
        for (Artifact dependency : mavenProject.getArtifacts()) {
            if (!"compile".equals(dependency.getScope()) && !"runtime".equals(dependency.getScope())) continue;
            collector.addArchiveEntry(dependency.getFile().getAbsolutePath());
        }
    }

    public boolean equals(Object o) {
        return o != null && this.getClass().equals(o.getClass()) && this.getName().equals(((AbstractMavenRuntime)o).getName());
    }

    public int hashCode() {
        return this.getName().hashCode();
    }

    protected boolean isSupportedVersion() {
        DefaultArtifactVersion version = new DefaultArtifactVersion(this.getVersion());
        return version.getMajorVersion() >= 3;
    }

    public String getSettings() {
        String settings = MavenPlugin.getMavenConfiguration().getGlobalSettingsFile();
        if (settings != null && !settings.isBlank()) {
            try {
                settings = new File(settings).getCanonicalPath();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return settings;
    }

    public abstract boolean isEditable();

    public abstract void createLauncherConfiguration(IMavenLauncherConfiguration var1, IProgressMonitor var2) throws CoreException;

    public abstract String getLocation();

    public abstract boolean isAvailable();

    public abstract String getVersion();

    public static interface IMavenLauncherConfiguration {
        public static final String LAUNCHER_REALM = "]launcher";

        public void setMainType(String var1, String var2);

        public void addRealm(String var1);

        public void addProjectEntry(IMavenProjectFacade var1);

        public void addArchiveEntry(String var1) throws CoreException;
    }
}

