/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mat.internal.collectionextract;

import java.util.Iterator;
import java.util.Map;
import org.eclipse.mat.SnapshotException;
import org.eclipse.mat.collect.ArrayInt;
import org.eclipse.mat.inspections.collectionextract.ExtractedMap;
import org.eclipse.mat.inspections.collectionextract.ICollectionExtractor;
import org.eclipse.mat.inspections.collectionextract.IMapExtractor;
import org.eclipse.mat.internal.collectionextract.WrapperMapExtractor;
import org.eclipse.mat.snapshot.model.IObject;

public class WrapperFieldMapExtractor
extends WrapperMapExtractor {
    String keyfield;
    String valuefield;

    public WrapperFieldMapExtractor(String field, String keyfield, String valuefield) {
        this(field, keyfield, valuefield, null);
    }

    public WrapperFieldMapExtractor(String field, String keyfield, String valuefield, ICollectionExtractor extractor) {
        super(field, extractor);
        this.keyfield = keyfield;
        this.valuefield = valuefield;
    }

    @Override
    public int[] extractEntryIds(IObject coll) throws SnapshotException {
        int[] r = super.extractEntryIds(coll);
        ArrayInt a = new ArrayInt(r.length);
        int i = 0;
        while (i < r.length) {
            IObject o = coll.getSnapshot().getObject(r[i]);
            Object o2 = o.resolveValue(this.keyfield);
            if (o2 instanceof IObject) {
                a.add(((IObject)o2).getObjectId());
            }
            ++i;
        }
        return a.toArray();
    }

    @Override
    public Iterator<Map.Entry<IObject, IObject>> extractMapEntries(final IObject coll) {
        ExtractedMap em = this.extractMap(coll);
        final Iterator<Map.Entry<IObject, IObject>> it = em.iterator();
        return new Iterator<Map.Entry<IObject, IObject>>(){

            @Override
            public boolean hasNext() {
                return it.hasNext();
            }

            @Override
            public Map.Entry<IObject, IObject> next() {
                IObject value;
                Map.Entry e = (Map.Entry)it.next();
                IObject key = (IObject)e.getKey();
                if (key != null) {
                    try {
                        Object o = key.resolveValue(WrapperFieldMapExtractor.this.keyfield);
                        key = o instanceof IObject ? (IObject)o : null;
                    }
                    catch (SnapshotException e1) {
                        throw new RuntimeException(e1);
                    }
                }
                if ((value = (IObject)e.getValue()) != null) {
                    try {
                        Object o = value.resolveValue(WrapperFieldMapExtractor.this.valuefield);
                        value = o instanceof IObject ? (IObject)o : null;
                    }
                    catch (SnapshotException e1) {
                        throw new RuntimeException(e1);
                    }
                }
                return new IMapExtractor.EntryObject(coll, key, value);
            }
        };
    }
}

