/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.business.api.query;

import java.util.Collections;
import java.util.List;
import org.eclipse.sirius.diagram.DDiagram;
import org.eclipse.sirius.diagram.DNode;
import org.eclipse.sirius.diagram.LabelPosition;
import org.eclipse.sirius.diagram.NodeStyle;
import org.eclipse.sirius.diagram.ResizeKind;
import org.eclipse.sirius.diagram.Square;
import org.eclipse.sirius.diagram.business.api.diagramtype.DiagramTypeDescriptorRegistry;
import org.eclipse.sirius.diagram.business.api.diagramtype.IDiagramDescriptionProvider;
import org.eclipse.sirius.diagram.business.api.diagramtype.IDiagramTypeDescriptor;
import org.eclipse.sirius.diagram.description.NodeMapping;
import org.eclipse.sirius.diagram.description.style.NodeStyleDescription;
import org.eclipse.sirius.diagram.description.style.Side;
import org.eclipse.sirius.diagram.description.style.SquareDescription;
import org.eclipse.sirius.viewpoint.Style;
import org.eclipse.sirius.viewpoint.description.style.StyleDescription;

public class DNodeQuery {
    private final DNode node;

    public DNodeQuery(DNode node) {
        this.node = node;
    }

    public boolean allowsVerticalResize() {
        ResizeKind allowed = this.node.getResizeKind();
        return allowed == ResizeKind.NSEW_LITERAL || allowed == ResizeKind.NORTH_SOUTH_LITERAL;
    }

    public boolean allowsHorizontalResize() {
        ResizeKind allowed = this.node.getResizeKind();
        return allowed == ResizeKind.NSEW_LITERAL || allowed == ResizeKind.EAST_WEST_LITERAL;
    }

    public boolean hasLabelOnBorder() {
        NodeStyleDescription style;
        NodeMapping actualMapping = this.node.getActualMapping();
        if (actualMapping != null && (style = actualMapping.getStyle()) != null) {
            LabelPosition labelPosition = style.getLabelPosition();
            return labelPosition.equals((Object)LabelPosition.BORDER_LITERAL);
        }
        return false;
    }

    public boolean hasNonEmptyNameDefinition() {
        NodeStyleDescription style;
        boolean hasEmptyNameDefinition = true;
        NodeMapping actualMapping = this.node.getActualMapping();
        if (actualMapping != null && (style = actualMapping.getStyle()) != null) {
            String labelExpression = style.getLabelExpression();
            hasEmptyNameDefinition = labelExpression.trim().length() != 0;
        }
        return hasEmptyNameDefinition;
    }

    public List<Side> getForbiddenSide() {
        NodeStyle nodeStyle = this.node.getOwnedStyle();
        StyleDescription styleDescription = nodeStyle.getDescription();
        if (styleDescription instanceof NodeStyleDescription) {
            return ((NodeStyleDescription)styleDescription).getForbiddenSides();
        }
        return Collections.emptyList();
    }

    /*
     * WARNING - void declaration
     */
    public boolean isAutoSize() {
        Style style;
        StyleDescription styleDescription;
        NodeStyle ownedStyle = this.node.getOwnedStyle();
        boolean supportsAutoSize = false;
        if (ownedStyle != null && (styleDescription = ownedStyle.getDescription()) instanceof NodeStyleDescription) {
            void nodeStyleDesc;
            NodeStyleDescription nodeStyleDescription = (NodeStyleDescription)styleDescription;
            NodeStyleDescription cfr_ignored_0 = (NodeStyleDescription)styleDescription;
            supportsAutoSize = this.supportNodeStyleAutoSize(ownedStyle, (NodeStyleDescription)nodeStyleDesc);
        }
        if (supportsAutoSize && (style = this.node.getStyle()) instanceof Square) {
            void square;
            Square square2 = (Square)style;
            Square cfr_ignored_1 = (Square)style;
            if (square.getWidth() == -1 && square.getHeight() == -1) {
                return true;
            }
        }
        return false;
    }

    public boolean supportNodeStyleAutoSize(NodeStyle style, NodeStyleDescription description) {
        boolean supportAutoSizeStyle = true;
        DDiagram parentDiagram = this.node.getParentDiagram();
        if (parentDiagram != null) {
            for (IDiagramTypeDescriptor diagramTypeDescriptor : DiagramTypeDescriptorRegistry.getInstance().getAllDiagramTypeDescriptors()) {
                if (!diagramTypeDescriptor.getDiagramDescriptionProvider().handles(parentDiagram.getDescription().eClass().getEPackage())) continue;
                IDiagramDescriptionProvider provider = diagramTypeDescriptor.getDiagramDescriptionProvider();
                supportAutoSizeStyle = provider.allowsAutoSizeNodeStyle(this.node);
                break;
            }
        }
        if (style != null) {
            supportAutoSizeStyle = supportAutoSizeStyle && style instanceof Square && style.getLabelPosition().getValue() == 1;
        } else if (description != null) {
            supportAutoSizeStyle = supportAutoSizeStyle && description instanceof SquareDescription && description.getLabelPosition().getValue() == 1;
        }
        return supportAutoSizeStyle;
    }
}

