import type * as vscode from 'vscode-languageserver-protocol';
import type { ServiceContext } from '../types';
export declare function updateRange(range: vscode.Range, change: {
    range: vscode.Range;
    newEnd: vscode.Position;
}): vscode.Range | undefined;
export interface ServiceDiagnosticData {
    uri: string;
    version: number;
    original: Pick<vscode.Diagnostic, 'data'>;
    isFormat: boolean;
    serviceIndex: number;
    documentUri: string;
}
export declare const errorMarkups: Record<string, {
    error: vscode.Diagnostic;
    markup: vscode.MarkupContent;
}[]>;
export declare function register(context: ServiceContext): (uri: string, token?: vscode.CancellationToken, response?: (result: vscode.Diagnostic[]) => void) => Promise<vscode.Diagnostic[]>;
