import type { ProviderResult, ServiceContext, LanguageServicePlugin } from '@volar/language-service';
import type * as ts from 'typescript';
import type { TextDocument } from 'vscode-languageserver-textdocument';
export interface Provide {
    'typescript/languageService': () => ts.LanguageService;
    'typescript/languageServiceHost': () => ts.LanguageServiceHost;
    'typescript/documentFileName': (uri: string) => string;
    'typescript/documentUri': (fileName: string) => string;
}
export interface CompletionItemData {
    uri: string;
    fileName: string;
    offset: number;
    originalItem: {
        name: ts.CompletionEntry['name'];
        source: ts.CompletionEntry['source'];
        data: ts.CompletionEntry['data'];
        labelDetails: ts.CompletionEntry['labelDetails'];
    };
}
export declare function create(ts: typeof import('typescript'), { isValidationEnabled, isSuggestionsEnabled, }?: {
    isValidationEnabled?(document: TextDocument, context: ServiceContext): ProviderResult<boolean>;
    isSuggestionsEnabled?(document: TextDocument, context: ServiceContext): ProviderResult<boolean>;
}): LanguageServicePlugin;
//# sourceMappingURL=semantic.d.ts.map