/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis.model.ecore.xmi.impl;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.axis.model.common.util.TreeIterator;
import org.apache.axis.model.ecore.EAnnotation;
import org.apache.axis.model.ecore.EClass;
import org.apache.axis.model.ecore.EClassifier;
import org.apache.axis.model.ecore.EDataType;
import org.apache.axis.model.ecore.EFactory;
import org.apache.axis.model.ecore.EObject;
import org.apache.axis.model.ecore.EPackage;
import org.apache.axis.model.ecore.EReference;
import org.apache.axis.model.ecore.EStructuralFeature;
import org.apache.axis.model.ecore.ETypedElement;
import org.apache.axis.model.ecore.EcoreFactory;
import org.apache.axis.model.ecore.EcorePackage;
import org.apache.axis.model.ecore.util.ECrossReferenceEList;
import org.apache.axis.model.ecore.util.EcoreUtil;
import org.apache.axis.model.ecore.xmi.XMLResource;
import org.apache.axis.model.ecore.xmi.impl.EMOFExtendedMetaData;
import org.apache.axis.model.ecore.xmi.impl.EMOFHandler;
import org.apache.axis.model.ecore.xmi.impl.XMLHelperImpl;

public class EMOFHelperImpl
extends XMLHelperImpl
implements EMOFHandler.Helper {
    protected EClass propertyClass = null;
    protected List propertyFeatureList = null;

    public EMOFHelperImpl(XMLResource resource) {
        super(resource);
        this.packages.put(EcorePackage.eINSTANCE, "emof");
    }

    public Object getValue(EObject object, EStructuralFeature feature) {
        if (feature == EcorePackage.eINSTANCE.getEStructuralFeature_Changeable()) {
            return ((EStructuralFeature)object).isChangeable() ? Boolean.FALSE : Boolean.TRUE;
        }
        return super.getValue(object, feature);
    }

    public void setValue(EObject object, EStructuralFeature feature, Object value, int position) {
        if (feature == EcorePackage.eINSTANCE.getEStructuralFeature_Changeable()) {
            ((EStructuralFeature)object).setChangeable(Boolean.FALSE.toString().equals(value));
        } else if (feature == EcorePackage.eINSTANCE.getETypedElement_UpperBound() && "*".equals(value)) {
            ((ETypedElement)object).setUpperBound(-1);
        } else {
            super.setValue(object, feature, value, position);
        }
    }

    public String getHREF(EObject obj) {
        String href = super.getHREF(obj);
        if (href.startsWith("http://www.eclipse.org/emf/2002/Ecore#//")) {
            String dataType = href.substring("http://www.eclipse.org/emf/2002/Ecore#//".length());
            int i = 0;
            while (i < EMOFExtendedMetaData.MAPPED_ECORE_EDATATYPES.length) {
                if (dataType.equals(EMOFExtendedMetaData.MAPPED_ECORE_EDATATYPES[i])) {
                    return "http://schema.omg.org/spec/mof/2.0/emof.xmi#" + EMOFExtendedMetaData.MAPPED_EMOF_EDATATYPES[i];
                }
                ++i;
            }
            return "http://www.eclipse.org/emf/2002/Ecore.emof#ecore." + dataType;
        }
        return href;
    }

    public EStructuralFeature getFeature(EClass eClass, String namespaceURI, String name, boolean isElement) {
        if (eClass == EcorePackage.eINSTANCE.getEAnnotation() && "element".equals(name)) {
            return EcorePackage.eINSTANCE.getEAnnotation_References();
        }
        int i = 0;
        int size = eClass.getFeatureCount();
        while (i < size) {
            EStructuralFeature eStructuralFeature = eClass.getEStructuralFeature(i);
            if (name.equals(this.extendedMetaData.getName(eStructuralFeature)) && (namespaceURI == null ? this.extendedMetaData.getNamespace(eStructuralFeature) == null : namespaceURI.equals(this.extendedMetaData.getNamespace(eStructuralFeature)))) {
                this.computeFeatureKind(eStructuralFeature);
                return eStructuralFeature;
            }
            ++i;
        }
        return null;
    }

    public EClassifier getType(EFactory eFactory, String typeName) {
        EPackage ePackage = eFactory.getEPackage();
        if (ePackage == EcorePackage.eINSTANCE) {
            if (EcorePackage.Literals.ESTRUCTURAL_FEATURE.getName().equals(typeName)) {
                if (this.propertyClass == null) {
                    this.propertyClass = EcoreFactory.eINSTANCE.createEClass();
                    this.propertyClass.getESuperTypes().add(EcorePackage.Literals.EREFERENCE);
                    this.propertyClass.getESuperTypes().add(EcorePackage.Literals.EATTRIBUTE);
                    this.propertyClass.setName("EMOFProperty");
                    EPackage propertyPackage = EcoreFactory.eINSTANCE.createEPackage();
                    propertyPackage.getEClassifiers().add(this.propertyClass);
                    this.propertyFeatureList = new ArrayList();
                }
                return this.propertyClass;
            }
            if ("Tag".equals(typeName)) {
                return EcorePackage.eINSTANCE.getEAnnotation();
            }
        }
        return super.getType(eFactory, typeName);
    }

    public EObject createObject(EFactory eFactory, EClassifier type) {
        if (type == this.propertyClass) {
            EObject property = this.propertyClass.getEPackage().getEFactoryInstance().create(this.propertyClass);
            this.propertyFeatureList.add(property);
            return property;
        }
        if (EcorePackage.Literals.EANNOTATION == type) {
            EAnnotation annotation = EcoreFactory.eINSTANCE.createEAnnotation();
            annotation.setSource("http://schema.omg.org/spec/mof/2.0/emof.xmi");
            return annotation;
        }
        return super.createObject(eFactory, type);
    }

    public void convertPropertyFeatures() {
        if (this.propertyFeatureList != null) {
            EcoreUtil.Copier copier = new EcoreUtil.Copier(false){

                protected EObject createCopy(EObject eObject) {
                    EClass eClass = ((EStructuralFeature)eObject).getEType() instanceof EDataType ? EcorePackage.eINSTANCE.getEAttribute() : EcorePackage.eINSTANCE.getEReference();
                    return EcoreUtil.create(eClass);
                }

                protected void copyContainment(EReference eReference, EObject eObject, EObject copyEObject) {
                    ((EStructuralFeature)copyEObject).getEAnnotations().addAll(((EStructuralFeature)eObject).getEAnnotations());
                }
            };
            copier.copyAll(this.propertyFeatureList);
            copier.copyReferences();
            Iterator iter = copier.entrySet().iterator();
            while (iter.hasNext()) {
                Map.Entry entry = iter.next();
                EStructuralFeature emofFeature = (EStructuralFeature)entry.getKey();
                EStructuralFeature ecoreFeature = (EStructuralFeature)entry.getValue();
                EClass eClass = emofFeature.getEContainingClass();
                eClass.getEStructuralFeatures().set(eClass.getEStructuralFeatures().indexOf(emofFeature), ecoreFeature);
            }
            TreeIterator contents = EcoreUtil.getAllContents(this.resource.getContents(), false);
            while (contents.hasNext()) {
                EObject eObject = (EObject)contents.next();
                ECrossReferenceEList.FeatureIteratorImpl featureIterator = new ECrossReferenceEList.FeatureIteratorImpl(eObject){

                    protected boolean isIncluded(EStructuralFeature eStructuralFeature) {
                        return !eStructuralFeature.isDerived() && super.isIncluded(eStructuralFeature);
                    }
                };
                while (featureIterator.hasNext()) {
                    EObject targetEObject = (EObject)featureIterator.next();
                    EObject copyEObject = (EObject)copier.get(targetEObject);
                    if (copyEObject == null) continue;
                    EReference eReference = (EReference)featureIterator.feature();
                    if (eReference.isMany()) {
                        List list = (List)eObject.eGet(eReference);
                        list.set(list.indexOf(targetEObject), copyEObject);
                        continue;
                    }
                    eObject.eSet(eReference, copyEObject);
                }
            }
        }
    }
}

