/*******************************************************************************
 * Copyright (c) 2000, 2017 IBM Corporation and others.
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 * 
 * SPDX-License-Identifier: EPL-2.0
 *
 *******************************************************************************/
package org.eclipse.dltk.internal.ui;

import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.ui.IElementFactory;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IPersistableElement;


/**
 * The PersistableModelElementFactory is used to save and recreate an IModelElement object.
 * As such, it implements the IPersistableElement interface for storage
 * and the IElementFactory interface for recreation.
 *
 * @see IMemento
 * @see IPersistableElement
 * @see IElementFactory
 */
public class PersistableModelElementFactory implements IElementFactory, IPersistableElement {

	private static final String KEY= "elementID"; //$NON-NLS-1$
	private static final String FACTORY_ID= "org.eclipse.dltk.ui.PersistableModelElementFactory"; //$NON-NLS-1$

	private IModelElement fElement;

	/**
	 * Create a ModelElementFactory.
	 */
	public PersistableModelElementFactory() {
	}

	/**
	 * Create a ModelElementFactory.  This constructor is typically used
	 * for our IPersistableElement side.
	 */
	public PersistableModelElementFactory(IModelElement element) {
		fElement= element;
	}

	@Override
	public IAdaptable createElement(IMemento memento) {

		String identifier= memento.getString(KEY);
		if (identifier != null) {
			return DLTKCore.create(identifier);
		}
		return null;
	}

	@Override
	public String getFactoryId() {
		return FACTORY_ID;
	}
	@Override
	public void saveState(IMemento memento) {
		memento.putString(KEY, fElement.getHandleIdentifier());
	}
}
