/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.edit.ui.provider;

import java.io.IOException;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.HashMap;
import org.eclipse.emf.common.CommonPlugin;
import org.eclipse.emf.common.EMFPlugin;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.edit.EMFEditPlugin;
import org.eclipse.emf.edit.provider.ComposedImage;
import org.eclipse.emf.edit.ui.EMFEditUIPlugin;
import org.eclipse.emf.edit.ui.provider.ComposedImageDescriptor;
import org.eclipse.emf.edit.ui.provider.ImageWrapperImageDescriptor;
import org.eclipse.emf.edit.ui.provider.URLImageDescriptor;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PlatformUI;

public class ExtendedImageRegistry {
    public static final ExtendedImageRegistry INSTANCE = new ExtendedImageRegistry(){

        @Override
        public Image getImage(Object object) {
            return 1.getInstance().getImage(object);
        }

        @Override
        public ImageDescriptor getImageDescriptor(Object object) {
            return 1.getInstance().getImageDescriptor(object);
        }
    };
    private static final Method INSTANCE_METHOD;
    protected HashMap<Object, Image> table = new HashMap(10);
    protected static Object resourceURL;
    protected static String resourceURLPrefix;
    protected static String itemURLPrefix;
    protected static String createChildURLPrefix;

    static {
        Method instanceMethod = null;
        try {
            Class singletonUtilityClass = CommonPlugin.loadClass((String)"org.eclipse.rap.rwt", (String)"org.eclipse.rap.rwt.SingletonUtil");
            instanceMethod = singletonUtilityClass.getMethod("getSessionInstance", Class.class);
        }
        catch (Exception exception) {
            try {
                Class singletonUtilityClass = CommonPlugin.loadClass((String)"org.eclipse.rap.rwt", (String)"org.eclipse.rap.rwt.SessionSingletonBase");
                instanceMethod = singletonUtilityClass.getMethod("getInstance", Class.class);
            }
            catch (Exception exception2) {
                EMFEditUIPlugin.INSTANCE.log(exception2);
            }
        }
        INSTANCE_METHOD = instanceMethod;
        resourceURL = EMFEditPlugin.INSTANCE.getImage("full/obj16/Resource");
        resourceURLPrefix = String.valueOf(resourceURL.toString()) + "#";
        itemURLPrefix = String.valueOf(EMFEditPlugin.INSTANCE.getImage("full/obj16/Item").toString()) + "#";
        createChildURLPrefix = String.valueOf(EMFEditPlugin.INSTANCE.getImage("full/ctool16/CreateChild").toString()) + "#";
    }

    static <T> T getInstance(Class<T> _class) {
        try {
            return (T)INSTANCE_METHOD.invoke(null, _class);
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    public static ExtendedImageRegistry getInstance() {
        return ExtendedImageRegistry.getInstance(ExtendedImageRegistry.class);
    }

    public ExtendedImageRegistry() {
        Display display = Display.getCurrent();
        this.hookDisplayDispose(display);
    }

    public ExtendedImageRegistry(Display display) {
        this.hookDisplayDispose(display);
    }

    public Image getImage(Object object) {
        if (object instanceof Image) {
            return (Image)object;
        }
        Image result = this.table.get(object);
        if (result == null) {
            if (object instanceof ImageDescriptor) {
                ImageDescriptor imageDescriptor = (ImageDescriptor)object;
                result = imageDescriptor.createImage();
            } else if (object instanceof URL || object instanceof URI) {
                String urlString = object.toString();
                ImageDescriptor imageDescriptor = null;
                if (urlString.startsWith(resourceURLPrefix)) {
                    if (EMFPlugin.IS_RESOURCES_BUNDLE_AVAILABLE) {
                        imageDescriptor = PlatformUI.getWorkbench().getEditorRegistry().getImageDescriptor("dummy." + urlString.substring(resourceURLPrefix.length()));
                    } else {
                        result = this.getImage(resourceURL);
                    }
                } else if (urlString.startsWith(itemURLPrefix)) {
                    try {
                        URL url = new URL(urlString.substring(0, itemURLPrefix.length()));
                        String key1 = urlString.substring(itemURLPrefix.length());
                        imageDescriptor = new URLImageDescriptor(url, key1, null);
                    }
                    catch (IOException url) {}
                } else if (urlString.startsWith(createChildURLPrefix)) {
                    try {
                        URL url = new URL(urlString.substring(0, createChildURLPrefix.length()));
                        String key1 = urlString.substring(createChildURLPrefix.length() + 1);
                        String key2 = null;
                        int index = key1.indexOf("/");
                        if (index != -1) {
                            key2 = key1.substring(index + 1);
                            key1 = key1.substring(0, index);
                        }
                        imageDescriptor = new URLImageDescriptor(url, key1, key2);
                    }
                    catch (IOException iOException) {}
                } else {
                    try {
                        imageDescriptor = ImageDescriptor.createFromURL((URL)new URL(urlString));
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                if (imageDescriptor != null) {
                    result = imageDescriptor.createImage();
                }
            } else if (object instanceof ComposedImage) {
                ComposedImageDescriptor composedImageDescriptor = new ComposedImageDescriptor((ComposedImage)object);
                result = composedImageDescriptor.createImage();
            }
            if (result != null) {
                this.table.put(object, result);
            }
        }
        return result;
    }

    public ImageDescriptor getImageDescriptor(Object object) {
        if (object instanceof ImageDescriptor) {
            return (ImageDescriptor)object;
        }
        Image image = this.getImage(object);
        if (image != null) {
            return new ImageWrapperImageDescriptor(image);
        }
        return null;
    }

    protected void handleDisplayDispose() {
        this.table = null;
    }

    protected void hookDisplayDispose(Display display) {
        display.disposeExec(new Runnable(){

            @Override
            public void run() {
                ExtendedImageRegistry.this.handleDisplayDispose();
            }
        });
    }
}

