/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsp.core.internal.validation;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceProxy;
import org.eclipse.core.resources.IResourceProxyVisitor;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExecutableExtension;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.content.IContentDescription;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jst.jsp.core.internal.JSPCoreMessages;
import org.eclipse.jst.jsp.core.internal.Logger;
import org.eclipse.jst.jsp.core.internal.contenttype.DeploymentDescriptorPropertyCache;
import org.eclipse.jst.jsp.core.internal.provisional.contenttype.ContentTypeIdForJSP;
import org.eclipse.jst.jsp.core.internal.validation.FragmentValidationTools;
import org.eclipse.jst.jsp.core.internal.validation.JSPActionValidator;
import org.eclipse.jst.jsp.core.internal.validation.JSPDirectiveValidator;
import org.eclipse.jst.jsp.core.internal.validation.JSPELValidator;
import org.eclipse.jst.jsp.core.internal.validation.JSPJavaValidator;
import org.eclipse.jst.jsp.core.internal.validation.LocalizedMessage;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.sse.core.StructuredModelManager;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.sse.core.utils.StringUtils;
import org.eclipse.wst.validation.AbstractValidator;
import org.eclipse.wst.validation.ValidationResult;
import org.eclipse.wst.validation.ValidationState;
import org.eclipse.wst.validation.internal.ConfigurationManager;
import org.eclipse.wst.validation.internal.ProjectConfiguration;
import org.eclipse.wst.validation.internal.ValidationRegistryReader;
import org.eclipse.wst.validation.internal.ValidatorMetaData;
import org.eclipse.wst.validation.internal.core.ValidationException;
import org.eclipse.wst.validation.internal.operations.IWorkbenchContext;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;
import org.eclipse.wst.validation.internal.provisional.core.IReporter;
import org.eclipse.wst.validation.internal.provisional.core.IValidationContext;
import org.eclipse.wst.validation.internal.provisional.core.IValidator;
import org.eclipse.wst.validation.internal.provisional.core.IValidatorJob;

public final class JSPBatchValidator
extends AbstractValidator
implements IValidatorJob,
IExecutableExtension {
    static final boolean DEBUG = Boolean.valueOf(Platform.getDebugOption((String)"org.eclipse.jst.jsp.core/debug/jspvalidator"));
    private static final String PLUGIN_ID_JSP_CORE = "org.eclipse.jst.jsp.core";
    Collection<IResource> fDependsOn;
    String[] fAdditionalContentTypesIDs = null;
    private JSPDirectiveValidator fJSPDirectiveValidator = new JSPDirectiveValidator((IValidator)this);
    private JSPELValidator fJSPELValidator = new JSPELValidator((IValidator)this);
    private IContentType fJSPFContentType = null;
    private JSPJavaValidator fJSPJavaValidator = new JSPJavaValidator((IValidator)this);
    private JSPActionValidator fJSPActionValidator = new JSPActionValidator((IValidator)this);

    private static ProjectConfiguration getProjectConfiguration(IFile file) {
        IProject project;
        ProjectConfiguration projectConfiguration = null;
        if (file != null && (project = file.getProject()) != null) {
            try {
                projectConfiguration = ConfigurationManager.getManager().getProjectConfiguration(project);
            }
            catch (InvocationTargetException e) {
                Logger.log(202, e.getMessage(), e);
            }
        }
        return projectConfiguration;
    }

    static boolean isBatchValidatorPreferenceEnabled(IFile file) {
        if (file == null) {
            return true;
        }
        boolean enabled = true;
        ProjectConfiguration configuration = JSPBatchValidator.getProjectConfiguration(file);
        if (configuration != null) {
            ValidatorMetaData metadata = ValidationRegistryReader.getReader().getValidatorMetaData(JSPBatchValidator.class.getName());
            if (configuration != null && metadata != null && !configuration.isBuildEnabled(metadata) && !configuration.isManualEnabled(metadata)) {
                enabled = false;
            }
        }
        return enabled;
    }

    void addDependsOn(IResource resource) {
        if (resource != null) {
            this.fDependsOn.add(resource);
        }
    }

    public void cleanup(IReporter reporter) {
        this.fJSPDirectiveValidator.cleanup(reporter);
        this.fJSPELValidator.cleanup(reporter);
        this.fJSPJavaValidator.cleanup(reporter);
        this.fJSPActionValidator.cleanup(reporter);
    }

    void doValidate(IValidationContext helper, IReporter reporter) throws ValidationException {
        block11: {
            JSPFileVisitor visitor;
            LocalizedMessage message;
            block9: {
                block10: {
                    String[] uris = helper.getURIs();
                    if (uris.length <= 0) break block10;
                    IWorkspaceRoot wsRoot = ResourcesPlugin.getWorkspace().getRoot();
                    IFile currentFile = null;
                    int i = 0;
                    while (i < uris.length && !reporter.isCancelled()) {
                        currentFile = wsRoot.getFile((IPath)new Path(uris[i]));
                        if (currentFile != null && currentFile.exists()) {
                            if (this.shouldValidate(currentFile) && this.fragmentCheck(currentFile)) {
                                LocalizedMessage message2 = new LocalizedMessage(4, currentFile.getFullPath().toString().substring(1));
                                reporter.displaySubtask((IValidator)this, (IMessage)message2);
                                this.validateFile(currentFile, reporter);
                            }
                            if (DEBUG) {
                                System.out.println("validating: [" + uris[i] + "]");
                            }
                        }
                        ++i;
                    }
                    break block11;
                }
                if (!(helper instanceof IWorkbenchContext)) break block11;
                IProject project = ((IWorkbenchContext)helper).getProject();
                message = new LocalizedMessage(4, NLS.bind((String)JSPCoreMessages.JSPBatchValidator_0, (Object)project.getFullPath()));
                reporter.displaySubtask((IValidator)this, (IMessage)message);
                visitor = new JSPFileVisitor(reporter);
                try {
                    project.accept((IResourceProxyVisitor)visitor, 2);
                }
                catch (CoreException e) {
                    if (!DEBUG) break block9;
                    e.printStackTrace();
                }
            }
            IFile[] files = visitor.getFiles();
            int i = 0;
            while (i < files.length && !reporter.isCancelled()) {
                if (this.shouldValidate(files[i]) && this.fragmentCheck(files[i])) {
                    message = new LocalizedMessage(4, files[i].getFullPath().toString().substring(1));
                    reporter.displaySubtask((IValidator)this, (IMessage)message);
                    this.validateFile(files[i], reporter);
                }
                if (DEBUG) {
                    System.out.println("validating: [" + String.valueOf(files[i]) + "]");
                }
                ++i;
            }
        }
    }

    boolean fragmentCheck(IFile file) {
        boolean shouldValidateFragments;
        boolean shouldValidate = true;
        if (this.getJSPFContentType().isAssociatedWith(file.getName()) && !(shouldValidateFragments = FragmentValidationTools.shouldValidateFragment((IResource)file))) {
            boolean isFragment = this.isFragment(file);
            shouldValidate = !isFragment;
        }
        return shouldValidate;
    }

    private IContentType getJSPFContentType() {
        if (this.fJSPFContentType == null) {
            this.fJSPFContentType = Platform.getContentTypeManager().getContentType(ContentTypeIdForJSP.ContentTypeID_JSPFRAGMENT);
        }
        return this.fJSPFContentType;
    }

    public ISchedulingRule getSchedulingRule(IValidationContext helper) {
        if (helper instanceof IWorkbenchContext) {
            return ResourcesPlugin.getWorkspace().getRuleFactory().buildRule();
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean isFragment(IFile file) {
        boolean isFragment = false;
        InputStream is = null;
        try {
            IContentDescription contentDescription = file.getContentDescription();
            if (contentDescription == null) {
                is = file.getContents();
                contentDescription = Platform.getContentTypeManager().getDescriptionFor(is, file.getName(), new QualifiedName[]{IContentDescription.CHARSET});
            }
            if (contentDescription != null) {
                String fileCtId = contentDescription.getContentType().getId();
                isFragment = fileCtId != null && ContentTypeIdForJSP.ContentTypeID_JSPFRAGMENT.equals(fileCtId);
            }
        }
        catch (IOException iOException) {
            if (is == null) return isFragment;
            try {
                is.close();
                return isFragment;
            }
            catch (Exception exception) {}
            return isFragment;
        }
        catch (CoreException coreException) {
            try {
                if (is == null) return isFragment;
            }
            catch (Throwable throwable) {
                if (is == null) throw throwable;
                try {
                    is.close();
                    throw throwable;
                }
                catch (Exception exception) {}
                throw throwable;
            }
            try {
                is.close();
                return isFragment;
            }
            catch (Exception exception) {}
            return isFragment;
        }
        if (is == null) return isFragment;
        try {
            is.close();
            return isFragment;
        }
        catch (Exception exception) {}
        return isFragment;
    }

    boolean isJSPType(String fileName) {
        boolean valid = ContentTypeIdForJSP.indexOfJSPExtension(fileName) >= 0;
        return valid;
    }

    private void performValidation(IFile f, IReporter reporter, IStructuredModel model) {
        if (!reporter.isCancelled()) {
            this.fJSPJavaValidator.performValidation(f, reporter, model);
        }
        if (!reporter.isCancelled()) {
            this.fJSPDirectiveValidator.performValidation(f, reporter, model.getStructuredDocument());
        }
        if (!reporter.isCancelled()) {
            this.fJSPELValidator.performValidation(f, reporter, model.getStructuredDocument());
        }
        if (!reporter.isCancelled()) {
            this.fJSPActionValidator.performValidation(f, reporter, model);
        }
    }

    public void setInitializationData(IConfigurationElement config, String propertyName, Object data) throws CoreException {
        this.fAdditionalContentTypesIDs = new String[0];
        if (data != null && data instanceof String && data.toString().length() > 0) {
            this.fAdditionalContentTypesIDs = StringUtils.unpack((String)data.toString());
        }
    }

    private boolean shouldValidate(IFile file) {
        IFile resource = file;
        do {
            if (!resource.isDerived() && !resource.isTeamPrivateMember() && resource.isAccessible() && resource.getName().charAt(0) != '.') continue;
            return false;
        } while (((resource = resource.getParent()).getType() & 4) == 0);
        return true;
    }

    public void validate(IValidationContext helper, IReporter reporter) throws ValidationException {
        this.doValidate(helper, reporter);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    void validateFile(IFile f, IReporter reporter) {
        IStructuredModel model = null;
        try {
            try {
                model = StructuredModelManager.getModelManager().getModelForRead(f);
                if (reporter.isCancelled() || model == null) return;
                reporter.removeAllMessages((IValidator)this, (Object)f);
                this.performValidation(f, reporter, model);
                return;
            }
            catch (IOException e) {
                Logger.logException(e);
                if (model == null) return;
                model.releaseFromRead();
                return;
            }
            catch (CoreException e) {
                Logger.logException(e);
                if (model == null) return;
                model.releaseFromRead();
                return;
            }
        }
        finally {
            if (model != null) {
                model.releaseFromRead();
            }
        }
    }

    public IStatus validateInJob(final IValidationContext helper, final IReporter reporter) throws ValidationException {
        Job currentJob = Job.getJobManager().currentJob();
        ISchedulingRule rule = null;
        if (currentJob != null) {
            rule = currentJob.getRule();
        }
        IWorkspaceRunnable validationRunnable = new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                try {
                    JSPBatchValidator.this.doValidate(helper, reporter);
                }
                catch (ValidationException e) {
                    throw new CoreException((IStatus)new Status(4, JSPBatchValidator.PLUGIN_ID_JSP_CORE, 0, JSPBatchValidator.PLUGIN_ID_JSP_CORE, (Throwable)e));
                }
            }
        };
        try {
            JavaCore.run((IWorkspaceRunnable)validationRunnable, (ISchedulingRule)rule, (IProgressMonitor)new NullProgressMonitor());
        }
        catch (CoreException e) {
            if (e.getCause() instanceof ValidationException) {
                throw (ValidationException)e.getCause();
            }
            throw new ValidationException((IMessage)new LocalizedMessage(3, e.getMessage()), (Throwable)e);
        }
        return Status.OK_STATUS;
    }

    public ValidationResult validate(final IResource resource, int kind, ValidationState state, IProgressMonitor monitor) {
        if (resource.getType() != 1) {
            return null;
        }
        if (!this.shouldValidate((IFile)resource)) {
            return null;
        }
        final ValidationResult result = new ValidationResult();
        final IReporter reporter = result.getReporter(monitor);
        this.fDependsOn = result.getDependsOn() != null ? new HashSet<IResource>(Arrays.asList(result.getDependsOn())) : new HashSet<IResource>();
        this.addDependsOn((IResource)DeploymentDescriptorPropertyCache.getInstance().getWebXML(resource.getFullPath()));
        IWorkspaceRoot workspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
        DeploymentDescriptorPropertyCache.PropertyGroup[] propertyGroups = DeploymentDescriptorPropertyCache.getInstance().getPropertyGroups(resource.getFullPath());
        int j = 0;
        while (j < propertyGroups.length) {
            IPath[] preludes = propertyGroups[j].getIncludePrelude();
            int i = 0;
            while (i < preludes.length) {
                this.addDependsOn((IResource)workspaceRoot.getFile(preludes[i]));
                ++i;
            }
            IPath[] codas = propertyGroups[j].getIncludeCoda();
            int i2 = 0;
            while (i2 < codas.length) {
                this.addDependsOn((IResource)workspaceRoot.getFile(codas[i2]));
                ++i2;
            }
            ++j;
        }
        IWorkspaceRunnable validationRunnable = new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                if (JSPBatchValidator.this.fragmentCheck((IFile)resource)) {
                    JSPBatchValidator.this.validateFile((IFile)resource, reporter);
                }
                IResource[] resources = JSPBatchValidator.this.fDependsOn.toArray(new IResource[JSPBatchValidator.this.fDependsOn.size()]);
                result.setDependsOn(resources);
                JSPBatchValidator.this.fDependsOn.clear();
            }
        };
        Job currentJob = Job.getJobManager().currentJob();
        ISchedulingRule rule = null;
        if (currentJob != null) {
            rule = currentJob.getRule();
        }
        try {
            JavaCore.run((IWorkspaceRunnable)validationRunnable, (ISchedulingRule)rule, (IProgressMonitor)new NullProgressMonitor());
        }
        catch (CoreException e) {
            Logger.logException(e);
        }
        return result;
    }

    class JSPFileVisitor
    implements IResourceProxyVisitor {
        private List<IFile> fFiles = new ArrayList<IFile>();
        private IReporter fReporter = null;

        public JSPFileVisitor(IReporter reporter) {
            this.fReporter = reporter;
        }

        final IFile[] getFiles() {
            return this.fFiles.toArray(new IFile[this.fFiles.size()]);
        }

        public boolean visit(IResourceProxy proxy) throws CoreException {
            if (this.fReporter.isCancelled() || proxy.isDerived()) {
                return false;
            }
            if (proxy.getType() == 1 && JSPBatchValidator.this.isJSPType(proxy.getName()) && proxy.isAccessible()) {
                IFile file = (IFile)proxy.requestResource();
                if (DEBUG) {
                    System.out.println("(+) JSPValidator adding file: " + file.getName());
                }
                this.fFiles.add(file);
                return false;
            }
            return true;
        }
    }
}

