/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rap.demo;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.DecoratingLabelProvider;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ILabelDecorator;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.ISharedImages;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.ViewPart;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.IPropertySheetPage;
import org.eclipse.ui.views.properties.IPropertySource;
import org.eclipse.ui.views.properties.PropertySheetPage;
import org.eclipse.ui.views.properties.TextPropertyDescriptor;

public class DemoTreeViewPart
extends ViewPart
implements IDoubleClickListener {
    private TreeViewer viewer;
    private IPropertySheetPage propertyPage;

    public void createPartControl(Composite parent) {
        this.viewer = new TreeViewer(parent, 770);
        this.viewer.setContentProvider((IContentProvider)new TreeViewerContentProvider());
        ILabelDecorator labelDecorator = PlatformUI.getWorkbench().getDecoratorManager().getLabelDecorator();
        DecoratingLabelProvider labelProvider = new DecoratingLabelProvider((ILabelProvider)new ViewLabelProvider(), labelDecorator);
        this.viewer.setLabelProvider((IBaseLabelProvider)labelProvider);
        this.viewer.setInput((Object)this);
        this.viewer.addDoubleClickListener((IDoubleClickListener)this);
        this.getSite().setSelectionProvider((ISelectionProvider)this.viewer);
    }

    public Object getAdapter(Class adapter) {
        Object result = super.getAdapter(adapter);
        if (adapter == IPropertySheetPage.class) {
            if (this.propertyPage == null) {
                this.propertyPage = new PropertySheetPage();
            }
            result = this.propertyPage;
        }
        return result;
    }

    public void setFocus() {
        this.viewer.getTree().setFocus();
    }

    public void doubleClick(DoubleClickEvent event) {
        String msg = "You doubleclicked on " + event.getSelection().toString();
        Shell shell = this.viewer.getTree().getShell();
        MessageDialog.openInformation((Shell)shell, (String)"Treeviewer", (String)msg);
    }

    private void update(TreeObject treeObject) {
        this.getViewer().update((Object)treeObject, null);
    }

    public TreeViewer getViewer() {
        return this.viewer;
    }

    private class BrokenTreeObject
    extends TreeObject {
        public BrokenTreeObject(String name) {
            super(name);
        }
    }

    class TreeObject
    implements IPropertySource {
        private static final String PROP_ID_LOCATION = "location";
        private static final String PROP_ID_NAME = "name";
        private String name;
        private String location;
        private TreeParent parent;

        public TreeObject(String name) {
            this(name, "");
        }

        public TreeObject(String name, String location) {
            this.name = name;
            this.location = location;
        }

        public String getName() {
            return this.name;
        }

        public String getLocation() {
            return this.location;
        }

        public void setParent(TreeParent parent) {
            this.parent = parent;
        }

        public TreeParent getParent() {
            return this.parent;
        }

        public String toString() {
            return this.getName();
        }

        public Object getEditableValue() {
            return this;
        }

        public IPropertyDescriptor[] getPropertyDescriptors() {
            return new IPropertyDescriptor[]{new TextPropertyDescriptor((Object)PROP_ID_NAME, "Name"), new TextPropertyDescriptor((Object)PROP_ID_LOCATION, "Location")};
        }

        public Object getPropertyValue(Object id) {
            String result = null;
            if (PROP_ID_NAME.equals(id)) {
                result = this.name;
            } else if (PROP_ID_LOCATION.equals(id)) {
                result = this.location;
            }
            return result;
        }

        public boolean isPropertySet(Object id) {
            boolean result = false;
            if (PROP_ID_NAME.equals(id)) {
                result = this.name != null && !"".equals(this.name);
            } else if (PROP_ID_LOCATION.equals(id)) {
                result = this.location != null && !"".equals(this.location);
            }
            return result;
        }

        public void resetPropertyValue(Object id) {
            if (PROP_ID_NAME.equals(id)) {
                this.name = "";
            } else if (PROP_ID_LOCATION.equals(id)) {
                this.location = "";
            }
        }

        public void setPropertyValue(Object id, Object value) {
            if (PROP_ID_NAME.equals(id)) {
                this.name = (String)value;
            } else if (PROP_ID_LOCATION.equals(id)) {
                this.location = (String)value;
            }
            DemoTreeViewPart.this.update(this);
        }
    }

    private class TreeParent
    extends TreeObject {
        private final List<TreeObject> children;

        public TreeParent(String name) {
            super(name);
            this.children = new ArrayList<TreeObject>();
        }

        public void addChild(TreeObject child) {
            this.children.add(child);
            child.setParent(this);
        }

        public TreeObject[] getChildren() {
            TreeObject[] result = new TreeObject[this.children.size()];
            this.children.toArray(result);
            return result;
        }

        public boolean hasChildren() {
            return this.children.size() > 0;
        }
    }

    private final class TreeViewerContentProvider
    implements IStructuredContentProvider,
    ITreeContentProvider {
        private TreeParent invisibleRoot;

        private TreeViewerContentProvider() {
        }

        public void inputChanged(Viewer v, Object oldInput, Object newInput) {
        }

        public void dispose() {
        }

        public Object[] getElements(Object parent) {
            if (parent instanceof IViewPart) {
                if (this.invisibleRoot == null) {
                    this.initialize();
                }
                return this.getChildren(this.invisibleRoot);
            }
            return this.getChildren(parent);
        }

        public Object getParent(Object child) {
            if (child instanceof TreeObject) {
                return ((TreeObject)child).getParent();
            }
            return null;
        }

        public Object[] getChildren(Object parent) {
            if (parent instanceof TreeParent) {
                return ((TreeParent)parent).getChildren();
            }
            return new Object[0];
        }

        public boolean hasChildren(Object parent) {
            if (parent instanceof TreeParent) {
                return ((TreeParent)parent).hasChildren();
            }
            return false;
        }

        private void initialize() {
            TreeObject to1 = new TreeObject("EclipseCon location", "http://maps.google.com/maps?q=5001%20Great%20America%20Pkwy%20Santa%20Clara%20CA%2095054");
            TreeObject to2 = new TreeObject("Eclipse Foundation", "http://maps.google.com/maps?q=Ottawa");
            TreeObject to3 = new TreeObject("Innoopract Inc", "http://maps.google.com/maps?q=Portland");
            TreeParent p1 = new TreeParent("Locate in browser view");
            p1.addChild(to1);
            p1.addChild(to2);
            p1.addChild(to3);
            BrokenTreeObject to4 = new BrokenTreeObject("Leaf 4");
            TreeParent p2 = new TreeParent("Parent 2");
            p2.addChild(to4);
            TreeParent root = new TreeParent("Root");
            TreeParent p3 = new TreeParent("Child X - filter me!");
            root.addChild(p1);
            root.addChild(p2);
            root.addChild(p3);
            this.invisibleRoot = new TreeParent("");
            this.invisibleRoot.addChild(root);
        }
    }

    private static final class ViewLabelProvider
    extends LabelProvider {
        private ViewLabelProvider() {
        }

        public Image getImage(Object element) {
            IWorkbench workbench = PlatformUI.getWorkbench();
            ISharedImages sharedImages = workbench.getSharedImages();
            return sharedImages.getImage("IMG_OBJ_ELEMENTS");
        }
    }
}

