/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rwt.widgets;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import org.eclipse.rwt.SessionSingletonBase;
import org.eclipse.rwt.internal.protocol.ProtocolMessageWriter;
import org.eclipse.rwt.internal.service.ContextProvider;
import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.Display;

public final class ExternalBrowser {
    public static final int LOCATION_BAR = 2;
    public static final int NAVIGATION_BAR = 4;
    public static final int STATUS = 8;
    private static final String EXTERNAL_BROWSER_ID = "eb";
    private static final String EXTERNAL_BROWSER_TYPE = "rwt.widgets.ExternalBrowser";
    private static final String METHOD_OPEN = "open";
    private static final String METHOD_CLOSE = "close";
    private static final String PROPERTY_ID = "id";
    private static final String PROPERTY_URL = "url";
    private static final String PROPERTY_STYLE = "style";

    public static void open(String id, String url, int style) {
        ExternalBrowser.checkWidget();
        ExternalBrowser.ensureInstance();
        if (id == null || url == null) {
            SWT.error(4);
        }
        if (id.length() == 0) {
            SWT.error(5);
        }
        ExternalBrowser.renderOpen(id, url, style);
    }

    public static void close(String id) {
        ExternalBrowser.checkWidget();
        ExternalBrowser.ensureInstance();
        if (id == null) {
            SWT.error(4);
        }
        if (id.length() == 0) {
            SWT.error(5);
        }
        ExternalBrowser.renderClose(id);
    }

    private static void ensureInstance() {
        SessionSingletonBase.getInstance(ExternalBrowser.class);
    }

    private static void renderOpen(String id, String url, int style) {
        ProtocolMessageWriter protocolWriter = ContextProvider.getProtocolWriter();
        LinkedHashMap<String, Object> args = new LinkedHashMap<String, Object>();
        args.put(PROPERTY_ID, id);
        args.put(PROPERTY_URL, url);
        args.put(PROPERTY_STYLE, ExternalBrowser.getFeatures(style));
        protocolWriter.appendCall(EXTERNAL_BROWSER_ID, METHOD_OPEN, args);
    }

    private static void renderClose(String id) {
        ProtocolMessageWriter protocolWriter = ContextProvider.getProtocolWriter();
        HashMap<String, Object> args = new HashMap<String, Object>();
        args.put(PROPERTY_ID, id);
        protocolWriter.appendCall(EXTERNAL_BROWSER_ID, METHOD_CLOSE, args);
    }

    private static String[] getFeatures(int style) {
        ArrayList<String> features = new ArrayList<String>();
        if ((style & 8) != 0) {
            features.add("STATUS");
        }
        if ((style & 2) != 0) {
            features.add("LOCATION_BAR");
        }
        if ((style & 4) != 0) {
            features.add("NAVIGATION_BAR");
        }
        return features.toArray(new String[0]);
    }

    private static void checkWidget() {
        if (Display.getCurrent().getThread() != Thread.currentThread()) {
            SWT.error(22);
        }
    }

    private ExternalBrowser() {
        ProtocolMessageWriter protocolWriter = ContextProvider.getProtocolWriter();
        protocolWriter.appendCreate(EXTERNAL_BROWSER_ID, EXTERNAL_BROWSER_TYPE);
    }
}

