/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.events;

import org.eclipse.rwt.Adaptable;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.TypedEvent;
import org.eclipse.swt.internal.widgets.EventUtil;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Widget;

public class MouseEvent
extends TypedEvent {
    private static final long serialVersionUID = 1L;
    public static final int MOUSE_DOWN = 3;
    public static final int MOUSE_UP = 4;
    public static final int MOUSE_DOUBLE_CLICK = 8;
    private static final Class LISTENER = MouseListener.class;
    public int time;
    public int button;
    public int stateMask;
    public int x;
    public int y;

    public MouseEvent(Event event) {
        super(event);
        this.x = event.x;
        this.y = event.y;
        this.button = event.button;
        this.stateMask = event.stateMask;
        this.time = event.time;
    }

    public MouseEvent(Widget source, int id) {
        super(source, id);
    }

    protected void dispatchToObserver(Object listener) {
        switch (this.getID()) {
            case 4: {
                ((MouseListener)listener).mouseUp(this);
                break;
            }
            case 3: {
                ((MouseListener)listener).mouseDown(this);
                break;
            }
            case 8: {
                ((MouseListener)listener).mouseDoubleClick(this);
                break;
            }
            default: {
                throw new IllegalStateException("Invalid event handler type.");
            }
        }
    }

    protected Class getListenerType() {
        return LISTENER;
    }

    protected boolean allowProcessing() {
        return EventUtil.isAccessible(this.widget);
    }

    public String toString() {
        String string = super.toString();
        return String.valueOf(string.substring(0, string.length() - 1)) + " button=" + this.button + " stateMask=" + this.stateMask + " x=" + this.x + " y=" + this.y + "}";
    }

    public static void addListener(Adaptable adaptable, MouseListener listener) {
        MouseEvent.addListener(adaptable, LISTENER, listener);
    }

    public static void removeListener(Adaptable adaptable, MouseListener listener) {
        MouseEvent.removeListener(adaptable, LISTENER, listener);
    }

    public static boolean hasListener(Adaptable adaptable) {
        return MouseEvent.hasListener(adaptable, LISTENER);
    }

    public static Object[] getListeners(Adaptable adaptable) {
        return MouseEvent.getListener(adaptable, LISTENER);
    }
}

