/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rwt.internal.textsize;

import org.eclipse.rwt.internal.textsize.ProbeResultStore;
import org.eclipse.rwt.internal.util.EncodingUtil;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.internal.graphics.FontUtil;

public final class TextSizeEstimation {
    static Point stringExtent(Font font, String string) {
        int width = TextSizeEstimation.getLineWidth(string, font);
        int height = TextSizeEstimation.getCharHeight(font) + 2;
        return new Point(width, height);
    }

    static Point textExtent(Font font, String string, int wrapWidth) {
        int lineCount = 0;
        int maxWidth = 0;
        String[] lines = EncodingUtil.splitNewLines(string);
        int i = 0;
        while (i < lines.length) {
            String line = lines[i];
            ++lineCount;
            int width = TextSizeEstimation.getLineWidth(line, font);
            if (wrapWidth > 0) {
                boolean done = false;
                while (!done) {
                    int index = TextSizeEstimation.getLongestMatch(line, wrapWidth, font);
                    if (index == 0 || index == line.length()) {
                        done = true;
                        continue;
                    }
                    String substr = line.substring(0, index);
                    width = TextSizeEstimation.getLineWidth(substr, font);
                    maxWidth = Math.max(maxWidth, width);
                    line = line.substring(index, line.length());
                    ++lineCount;
                }
            }
            maxWidth = Math.max(maxWidth, width);
            ++i;
        }
        int height = Math.round((float)TextSizeEstimation.getCharHeight(font) * 1.25f * (float)lineCount);
        return new Point(maxWidth, height);
    }

    static Point markupExtent(Font font, String markup, int wrapWidth) {
        return TextSizeEstimation.textExtent(font, TextSizeEstimation.removeAllTags(markup), wrapWidth);
    }

    static int getCharHeight(Font font) {
        return FontUtil.getData(font).getHeight();
    }

    static float getAvgCharWidth(Font font) {
        float result;
        FontData fontData = FontUtil.getData(font);
        ProbeResultStore probeStore = ProbeResultStore.getInstance();
        if (probeStore.containsProbeResult(fontData)) {
            result = probeStore.getProbeResult(fontData).getAvgCharWidth();
        } else {
            result = (float)fontData.getHeight() * 0.48f;
            if ((fontData.getStyle() & 1) != 0) {
                result = (float)((double)result * 1.45);
            }
        }
        return result;
    }

    static String removeAllTags(String markup) {
        StringBuilder result = new StringBuilder();
        StringBuilder tag = new StringBuilder();
        boolean inTag = false;
        int length = markup.length();
        int i = 0;
        while (i < length) {
            char ch = markup.charAt(i);
            if (ch == '<') {
                inTag = true;
            } else if (ch == '>') {
                if (tag.toString().equalsIgnoreCase("br")) {
                    result.append("\n");
                }
                tag.setLength(0);
                inTag = false;
            } else if (inTag) {
                if (Character.isLetterOrDigit(ch)) {
                    tag.append(ch);
                }
            } else {
                result.append(ch);
            }
            ++i;
        }
        return result.toString();
    }

    private static int getLongestMatch(String string, int wrapWidth, Font font) {
        int result = 0;
        if (TextSizeEstimation.getLineWidth(string, font) < wrapWidth) {
            result = string.length();
        } else {
            String subStr = TextSizeEstimation.nextSubLine(string, 0);
            boolean done = false;
            while (!done && TextSizeEstimation.getLineWidth(subStr, font) <= wrapWidth) {
                result = subStr.length();
                if (subStr.length() == string.length()) {
                    done = true;
                    continue;
                }
                subStr = TextSizeEstimation.nextSubLine(string, subStr.length() + 1);
            }
        }
        return result;
    }

    private static String nextSubLine(String line, int startIndex) {
        String result = line;
        int index = line.indexOf(32, startIndex);
        if (index != -1) {
            result = line.substring(0, index);
        }
        return result;
    }

    private static int getLineWidth(String line, Font font) {
        return Math.round(TextSizeEstimation.getAvgCharWidth(font) * (float)line.length());
    }
}

