/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rtp.configurator.service.provider.internal.util;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.equinox.internal.provisional.configurator.Configurator;
import org.eclipse.equinox.p2.core.IProvisioningAgent;
import org.eclipse.equinox.p2.core.IProvisioningAgentProvider;
import org.eclipse.rtp.configurator.service.provider.internal.ProviderActivator;
import org.eclipse.rtp.configurator.service.provider.internal.deploy.FeatureManager;
import org.eclipse.rtp.configurator.service.provider.internal.deploy.RepositoryManager;
import org.eclipse.rtp.configurator.service.provider.internal.util.StatusUtil;
import org.eclipse.rtp.core.model.SourceVersion;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;

public class P2Util {
    private static Configurator configurator;
    private static RepositoryManager repositoryManager;
    private static IProvisioningAgent provisioningAgent;
    private static FeatureManager featureManager;

    public FeatureManager getFeatureManager() {
        return featureManager;
    }

    public RepositoryManager getRepositoryManager() {
        return repositoryManager;
    }

    public static void setConfigurator(Configurator configuratorService) {
        configurator = configuratorService;
    }

    public static void unsetConfigurator(Configurator configuratorService) {
        configurator = null;
    }

    protected static void startService() throws CoreException {
        provisioningAgent = P2Util.getAgent();
        repositoryManager = new RepositoryManager(provisioningAgent);
        featureManager = new FeatureManager(provisioningAgent, repositoryManager, configurator);
    }

    protected static void shutdown() {
        featureManager = null;
        repositoryManager = null;
        provisioningAgent.stop();
        provisioningAgent = null;
        configurator = null;
    }

    public boolean isSourceVersionInstalled(SourceVersion sourceVersion) {
        return featureManager.isInstalled(sourceVersion);
    }

    private static IProvisioningAgent getAgent() throws CoreException {
        BundleContext bundleContext = ProviderActivator.getBundleContext();
        IProvisioningAgentProvider agentProvider = P2Util.getService(bundleContext, IProvisioningAgentProvider.class, IProvisioningAgentProvider.SERVICE_NAME);
        P2Util.checkAgentAvailable(agentProvider);
        return agentProvider.createAgent(null);
    }

    private static void checkAgentAvailable(IProvisioningAgentProvider agentProvider) throws CoreException {
        if (agentProvider == null) {
            String message = "Agent provider service not available";
            IStatus status = StatusUtil.createStatus(4, message, null);
            throw new CoreException(status);
        }
    }

    private static <T> T getService(BundleContext context, Class<T> type, String name) {
        if (context == null || name == null) {
            throw new IllegalArgumentException();
        }
        ServiceReference reference = context.getServiceReference(name);
        Object result = null;
        if (reference != null) {
            result = context.getService(reference);
            context.ungetService(reference);
        }
        return (T)result;
    }
}

