/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rtp.configurator.service.provider.internal.deploy;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.equinox.internal.provisional.configurator.Configurator;
import org.eclipse.equinox.p2.core.IProvisioningAgent;
import org.eclipse.equinox.p2.engine.IProfile;
import org.eclipse.equinox.p2.engine.IProfileRegistry;
import org.eclipse.equinox.p2.engine.ProvisioningContext;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.metadata.Version;
import org.eclipse.equinox.p2.operations.InstallOperation;
import org.eclipse.equinox.p2.operations.ProfileChangeOperation;
import org.eclipse.equinox.p2.operations.ProvisioningJob;
import org.eclipse.equinox.p2.operations.ProvisioningSession;
import org.eclipse.equinox.p2.operations.UninstallOperation;
import org.eclipse.equinox.p2.query.IQueryResult;
import org.eclipse.equinox.p2.query.QueryUtil;
import org.eclipse.rtp.configurator.service.provider.internal.deploy.FeatureInstallException;
import org.eclipse.rtp.configurator.service.provider.internal.deploy.RepositoryManager;
import org.eclipse.rtp.core.model.Feature;
import org.eclipse.rtp.core.model.SourceVersion;

public class FeatureManager {
    private final IProvisioningAgent provisioningAgent;
    private final RepositoryManager repositoryManager;
    private final Configurator configurator;

    public FeatureManager(IProvisioningAgent provisioningAgent, RepositoryManager repositoryManager, Configurator configurator) {
        this.provisioningAgent = provisioningAgent;
        this.repositoryManager = repositoryManager;
        this.configurator = configurator;
    }

    public void installFeature(SourceVersion sourceVersion) throws FeatureInstallException {
        List<IInstallableUnit> unitsToUpdate = this.getUnitsToUpdate(sourceVersion, Action.INSTALL);
        if (unitsToUpdate.size() > 0) {
            ProfileChangeOperation operation = this.resolveProfileChangeOperation(unitsToUpdate, Action.INSTALL);
            this.executeProfileChangeOperation(operation);
            this.applyChanges();
        } else {
            System.out.println("Nothing found for installation");
        }
    }

    public void uninstallFeature(SourceVersion sourceVersion) throws FeatureInstallException {
        List<IInstallableUnit> unitsToUpdate = this.getUnitsToUpdate(sourceVersion, Action.UNINSTALL);
        if (unitsToUpdate.size() > 0) {
            ProfileChangeOperation operation = this.resolveProfileChangeOperation(unitsToUpdate, Action.UNINSTALL);
            this.executeProfileChangeOperation(operation);
            this.applyChanges();
        } else {
            System.out.println("Nothing found for uninstall");
        }
    }

    private ProfileChangeOperation resolveProfileChangeOperation(List<IInstallableUnit> unitsToInstall, Action action) throws FeatureInstallException {
        ProvisioningSession session = new ProvisioningSession(this.provisioningAgent);
        ProfileChangeOperation operation = this.getOperation(session, unitsToInstall, action);
        operation.setProvisioningContext(this.createProvisioningContext());
        this.resolveOperation(operation);
        return operation;
    }

    private List<IInstallableUnit> getUnitsToUpdate(SourceVersion sourceVersion, Action action) {
        ProvisioningContext context = this.createProvisioningContext();
        List features = sourceVersion.getFeatures();
        ArrayList<IInstallableUnit> unitsToInstall = new ArrayList<IInstallableUnit>();
        for (Feature feature : features) {
            Collection<IInstallableUnit> units = this.getInstallableUnits(context, feature.getId(), feature.getVersion(), action);
            unitsToInstall.addAll(units);
        }
        return unitsToInstall;
    }

    private ProfileChangeOperation getOperation(ProvisioningSession session, Collection<IInstallableUnit> units, Action action) throws FeatureInstallException {
        Object operation = action.equals((Object)Action.UNINSTALL) ? new UninstallOperation(session, units) : new InstallOperation(session, units);
        return operation;
    }

    private void resolveOperation(ProfileChangeOperation operation) throws FeatureInstallException {
        IStatus result = operation.resolveModal(null);
        if (!result.isOK()) {
            StringBuilder errorMessage = new StringBuilder();
            this.generateErrorMessage(result, errorMessage);
            throw new FeatureInstallException(errorMessage.toString());
        }
    }

    private void applyChanges() throws FeatureInstallException {
        try {
            this.configurator.applyConfiguration();
        }
        catch (IOException e) {
            throw new FeatureInstallException(e);
        }
    }

    protected ProvisioningContext createProvisioningContext() {
        ProvisioningContext context = new ProvisioningContext(this.provisioningAgent);
        context.setMetadataRepositories(this.repositoryManager.getRepositories());
        context.setArtifactRepositories(this.repositoryManager.getRepositories());
        return context;
    }

    protected void executeProfileChangeOperation(ProfileChangeOperation operation) throws FeatureInstallException {
        ProvisioningJob provisioningJob = operation.getProvisioningJob((IProgressMonitor)new NullProgressMonitor());
        if (provisioningJob == null) {
            return;
        }
        IStatus result = provisioningJob.runModal((IProgressMonitor)new NullProgressMonitor());
        if (!result.isOK()) {
            throw new FeatureInstallException(result.getMessage());
        }
    }

    protected void generateErrorMessage(IStatus result, StringBuilder message) {
        message.append(String.valueOf(result.getMessage()) + "\n");
        IStatus[] children = result.getChildren();
        int i = 0;
        while (i < children.length) {
            this.generateErrorMessage(children[i], message);
            ++i;
        }
    }

    protected Collection<IInstallableUnit> getInstallableUnits(ProvisioningContext context, String id, String version, Action action) {
        IProfile queryable = action == Action.INSTALL ? context.getMetadata((IProgressMonitor)new NullProgressMonitor()) : this.getProfile();
        Set toInstall = queryable.query(QueryUtil.createIUQuery((String)id, (Version)Version.create((String)version)), null).toUnmodifiableSet();
        return toInstall;
    }

    public IProfile getProfile() {
        IProfileRegistry profileRegistry = (IProfileRegistry)this.provisioningAgent.getService(IProfileRegistry.SERVICE_NAME);
        return profileRegistry.getProfile("_SELF_");
    }

    public boolean isInstalled(SourceVersion sourceVersion) {
        ArrayList result = new ArrayList();
        IProfile profile = this.getProfile();
        if (profile != null) {
            for (Feature feature : sourceVersion.getFeatures()) {
                IQueryResult query = profile.query(QueryUtil.createIUQuery((String)feature.getId(), (Version)Version.create((String)feature.getVersion())), (IProgressMonitor)new NullProgressMonitor());
                result.addAll(query.toSet());
            }
        }
        return result.size() > 0;
    }

    public static enum Action {
        UNINSTALL,
        INSTALL;

    }
}

