/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.p2.operations;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.equinox.internal.p2.director.ProfileChangeRequest;
import org.eclipse.equinox.internal.p2.metadata.query.UpdateQuery;
import org.eclipse.equinox.internal.p2.operations.Messages;
import org.eclipse.equinox.p2.engine.IProfile;
import org.eclipse.equinox.p2.engine.IProfileRegistry;
import org.eclipse.equinox.p2.engine.IProvisioningPlan;
import org.eclipse.equinox.p2.engine.query.IUProfilePropertyQuery;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.metadata.IRequirement;
import org.eclipse.equinox.p2.metadata.IVersionedId;
import org.eclipse.equinox.p2.metadata.MetadataFactory;
import org.eclipse.equinox.p2.metadata.Version;
import org.eclipse.equinox.p2.metadata.VersionRange;
import org.eclipse.equinox.p2.operations.ProfileChangeOperation;
import org.eclipse.equinox.p2.operations.ProvisioningSession;
import org.eclipse.equinox.p2.planner.IPlanner;
import org.eclipse.equinox.p2.planner.IProfileChangeRequest;
import org.eclipse.equinox.p2.planner.ProfileInclusionRules;
import org.eclipse.equinox.p2.query.CollectionResult;
import org.eclipse.equinox.p2.query.IQuery;
import org.eclipse.equinox.p2.query.IQueryResult;
import org.eclipse.equinox.p2.query.QueryUtil;

public class RelaxedUpdateInstallOperation
extends ProfileChangeOperation {
    public RelaxedUpdateInstallOperation(ProvisioningSession session) {
        super(session);
    }

    protected void computeProfileChangeRequest(MultiStatus status, IProgressMonitor monitor) {
        IQueryResult update;
        IInstallableUnit formerRoot;
        IProfileRegistry profileRegistry = (IProfileRegistry)this.session.getProvisioningAgent().getService(IProfileRegistry.SERVICE_NAME);
        IPlanner plan = (IPlanner)this.session.getProvisioningAgent().getService(IPlanner.SERVICE_NAME);
        IProfile prof = profileRegistry.getProfile(this.getProfileId());
        IQueryResult strictRoots = prof.query((IQuery)new IUProfilePropertyQuery("org.eclipse.equinox.p2.internal.inclusion.rules", "STRICT"), null);
        IQueryResult optionalRoots = prof.query((IQuery)new IUProfilePropertyQuery("org.eclipse.equinox.p2.internal.inclusion.rules", "OPTIONAL"), null);
        HashSet tmpRoots = new HashSet(strictRoots.toUnmodifiableSet());
        tmpRoots.addAll(optionalRoots.toUnmodifiableSet());
        CollectionResult allRoots = new CollectionResult(tmpRoots);
        this.request = (ProfileChangeRequest)plan.createChangeRequest(prof);
        ArrayList<IRequirement> limitingRequirements = new ArrayList<IRequirement>();
        Iterator iterator = allRoots.query(QueryUtil.ALL_UNITS, null).iterator();
        while (iterator.hasNext()) {
            IInstallableUnit currentlyInstalled = (IInstallableUnit)iterator.next();
            IQueryResult updatesAvailable = plan.updatesFor(currentlyInstalled, this.context, null);
            Iterator iterator2 = updatesAvailable.iterator();
            while (iterator2.hasNext()) {
                IInstallableUnit update2 = (IInstallableUnit)iterator2.next();
                this.request.add(update2);
                this.request.setInstallableUnitInclusionRules(update2, ProfileInclusionRules.createOptionalInclusionRule((IInstallableUnit)update2));
            }
            if (updatesAvailable.isEmpty()) continue;
            this.request.setInstallableUnitInclusionRules(currentlyInstalled, ProfileInclusionRules.createOptionalInclusionRule((IInstallableUnit)currentlyInstalled));
            limitingRequirements.add(MetadataFactory.createRequirement((String)"org.eclipse.equinox.p2.iu", (String)currentlyInstalled.getId(), (VersionRange)new VersionRange(currentlyInstalled.getVersion(), true, Version.MAX_VERSION, true), null, (boolean)false, (boolean)false));
        }
        IProvisioningPlan updateFinderPlan = plan.getProvisioningPlan((IProfileChangeRequest)this.request, this.context, null);
        if (updateFinderPlan.getAdditions().query(QueryUtil.ALL_UNITS, null).isEmpty()) {
            return;
        }
        IProfileChangeRequest finalChangeRequest = plan.createChangeRequest(prof);
        IQueryResult removals = updateFinderPlan.getRemovals().query(QueryUtil.ALL_UNITS, null);
        Iterator iterator2 = removals.iterator();
        while (iterator2.hasNext()) {
            IInstallableUnit iu = (IInstallableUnit)iterator2.next();
            if (allRoots.query(QueryUtil.createIUQuery((IVersionedId)iu), null).isEmpty()) continue;
            finalChangeRequest.remove(iu);
        }
        iterator2 = strictRoots.iterator();
        while (iterator2.hasNext()) {
            formerRoot = (IInstallableUnit)iterator2.next();
            update = updateFinderPlan.getAdditions().query((IQuery)new UpdateQuery(formerRoot), null);
            if (update.isEmpty()) continue;
            finalChangeRequest.addAll((Collection)update.toUnmodifiableSet());
        }
        iterator2 = optionalRoots.iterator();
        while (iterator2.hasNext()) {
            formerRoot = (IInstallableUnit)iterator2.next();
            update = updateFinderPlan.getAdditions().query((IQuery)new UpdateQuery(formerRoot), null);
            if (update.isEmpty()) continue;
            Iterator it = update.iterator();
            while (it.hasNext()) {
                IInstallableUnit updatedOptionalIU = (IInstallableUnit)it.next();
                finalChangeRequest.add(updatedOptionalIU);
                finalChangeRequest.setInstallableUnitInclusionRules(updatedOptionalIU, ProfileInclusionRules.createOptionalInclusionRule((IInstallableUnit)updatedOptionalIU));
            }
        }
        this.request = (ProfileChangeRequest)finalChangeRequest;
    }

    protected String getResolveJobName() {
        return Messages.RelaxedUpdateOperation_ResolveJobName;
    }

    protected String getProvisioningJobName() {
        return Messages.RelaxedUpdateOperation_UpdateJobName;
    }
}

