/*******************************************************************************
 * Copyright (c) 2011 EclipseSource and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    EclipseSource - initial API and implementation
 ******************************************************************************/

namespace( "org.eclipse.rwt.protocol" );

org.eclipse.rwt.protocol.ObjectManager = {

  _map : {},
  _callbacks : {},

  add : function( id, object, type ) {
    this._map[ id ] = {
      "object" : object,
      "type" : type
    };
    object._rwtId = id;
    if( this._callbacks[ id ] ) {
      for( var i = 0; i < this._callbacks[ id ].length; i++ ) {
        this._callbacks[ id ][ i ]( object );
      }
      delete this._callbacks[ id ];
    }
  },

  remove : function( id ) {
    if( id != null ) {
      delete this._map[ id ];
    }
  },

  getId : function( object ) {
    var result = null;
    if( object != null && object._rwtId != null ) {
      result = object._rwtId;
    }
    return result;
  },

  getObject : function( id ) {
    return this._map[ id ] ? this._map[ id ].object : undefined;
  },

  getType : function( id ) {
    return this._map[ id ] ? this._map[ id ].type : undefined;
  },

  addRegistrationCallback : function( id, fun ) {
    if( !this._callbacks[ id ] ) {
      this._callbacks[ id ] = [];
    }
    this._callbacks[ id ].push( fun );
  }

};
