/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rwt.internal.lifecycle;

import java.io.IOException;
import java.io.PrintWriter;
import javax.servlet.ServletResponse;
import org.eclipse.rwt.internal.protocol.ProtocolMessageWriter;

public class JavaScriptResponseWriter {
    public static final String PROCESS_MESSAGE = "org.eclipse.rwt.protocol.Processor.processMessage";
    private final PrintWriter writer;
    private ProtocolMessageWriter protocolWriter;

    public JavaScriptResponseWriter(ServletResponse response) throws IOException {
        JavaScriptResponseWriter.configureResponseContentEncoding(response);
        this.writer = response.getWriter();
    }

    public void write(String content) {
        this.writePendingProtocolMessage();
        this.writer.write(content);
    }

    public boolean checkError() {
        return this.writer.checkError();
    }

    public void finish() {
        this.writePendingProtocolMessage();
    }

    public ProtocolMessageWriter getProtocolWriter() {
        if (this.protocolWriter == null) {
            this.protocolWriter = new ProtocolMessageWriter();
        }
        return this.protocolWriter;
    }

    private void writePendingProtocolMessage() {
        if (this.protocolWriter != null) {
            this.writer.write("org.eclipse.rwt.protocol.Processor.processMessage( ");
            this.writer.write(this.protocolWriter.createMessage());
            this.writer.write(" );/*EOM*/");
        }
        this.protocolWriter = null;
    }

    private static void configureResponseContentEncoding(ServletResponse response) {
        response.setContentType("text/javascript");
        response.setCharacterEncoding("UTF-8");
    }
}

